/*
 * Decompiled with CFR 0.152.
 */
package r01f.jaxb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.generics.TypeRef;
import r01f.jaxb.MapAsCollectionWrapper;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.annotations.OidField;
import r01f.reflection.Reflection;
import r01f.reflection.ReflectionUtils;

public class MapXmlAdapterUtil {
    private static final Logger log = LoggerFactory.getLogger(MapXmlAdapterUtil.class);

    public static <K, V, W extends MapAsCollectionWrapper<V>> Map<K, V> unmarshal(W wrapper) throws Exception {
        System.out.print("------>");
        Collection<V> values = wrapper.getElements();
        HashMap<Object, V> outMap = new HashMap<Object, V>(values.size());
        for (V element : values) {
            Object key = null;
            if (element == null) continue;
            ReflectionUtils.FieldAnnotated<OidField>[] fieldsAnnotatedWithOid = ReflectionUtils.fieldsAnnotated(element.getClass(), OidField.class);
            String err = null;
            if (fieldsAnnotatedWithOid != null) {
                if (fieldsAnnotatedWithOid.length == 1) {
                    key = ReflectionUtils.fieldValue(element, fieldsAnnotatedWithOid[0].getField(), true);
                } else {
                    err = "NO se puede pasar un elemento XML a un Map (marshal) ya que el bean NO define ningun miembro oid utilizando la anotacion @OidField";
                }
            } else {
                err = "NO se puede pasar un elemento XML a un Map (marshal) ya que el bean NO define ningun miembro oid utilizando la anotacion @OidField";
            }
            if (key == null) {
                err = "NO se puede pasar un elemento XML a un Map (marshal) ya que el miembro oid (anotado con @OidField) es NULO!";
            }
            if (err != null) {
                log.error(err);
                throw new MarshallerException(err);
            }
            outMap.put(key, element);
        }
        System.out.println(outMap);
        return outMap;
    }

    public static <K, V, W extends MapAsCollectionWrapper<V>> W marshal(Map<K, V> map, TypeRef<W> wrapperType) throws Exception {
        MapAsCollectionWrapper wrapper = (MapAsCollectionWrapper)Reflection.type(wrapperType.rawType()).load(new Object[0]).instance();
        if (map != null) {
            wrapper.setElements(map.values());
        }
        System.out.println(map);
        return (W)wrapper;
    }
}

