/*
 * Decompiled with CFR 0.152.
 */
package r01f.jaxb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.jaxb.MapAsCollectionWrapper;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.annotations.OidField;
import r01f.reflection.ReflectionUtils;

public abstract class MapXmlAdapter<K, V, W extends MapAsCollectionWrapper<V>>
extends XmlAdapter<W, Map<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(MapXmlAdapter.class);

    public abstract W createMapWrapper();

    public Map<K, V> unmarshal(W wrapper) throws Exception {
        System.out.println("------>");
        Collection values = ((MapAsCollectionWrapper)wrapper).getElements();
        HashMap outMap = new HashMap(values.size());
        for (Object element : values) {
            Object key = null;
            if (element == null) continue;
            ReflectionUtils.FieldAnnotated<OidField>[] fieldsAnnotatedWithOid = ReflectionUtils.fieldsAnnotated(element.getClass(), OidField.class);
            String err = null;
            if (fieldsAnnotatedWithOid != null) {
                if (fieldsAnnotatedWithOid.length == 1) {
                    key = ReflectionUtils.fieldValue(element, fieldsAnnotatedWithOid[0].getField(), true);
                } else {
                    err = "NO se puede pasar un elemento XML a un Map (marshal) ya que el bean NO define ningun miembro oid utilizando la anotacion @OidField";
                }
            } else {
                err = "NO se puede pasar un elemento XML a un Map (marshal) ya que el bean NO define ningun miembro oid utilizando la anotacion @OidField";
            }
            if (key == null) {
                err = "NO se puede pasar un elemento XML a un Map (marshal) ya que el miembro oid (anotado con @OidField) es NULO!";
            }
            if (err != null) {
                log.error(err);
                throw new MarshallerException(err);
            }
            outMap.put(key, element);
        }
        return outMap;
    }

    public W marshal(Map<K, V> map) throws Exception {
        System.out.println("<---------");
        W wrapper = this.createMapWrapper();
        if (map != null) {
            ((MapAsCollectionWrapper)wrapper).setElements(map.values());
        }
        return wrapper;
    }
}

