/*
 * Decompiled with CFR 0.152.
 */
package r01f.jaxb;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import r01f.jaxb.MapAsCollectionWrapper;
import r01f.jaxb.MapXmlAdapter;
import r01f.marshalling.Marshaller;
import r01f.marshalling.annotations.OidField;
import r01f.util.types.Strings;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="test")
@XmlType(propOrder={"loader", "xmlPropertiesFileURL", "loaderProps"})
public class JaxbTest {
    @XmlElement(name="loader")
    private String loader;
    @XmlElement(name="fileURL")
    private String xmlPropertiesFileURL;
    @XmlElement(name="props")
    @XmlJavaTypeAdapter(value=MyMapXmlAdapter.class)
    private Map<String, MyProperty> loaderProps = new HashMap<String, MyProperty>();

    public static void main(String[] args) {
        boolean testJaxb = true;
        boolean testXO = false;
        try {
            int times = 1000;
            long[][] marks = new long[times][2];
            JaxbTest testObj = null;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{JaxbTest.class, MyProperty.class});
            javax.xml.bind.Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            String mapXml = JaxbTest._composeMapFile();
            Marshaller xoMarshaller = null;
            xoMarshaller.addBeans(Strings.of((CharSequence)mapXml).asInputStream());
            String xml = JaxbTest._composeXml();
            int i = 0;
            while (i < times) {
                long t2;
                long t1;
                if (testJaxb) {
                    System.out.print("...[JAXB]");
                    t1 = System.nanoTime();
                    testObj = (JaxbTest)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
                    t2 = System.nanoTime();
                    marks[i][0] = t2 - t1;
                    System.out.println("OK");
                }
                if (testXO) {
                    System.out.print("...[R01F]");
                    t1 = System.nanoTime();
                    testObj = (JaxbTest)xoMarshaller.beanFromXml(xml);
                    t2 = System.nanoTime();
                    marks[i][1] = t2 - t1;
                    System.out.println("OK");
                }
                testObj = JaxbTest._composeTestObj();
                marshaller.marshal((Object)testObj, (OutputStream)System.out);
                ++i;
            }
            System.out.println("\r\n\r\n\r\n\t[JAXB]\t\t[R01F]");
            long v1Avg = 0L;
            long v2Avg = 0L;
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            int i2 = 0;
            while (i2 < times) {
                System.out.println("<" + i2 + ">\t[" + nf.format(marks[i2][0]) + "]\t[" + nf.format(marks[i2][1]) + "]");
                if (i2 > 0) {
                    v2Avg += marks[i2][0];
                    v1Avg += marks[i2][1];
                }
                ++i2;
            }
            System.out.println("------------------------------");
            System.out.println("\t[" + nf.format(v2Avg / (long)times) + "]\t[" + nf.format(v1Avg / (long)times) + "]\r\n\r\n");
        }
        catch (Exception marshEx) {
            marshEx.printStackTrace(System.out);
        }
    }

    private static String _composeMapFile() {
        return Strings.create().add((CharSequence)"<classes>").add((CharSequence)"\t<class name='r01f.ejie.jaxb.JaxbTest' fromElement='test' useAccessors='true'>").add((CharSequence)"\t\t<member name='loader' dataType='String' fromElement='loader'/>").add((CharSequence)"\t\t<member name='xmlPropertiesFileURL' dataType='String' fromElement='fileURL'/>").add((CharSequence)"\t\t<member name='loaderProps' dataType='Map' fromElement='elements'/>").add((CharSequence)"\t</class>").add((CharSequence)"\t<class name='r01f.ejie.jaxb.JaxbTest$MyProperty' fromElement='prop' useAccessors='true'>").add((CharSequence)"\t\t<member name='id' dataType='String' fromAttribute='id' isOID='true'/>").add((CharSequence)"\t\t<member name='value' dataType='String' fromElement='prop'/>").add((CharSequence)"\t</class>").add((CharSequence)"</classes>").asString();
    }

    private static String _composeXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>");
        sb.append("<test>");
        sb.append("    <loader>theLoader</loader>");
        sb.append("    <fileURL>filePath</fileURL>");
        sb.append("    <elements>");
        sb.append("        <prop id='prop1'>prop1Value</prop>");
        sb.append("        <prop id='prop2'>prop2Value</prop>");
        sb.append("    </elements>");
        sb.append("</test>");
        return sb.toString();
    }

    public static JaxbTest _composeTestObj() {
        JaxbTest test = new JaxbTest();
        test.setLoader("theLoader");
        test.setXmlPropertiesFileURL("filePath");
        test.setLoaderProps(new HashMap<String, MyProperty>());
        test.getLoaderProps().put("prop1", new MyProperty("prop1", "prop1Value"));
        test.getLoaderProps().put("prop2", new MyProperty("prop2", "prop2Value"));
        return test;
    }

    public String getLoader() {
        return this.loader;
    }

    public void setLoader(String loader) {
        this.loader = loader;
    }

    public String getXmlPropertiesFileURL() {
        return this.xmlPropertiesFileURL;
    }

    public void setXmlPropertiesFileURL(String xmlPropertiesFileURL) {
        this.xmlPropertiesFileURL = xmlPropertiesFileURL;
    }

    public Map<String, MyProperty> getLoaderProps() {
        return this.loaderProps;
    }

    public void setLoaderProps(Map<String, MyProperty> loaderProps) {
        this.loaderProps = loaderProps;
    }

    public static class MyMapXmlAdapter<K, V>
    extends MapXmlAdapter<K, V, MyMapAsCollectionWrapper<V>> {
        @Override
        public MyMapAsCollectionWrapper<V> createMapWrapper() {
            return new MyMapAsCollectionWrapper();
        }

        public static class MyMapAsCollectionWrapper<T>
        extends MapAsCollectionWrapper<T> {
            private Collection<T> els;

            @Override
            @XmlElement(name="prop")
            public Collection<T> getElements() {
                return this.els;
            }

            @Override
            public void setElements(Collection<T> els) {
                this.els = els;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="Property")
    public static class MyProperty {
        @XmlAttribute
        @OidField
        private String id;
        @XmlValue
        private String value;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public MyProperty() {
        }

        @ConstructorProperties(value={"id", "value"})
        public MyProperty(String id, String value) {
            this.id = id;
            this.value = value;
        }
    }
}

