/*
 * Decompiled with CFR 0.152.
 */
package r01f.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import r01f.io.BytesChunkedIterator;

public class ByteStreamChunkedIterator
implements BytesChunkedIterator {
    private InputStream _is;
    private int _offset = 0;
    private int _block = 10240;

    public ByteStreamChunkedIterator() {
    }

    public ByteStreamChunkedIterator(InputStream is) {
        this.setInputStream(is);
    }

    public void setInputStream(InputStream theIs) {
        this._is = theIs;
    }

    @Override
    public int getOffset() {
        return this._offset;
    }

    @Override
    public void close() throws IOException {
        this._is.close();
    }

    @Override
    public byte[] next() {
        try {
            byte[] buff = new byte[this._block];
            int readed = this._is.read(buff);
            byte[] outBytes = readed > 0 ? Arrays.copyOf(buff, readed) : null;
            this._offset += readed;
            return outBytes;
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this._is.available() > 0;
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
            return false;
        }
    }

    @Override
    public void remove() {
    }
}

