/*
 * Decompiled with CFR 0.152.
 */
package r01f.io;

import java.io.IOException;
import java.util.Arrays;
import r01f.io.BytesChunkedIterator;

public class ByteArrayChunkedIterator
implements BytesChunkedIterator {
    private byte[] _bytes;
    private int _initOffset = 0;
    private int _endOffset = 0;
    private int _block = 10240;

    public ByteArrayChunkedIterator() {
    }

    public ByteArrayChunkedIterator(byte[] bytes) {
        this.setBytes(bytes);
    }

    public void setBytes(byte[] bytes) {
        this._bytes = bytes;
        this._computeBlockSize();
    }

    @Override
    public int getOffset() {
        return this._endOffset;
    }

    @Override
    public void close() throws IOException {
    }

    private void _computeBlockSize() {
        this._block = this._bytes.length > 1022976 ? 102400 : this._bytes.length;
    }

    @Override
    public byte[] next() {
        this._initOffset = this._endOffset;
        byte[] outBytes = null;
        if (this.hasNext()) {
            outBytes = Arrays.copyOfRange(this._bytes, this._initOffset, this._initOffset + this._block);
            this._endOffset += this._block;
            if (this._endOffset + this._block > this._bytes.length) {
                this._block = this._bytes.length - this._endOffset;
            }
        }
        return outBytes;
    }

    @Override
    public boolean hasNext() {
        return this._endOffset < this._bytes.length;
    }

    @Override
    public void remove() {
    }
}

