/*
 * Decompiled with CFR 0.152.
 */
package r01f.internal;

import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import r01f.marshalling.MarsallerGuiceModule;
import r01f.marshalling.Marshaller;
import r01f.marshalling.MarshallerException;
import r01f.marshalling.annotations.SingleUseSimpleMarshaller;
import r01f.util.types.Strings;

public class BuiltInObjectsMarshaller {
    public static Marshaller instance() {
        return MarshallerSingleton.MARSHALLER.instance();
    }

    private static enum MarshallerSingleton {
        MARSHALLER;

        private final Marshaller _marshallerInstance = MarshallerSingleton._createMarshaller();

        public Marshaller instance() {
            return this._marshallerInstance;
        }

        private static Marshaller _createMarshaller() {
            Marshaller marshaller = null;
            try {
                String mappingXml = MarshallerSingleton._composeMarshallingMappings();
                marshaller = (Marshaller)Guice.createInjector((Module[])new Module[]{new MarsallerGuiceModule()}).getInstance(Key.get(Marshaller.class, SingleUseSimpleMarshaller.class));
                marshaller.addBeans(Strings.of((CharSequence)mappingXml).asInputStream());
            }
            catch (MarshallerException marshallerException) {
                // empty catch block
            }
            return marshaller;
        }

        private static String _composeMarshallingMappings() {
            StringBuilder mapXML = new StringBuilder();
            mapXML.append("<classes>").append("\t\t<class name='r01f.xmlproperties.XMLPropertiesComponentDef' fromElement='componentDef' useAccessors='true'>").append("\t\t\t<member name='name' dataType='String' fromAttribute='name'/>").append("\t\t\t<member name='propertiesFileURI' dataType='String' fromElement='propertiesFileURI'/>").append("\t\t\t<member name='numberOfPropertiesEstimation' dataType='int' fromElement='numberOfPropertiesEstimation'/>").append("\t\t\t<member name='loaderDef' dataType='r01f.resources.ResourcesLoaderDef' ").append("                 fromElement='resourcesLoader'/>").append("     </class>").append("\t\t<class name='r01f.resources.ResourcesLoaderDef' fromElement='resourcesLoader' useAccessors='true'>").append("\t\t\t<member name='name' dataType='String' fromAttribute='name'/>").append("\t\t\t<member name='loader' dataType='Enum(r01f.resources.ResourcesLoaderDef$ResourcesLoaderType)'").append(" \t\t\t\tfromAttribute='type'/>").append("\t\t\t<member name='loaderProps' dataType='Map(String,String)' ").append("                 fromElement='props'/>").append("\t\t\t<member name='reloadControlDef' dataType='r01f.resources.ResourcesReloadControlDef' ").append("                 fromElement='reloadControl'/>").append("     </class>").append("\t\t<class name='r01f.resources.ResourcesReloadControlDef' fromElement='reloadControl' useAccessors='true'>").append("\t\t\t<member name='enabled' dataType='boolean' fromAttribute='enabled'/>").append("\t\t\t<member name='checkInterval' dataType='String' fromAttribute='checkInterval'/>").append("\t\t\t<member name='impl' dataType='Enum(r01f.resources.ResourcesReloadControlDef$ResourcesReloadPolicy)'").append(" \t\t\t\tfromAttribute='impl'/>").append("\t\t\t<member name='controlProps' dataType='Map(String,String)' ").append("                 fromElement='props'/>").append("     </class>").append("</classes>");
            return mapXML.toString();
        }
    }
}

