/*
 * Decompiled with CFR 0.152.
 */
package r01f.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Encoder;
import sun.net.www.protocol.http.HttpURLConnection;

public class SSLTunnelSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory _dfactory;
    private String _proxyHost;
    private int _proxyPort;
    private String _proxyUser;
    private String _proxyPassword;

    public SSLTunnelSocketFactory(String proxyHost, String proxyPort, String usr, String pwd) {
        this._proxyUser = usr;
        this._proxyPassword = pwd;
        this._proxyHost = proxyHost;
        this._proxyPort = Integer.parseInt(proxyPort);
        this._dfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    @Override
    public Socket createSocket(String remoteHost, int remotePort) throws IOException, UnknownHostException {
        return this.createSocket(null, remoteHost, remotePort, true);
    }

    @Override
    public Socket createSocket(InetAddress remoteHostAddr, int remotePort) throws IOException {
        return this.createSocket(null, remoteHostAddr.getHostName(), remotePort, true);
    }

    @Override
    public Socket createSocket(String remoteHost, int remotePort, InetAddress proxyAddr, int proxyPort) throws IOException, UnknownHostException {
        if (proxyAddr != null) {
            this._proxyHost = proxyAddr.getHostName();
        }
        this._proxyPort = proxyPort;
        return this.createSocket(null, remoteHost, remotePort, true);
    }

    @Override
    public Socket createSocket(InetAddress remoteHostAddr, int remotePort, InetAddress proxyAddr, int proxyPort) throws IOException {
        if (proxyAddr != null) {
            this._proxyHost = proxyAddr.getHostName();
        }
        this._proxyPort = proxyPort;
        return this.createSocket(null, remoteHostAddr.getHostName(), remotePort, true);
    }

    @Override
    public Socket createSocket(Socket socket, String remoteHost, int remotePort, boolean flag) throws IOException, UnknownHostException {
        Socket proxySocket = socket != null ? socket : new Socket(this._proxyHost, this._proxyPort);
        this._doTunnelHandshake(proxySocket, remoteHost, remotePort);
        SSLSocket sslsocket = (SSLSocket)this._dfactory.createSocket(proxySocket, remoteHost, remotePort, flag);
        return sslsocket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this._dfactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this._dfactory.getSupportedCipherSuites();
    }

    public String toString() {
        return "  <SSLTunnelSocketFactory proxyPort=" + this._proxyPort + " proxyHost=" + this._proxyHost + " delegate=" + this._dfactory + "/>";
    }

    public void setDelegateFactory(SSLSocketFactory sslsocketfactory) {
        this._dfactory = sslsocketfactory;
    }

    public void setProxyAuth(String usr, String pwd) {
        this._proxyUser = usr;
        this._proxyPassword = pwd;
    }

    private void _doTunnelHandshake(Socket proxySocket, String host, int port) throws IOException {
        OutputStream outputstream = proxySocket.getOutputStream();
        try {
            block17: {
                byte[] abyte0;
                String s1 = "";
                if (this._proxyUser != null) {
                    s1 = "Proxy-Authorization: Basic " + new BASE64Encoder().encodeBuffer((String.valueOf(this._proxyUser) + ":" + this._proxyPassword).getBytes()) + "\r\n";
                }
                String s2 = "CONNECT " + host + ":" + port + " HTTP/1.0\n" + s1 + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                try {
                    abyte0 = s2.getBytes("ASCII7");
                }
                catch (UnsupportedEncodingException unsupportedencodingexception) {
                    abyte0 = s2.getBytes();
                }
                outputstream.write(abyte0);
                outputstream.flush();
                byte[] abyte1 = new byte[200];
                int j = 0;
                int k = 0;
                boolean flag = false;
                InputStream inputstream = proxySocket.getInputStream();
                try {
                    String s3;
                    while (k < 2) {
                        int l = inputstream.read();
                        if (l < 0) {
                            throw new IOException("Unexpected EOF from proxy");
                        }
                        if (l == 10) {
                            flag = true;
                            ++k;
                            continue;
                        }
                        if (l == 13) continue;
                        k = 0;
                        if (flag || j >= abyte1.length) continue;
                        abyte1[j++] = (byte)l;
                    }
                    try {
                        s3 = new String(abyte1, 0, j, "ASCII7");
                    }
                    catch (UnsupportedEncodingException unsupportedencodingexception1) {
                        s3 = new String(abyte1, 0, j);
                    }
                    if (s3.toLowerCase().indexOf(" 200 ") == -1) {
                        throw new IOException("Unable to tunnel through " + this._proxyHost + ":" + this._proxyPort + ".  Proxy returns \"" + s3 + "\"");
                    }
                    if (Collections.singletonList(inputstream).get(0) == null) break block17;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(inputstream).get(0) != null) {
                        inputstream.close();
                    }
                    throw throwable;
                }
                inputstream.close();
            }
            return;
        }
        finally {
            if (Collections.singletonList(outputstream).get(0) != null) {
                outputstream.close();
            }
        }
    }
}

