/*
 * Decompiled with CFR 0.152.
 */
package r01f.httpclient;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import r01f.httpclient.BaseConnectionRetriever;
import r01f.httpclient.SSLTunnelSocketFactory;

public class HttpsConnectionRetriever
extends BaseConnectionRetriever {
    private boolean _streamHandlerInitialized = false;
    private static String _httpsDefaultConnectionClass = "javax.net.ssl.HttpsURLConnection";
    private static String _httpsSunConnectionClass = "com.sun.net.ssl.HttpsURLConnection";
    private static String _httpsIBMConnectionClass = "com.ibm.net.ssl.HttpsURLConnection";
    private static String _sunURLStreamHandler = "com.sun.net.ssl.internal.www.protocol.https.Handler";
    private static String _ibmURLStreamHandler = "com.ibm.net.ssl.internal.www.protocol.https.Handler";

    @Override
    public HttpURLConnection _retrieveConnection(String urlStr, String proxyHost, String proxyPort, String proxyUser, String proxyPassword) throws IOException {
        HttpsConnectionRetriever._initProxyInfo(proxyHost, proxyPort, proxyUser, proxyPassword);
        URLStreamHandler streamHandler = HttpsConnectionRetriever._getURLStreamHandler();
        URL theURL = new URL(null, urlStr, streamHandler);
        theURL = new URL(theURL, theURL.toExternalForm(), streamHandler);
        URLConnection conx = theURL.openConnection();
        if (proxyHost != null) {
            String szVendor;
            String connectionClassName = _httpsDefaultConnectionClass;
            connectionClassName = HttpsConnectionRetriever._isHttpsDefaultConnectionInstance(conx.getClass()) ? _httpsDefaultConnectionClass : (HttpsConnectionRetriever._isSunConnectionInstance(conx.getClass()) ? _httpsSunConnectionClass : (-1 < (szVendor = System.getProperty("java.vendor")).indexOf("SUN") ? _httpsSunConnectionClass : (-1 < szVendor.indexOf("IBM") ? _httpsIBMConnectionClass : _httpsSunConnectionClass)));
            SSLTunnelSocketFactory tunnelSocketFactory = new SSLTunnelSocketFactory(proxyHost, proxyPort, proxyUser, proxyPassword);
            HttpsConnectionRetriever._invokeSSLFactoryMethod(connectionClassName, conx, tunnelSocketFactory);
        }
        return (HttpURLConnection)conx;
    }

    private static URLStreamHandler _getURLStreamHandler() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String szVendor = System.getProperty("java.vendor");
        String streamHandlerClass = _sunURLStreamHandler;
        try {
            streamHandlerClass = -1 < szVendor.indexOf("Sun") ? _sunURLStreamHandler : (-1 < szVendor.indexOf("IBM") ? _ibmURLStreamHandler : _sunURLStreamHandler);
            return (URLStreamHandler)cl.loadClass(streamHandlerClass).newInstance();
        }
        catch (ClassNotFoundException cnfEx) {
            throw new IOException("NO se ha podido cargar la clase streamHandlerSSL '" + streamHandlerClass + "': " + cnfEx.getMessage(), cnfEx);
        }
        catch (InstantiationException instEx) {
            throw new IOException("NO se ha podido instanciar la clase streamHandlerSSL '" + streamHandlerClass + "': " + instEx.getMessage(), instEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new IOException("Acceso ilegal a la clase streamHandlerSSL '" + streamHandlerClass + "': " + illAccEx.getMessage(), illAccEx);
        }
    }

    private static void _invokeSSLFactoryMethod(String connectionClassName, URLConnection conx, SSLSocketFactory theSocketFactory) throws IOException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Method setSSLSocketFactoryMethod = cl.loadClass(connectionClassName).getMethod("setSSLSocketFactory", SSLSocketFactory.class);
            setSSLSocketFactoryMethod.invoke((Object)conx, theSocketFactory);
        }
        catch (ClassNotFoundException cnfEx) {
            cnfEx.printStackTrace(System.out);
            throw new IOException("getSSLMethodByClassNameclassName:" + connectionClassName + cnfEx.getMessage(), cnfEx);
        }
        catch (SecurityException secEx) {
            throw new IOException("getSSLMethodByClassNameclassName:" + connectionClassName + secEx.getMessage(), secEx);
        }
        catch (NoSuchMethodException nsmEx) {
            nsmEx.printStackTrace(System.out);
            throw new IOException("getSSLMethodByClassNameclassName:" + connectionClassName + nsmEx.getMessage(), nsmEx);
        }
        catch (InvocationTargetException invTgtEx) {
            invTgtEx.printStackTrace(System.out);
            throw new IOException("getSSLMethodByClassNameclassName:" + connectionClassName + invTgtEx.getMessage(), invTgtEx);
        }
        catch (IllegalAccessException illAccEx) {
            illAccEx.printStackTrace(System.out);
            throw new IOException("getSSLMethodByClassNameclassName:" + connectionClassName + illAccEx.getMessage(), illAccEx);
        }
    }

    private static boolean _isHttpsDefaultConnectionInstance(Class<?> classInstance) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> httpsDefaultConnectionClass = cl.loadClass(_httpsDefaultConnectionClass);
            return httpsDefaultConnectionClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException cnfEx) {
            return false;
        }
    }

    private static boolean _isSunConnectionInstance(Class<?> classInstance) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> sunConnectionClass = cl.loadClass(_httpsSunConnectionClass);
            return sunConnectionClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException cnfEx) {
            return false;
        }
    }

    private static boolean _isIBMClassInstance(Class<?> classInstance) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> ibmConnectionClass = cl.loadClass(_httpsIBMConnectionClass);
            return ibmConnectionClass.isAssignableFrom(classInstance);
        }
        catch (ClassNotFoundException cnfEx) {
            return false;
        }
    }

    private void _loadStreamHandler() {
        if (!this._streamHandlerInitialized) {
            this._streamHandlerInitialized = false;
            String szVendor = System.getProperty("java.vendor");
            String szVersion = System.getProperty("java.version");
            Double dVersion = new Double(szVersion.substring(0, 3));
            if (-1 < szVendor.indexOf("Microsoft")) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clsFactory = cl.loadClass("com.ms.net.wininet.WininetStreamHandlerFactory");
                    if (clsFactory != null) {
                        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)clsFactory.newInstance());
                    }
                    this._streamHandlerInitialized = true;
                }
                catch (ClassNotFoundException cfe) {
                    throw new RuntimeException("No se puede cargar el Stream Handler para SSL de Microsoft. Verifica el classpath para poder acceder a com.ms.net.wininet.WininetStreamHandlerFactory" + cfe.toString());
                }
                catch (InstantiationException instEx) {
                    throw new RuntimeException("No se puede instanciar el Stream Handler SSL de Microsoft: " + instEx.toString());
                }
                catch (IllegalAccessException illAccEx) {
                    throw new RuntimeException("Aceso ilegal al Stream Handler SSL de Microsoft: " + illAccEx.toString());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error desconocido al cargar la clase StreamHandler SSL de Microsoft: " + ex.toString());
                }
            }
            if (1.2 <= dVersion) {
                String JSSE_HANDLER = "com.sun.net.ssl.internal.www.protocol";
                String WLS_HANDLER = "weblogic.net";
                String handler = System.getProperty("weblogic.class.path") != null ? "weblogic.net" : "com.sun.net.ssl.internal.www.protocol";
                Properties sysProps = System.getProperties();
                String handlerValue = sysProps.getProperty("java.protocol.handler.pkgs");
                if (handlerValue == null) {
                    handlerValue = handler;
                } else if (handlerValue.indexOf(handler) == -1) {
                    handlerValue = String.valueOf(handlerValue) + "|" + handler;
                }
                sysProps.put("java.protocol.handler.pkgs", handlerValue);
                System.setProperties(sysProps);
                if (handler.equals("weblogic.net")) {
                    return;
                }
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> clsFactory = cl.loadClass("com.sun.net.ssl.internal.ssl.Provider");
                    if (clsFactory != null && Security.getProvider("SunJSSE") == null) {
                        Security.addProvider((Provider)clsFactory.newInstance());
                    }
                    this._streamHandlerInitialized = true;
                }
                catch (ClassNotFoundException cfe) {
                    throw new RuntimeException("No se ha podido cargar el Stream Handler de J2EE, verifica que la clase com.sun.net.ssl.internal.ssl.Provider esta accesible en el classpath" + cfe.getMessage());
                }
                catch (InstantiationException instEx) {
                    throw new RuntimeException("No se puede instanciar el Stream Handler SSL de de J2EE: " + instEx.getMessage());
                }
                catch (IllegalAccessException illAccEx) {
                    throw new RuntimeException("Aceso ilegal al Stream Handler SSL de J2EE: " + illAccEx.getMessage());
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error desconocido al cargar la clase StreamHandler SSL: " + ex.getMessage());
                }
            }
        }
    }
}

