/*
 * Decompiled with CFR 0.152.
 */
package r01f.httpclient;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import r01f.httpclient.BaseConnectionRetriever;
import r01f.httpclient.HttpConnectionRetriever;
import r01f.httpclient.HttpMethodStatement;
import r01f.httpclient.HttpRequestBinaryParameter;
import r01f.httpclient.HttpRequestParameter;
import r01f.httpclient.HttpRequestStringParameter;
import r01f.httpclient.HttpsConnectionRetriever;

public class HttpResponseStatement {
    private String targetUrlStr;
    private Charset targetServerCharset;
    private List<HttpRequestParameter> parameters;
    private HttpMethodStatement.RequestMethod requestMethod = HttpMethodStatement.RequestMethod.GET;
    private Map<String, String> requestHeaders;
    private long timeout = -1L;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private boolean _connected = false;
    private HttpURLConnection _conx;

    HttpResponseStatement(String theTargetUrlStr, Charset theTargetServerCharset, long theTimeout, List<HttpRequestParameter> newParameters, HttpMethodStatement.RequestMethod newRequestMethod, Map<String, String> newRequestHeaders, String newProxyHost, String newProxyPort, String newProxyUser, String newProxyPassword) {
        this.targetUrlStr = theTargetUrlStr;
        this.targetServerCharset = theTargetServerCharset;
        this.timeout = theTimeout;
        this.parameters = newParameters;
        this.requestMethod = newRequestMethod;
        this.requestHeaders = newRequestHeaders;
        this.proxyHost = newProxyHost;
        this.proxyPort = newProxyPort;
        this.proxyUser = newProxyUser;
        this.proxyPassword = newProxyPassword;
    }

    public HttpURLConnection getConnection() throws IOException {
        if (!this._connected) {
            this._doRequest();
        }
        return this._conx;
    }

    private void _doRequest() throws IOException {
        BaseConnectionRetriever connectionRetriever;
        HttpURLConnection conx = null;
        if (this.targetUrlStr.startsWith("https")) {
            connectionRetriever = new HttpsConnectionRetriever();
            conx = ((HttpsConnectionRetriever)connectionRetriever).getConnection(this.targetUrlStr, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
        } else if (this.targetUrlStr.startsWith("http")) {
            connectionRetriever = new HttpConnectionRetriever();
            conx = connectionRetriever.getConnection(this.targetUrlStr, this.timeout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword);
        } else {
            throw new IOException("NO se soporta el protocolo especificado en la url: '" + this.targetUrlStr + "'");
        }
        if (conx == null) {
            throw new IOException("No se ha podido obtener una conexi\u00f3n con '" + this.targetUrlStr + "'");
        }
        conx.setDoInput(true);
        conx.setUseCaches(false);
        if (this.requestMethod == HttpMethodStatement.RequestMethod.POST) {
            conx.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        this._sendHeaders(conx);
        if (this.requestMethod == HttpMethodStatement.RequestMethod.POST && this.parameters != null) {
            DataOutputStream out = new DataOutputStream(conx.getOutputStream());
            this._writeParamsToDataOutputStream(out);
            out.flush();
            out.close();
        }
        this._conx = conx;
        Authenticator.setDefault(null);
    }

    private void _sendHeaders(URLConnection conx) {
        if (this.requestHeaders != null) {
            for (Map.Entry<String, String> me : this.requestHeaders.entrySet()) {
                conx.setRequestProperty(me.getKey(), me.getValue());
            }
        }
    }

    private void _writeParamsToDataOutputStream(DataOutputStream dos) throws IOException {
        if (this.parameters == null || this.parameters.size() == 0) {
            return;
        }
        Iterable stringParamsIt = Iterables.filter((Iterable)ImmutableList.copyOf(this.parameters), (Predicate)new Predicate<HttpRequestParameter>(){

            public boolean apply(HttpRequestParameter input) {
                return input instanceof HttpRequestStringParameter;
            }
        });
        for (HttpRequestParameter param : stringParamsIt) {
            if (param.getInputStream(this.targetServerCharset) == null) continue;
            this._writeParamToDataOutputStream(dos, param);
        }
        Iterable binaryParamsIt = Iterables.filter((Iterable)ImmutableList.copyOf(this.parameters), (Predicate)new Predicate<HttpRequestParameter>(){

            public boolean apply(HttpRequestParameter input) {
                return input instanceof HttpRequestBinaryParameter;
            }
        });
        for (HttpRequestParameter param : binaryParamsIt) {
            if (param.getInputStream(this.targetServerCharset) == null) continue;
            this._writeParamToDataOutputStream(dos, param);
        }
    }

    private void _writeParamToDataOutputStream(DataOutputStream dos, HttpRequestParameter param) throws IOException {
        InputStream is = param.getInputStream(this.targetServerCharset);
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        int maxBufferSize = 0x100000;
        dos.writeBytes(String.valueOf(twoHyphens) + boundary + lineEnd);
        dos.writeBytes("Content-Disposition: form-data; name=\"" + param.getName() + "\"" + lineEnd);
        dos.writeBytes(lineEnd);
        int bytesAvailable = is.available();
        int bufferSize = Math.min(bytesAvailable, maxBufferSize);
        byte[] buffer = new byte[bufferSize];
        int bytesRead = is.read(buffer, 0, bufferSize);
        while (bytesRead > 0) {
            dos.write(buffer, 0, bufferSize);
            bytesAvailable = is.available();
            bufferSize = Math.min(bytesAvailable, maxBufferSize);
            bytesRead = is.read(buffer, 0, bufferSize);
        }
        dos.writeBytes(lineEnd);
        dos.writeBytes(String.valueOf(twoHyphens) + boundary + twoHyphens + lineEnd);
        is.close();
    }
}

