/*
 * Decompiled with CFR 0.152.
 */
package r01f.httpclient;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.EncoderException;
import r01f.httpclient.HttpConnectionStatement;
import r01f.httpclient.HttpRequestParameter;
import r01f.httpclient.HttpRequestStringParameter;
import r01f.util.types.Strings;

public class HttpMethodStatement {
    private String _targetURLStr;
    private Charset _targetServerCharset;
    private List<HttpRequestParameter> _parameters;
    private RequestMethod _requestMethod = RequestMethod.GET;

    HttpMethodStatement(String newTargetURLStr, Charset newTargetServerCharset, List<HttpRequestParameter> newParams) {
        this._targetURLStr = newTargetURLStr;
        this._targetServerCharset = newTargetServerCharset;
        this._parameters = newParams;
    }

    public HttpConnectionStatement usingGETRequestMethod() {
        return this.usingGETRequestMethod(true);
    }

    public HttpConnectionStatement usingGETRequestMethod(boolean encodeParamValues) {
        this._requestMethod = RequestMethod.GET;
        String completeURL = this._completeUrl(encodeParamValues);
        return new HttpConnectionStatement(completeURL, this._targetServerCharset, null, this._requestMethod);
    }

    public HttpConnectionStatement usingPOSTRequestMethod() {
        this._requestMethod = RequestMethod.POST;
        return new HttpConnectionStatement(this._targetURLStr, this._targetServerCharset, this._parameters, this._requestMethod);
    }

    public String debugURL(boolean encodeParamValues) {
        return this._completeUrl(encodeParamValues);
    }

    private String _completeUrl(boolean encodeParamValues) {
        String completeURL = this._targetURLStr;
        String parameters = this._notBinaryParametersAsQueryString(encodeParamValues);
        if (!Strings.isNullOrEmpty(parameters)) {
            completeURL = String.valueOf(this._targetURLStr) + (completeURL.indexOf("?") < 0 ? "?" : "&") + parameters;
        }
        return completeURL;
    }

    private String _notBinaryParametersAsQueryString(boolean encodeParamValues) {
        if (this._parameters == null || this._parameters.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this._parameters.size() * 10);
        Iterable stringParamsIt = Iterables.filter((Iterable)ImmutableList.copyOf(this._parameters), (Predicate)new Predicate<HttpRequestParameter>(){

            public boolean apply(HttpRequestParameter input) {
                return input instanceof HttpRequestStringParameter;
            }
        });
        Iterator it = stringParamsIt.iterator();
        while (it.hasNext()) {
            HttpRequestStringParameter param = (HttpRequestStringParameter)it.next();
            try {
                sb.append(Strings.of((CharSequence)param.getName()).urlEncode().encodeISO8859());
                sb.append('=');
                if (encodeParamValues) {
                    sb.append(Strings.of((CharSequence)param.getValue()).urlEncode().encodeISO8859());
                } else {
                    sb.append(Strings.of((CharSequence)param.getValue()));
                }
            }
            catch (EncoderException encEx) {
                sb.append(Strings.of((CharSequence)param.getName()).encodeISO8859());
                sb.append('=');
                if (encodeParamValues) {
                    sb.append(Strings.of((CharSequence)param.getValue()).encodeISO8859());
                }
                sb.append(Strings.of((CharSequence)param.getValue()));
            }
            if (!it.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    public static enum RequestMethod {
        POST,
        GET;

    }
}

