/*
 * Decompiled with CFR 0.152.
 */
package r01f.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import r01f.httpclient.HttpMethodStatement;
import r01f.httpclient.HttpRequestParameter;
import r01f.httpclient.HttpResponseStatement;
import r01f.util.types.Strings;

public class HttpConnectionStatement {
    private String targetUrlStr;
    private Charset targetServerCharset;
    private List<HttpRequestParameter> parameters = null;
    private HttpMethodStatement.RequestMethod requestMethod = HttpMethodStatement.RequestMethod.GET;
    private Map<String, String> requestHeaders;
    private long timeout = -1L;
    private String proxyHost;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;

    HttpConnectionStatement(String newTargetUrlStr, Charset newTargetServerCharset, List<HttpRequestParameter> newParams, HttpMethodStatement.RequestMethod newMethod) {
        this.targetUrlStr = newTargetUrlStr;
        this.targetServerCharset = newTargetServerCharset;
        this.parameters = newParams;
        this.requestMethod = newMethod;
    }

    public HttpConnectionStatement withConnectionTimeOut(long timeOutMillis) {
        this.timeout = timeOutMillis;
        return this;
    }

    public HttpConnectionStatement usingProxy(String theProxyHost, String theProxyPort, String theUser, String thePassword) {
        this.proxyHost = theProxyHost;
        this.proxyPort = theProxyPort;
        this.proxyUser = theUser;
        this.proxyPassword = thePassword;
        String authString = String.valueOf(this.proxyUser) + ":" + this.proxyPassword;
        String authStringEncoded = new String(Base64.encodeBase64((byte[])authString.getBytes()));
        this._setHeader("Proxy-Authorization", "Basic " + authStringEncoded);
        return this;
    }

    public HttpConnectionStatement notUsingProxy() {
        return this;
    }

    public HttpConnectionStatement settingCookies(Map<String, String> cookies) {
        if (cookies == null || cookies.size() == 0) {
            return this;
        }
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap<String, String>();
        }
        StringBuilder cookiesStr = new StringBuilder(cookies.size() * 15);
        Iterator<Map.Entry<String, String>> it = cookies.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> cookie = it.next();
            cookiesStr.append(String.valueOf(cookie.getKey()) + "=" + cookie.getValue());
            if (!it.hasNext()) continue;
            cookiesStr.append(";");
        }
        this._setHeader("Cookie", cookiesStr.toString());
        return this;
    }

    public HttpURLConnection getConnection() throws IOException {
        return new HttpResponseStatement(this.targetUrlStr, this.targetServerCharset, this.timeout, this.parameters, this.requestMethod, this.requestHeaders, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword).getConnection();
    }

    public String loadAsString() throws IOException {
        InputStream responseIs = this.loadAsStream();
        try {
            String outStr;
            String string = outStr = Strings.load(responseIs).asString();
            return string;
        }
        finally {
            if (Collections.singletonList(responseIs).get(0) != null) {
                responseIs.close();
            }
        }
    }

    public InputStream loadAsStream() throws IOException {
        InputStream responseIs = this.getConnection().getInputStream();
        return responseIs;
    }

    public String debugURL() {
        return this.targetUrlStr;
    }

    private void _setHeader(String name, String value) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new HashMap<String, String>();
        }
        this.requestHeaders.put(name, value);
    }
}

