/*
 * Decompiled with CFR 0.152.
 */
package r01f.httpclient;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import r01f.process.TimeOutController;
import r01f.util.types.Strings;

abstract class BaseConnectionRetriever {
    private static String JDK_VERSION = null;
    protected static boolean JDK_VERSION_5_OR_HIGHER = false;

    static {
        try {
            JDK_VERSION = System.getProperty("java.version");
            String[] versionCod = JDK_VERSION.split("\\.");
            int versionNum = new Integer(versionCod[1]);
            if (versionNum >= 5) {
                JDK_VERSION_5_OR_HIGHER = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    BaseConnectionRetriever() {
    }

    public HttpURLConnection getConnection(final String urlStr, long timeout, final String proxyHost, final String proxyPort, final String proxyUser, final String proxyPassword) throws IOException {
        HttpURLConnection outConx = null;
        if (timeout < 0L) {
            outConx = this._retrieveConnection(urlStr, proxyHost, proxyPort, proxyUser, proxyPassword);
        } else {
            try {
                ObtainConnectionTask task = new ObtainConnectionTask(){

                    @Override
                    public void doit() throws IOException {
                        this.conx = BaseConnectionRetriever.this._retrieveConnection(urlStr, proxyHost, proxyPort, proxyUser, proxyPassword);
                    }
                };
                TimeOutController.execute(task, timeout);
                outConx = task.conx;
                if (task.ioException != null) {
                    throw task.ioException;
                }
            }
            catch (TimeOutController.TimeoutException timeOutEx) {
                throw new IOException("No se ha podido obtener la conexi\u00f3n con el host '" + urlStr + "' en el tiempo especificado: " + timeout + " millis");
            }
        }
        return outConx;
    }

    public abstract HttpURLConnection _retrieveConnection(String var1, String var2, String var3, String var4, String var5) throws IOException;

    static void _initProxyInfo(String proxyHost, String proxyPort, final String proxyUser, final String proxyPassword) {
        if (Strings.isNullOrEmpty(proxyHost)) {
            return;
        }
        System.clearProperty("proxySet");
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        if (JDK_VERSION_5_OR_HIGHER) {
            try {
                if (!Strings.isNullOrEmpty(proxyHost)) {
                    System.setProperty("proxySet", "true");
                    System.setProperty("http.proxyHost", proxyHost);
                    System.setProperty("http.proxyPort", proxyPort);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Strings.isNullOrEmpty(proxyUser) && !Strings.isNullOrEmpty(proxyPassword)) {
            try {
                if (JDK_VERSION_5_OR_HIGHER) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                        }
                    });
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (JDK_VERSION_5_OR_HIGHER) {
            Authenticator.setDefault(new Authenticator(){});
        }
    }

    abstract class ObtainConnectionTask
    implements Runnable {
        public HttpURLConnection conx;
        public IOException ioException;

        ObtainConnectionTask() {
        }

        public abstract void doit() throws IOException;

        @Override
        public void run() {
            try {
                this.doit();
            }
            catch (IOException ioEx) {
                this.ioException = ioEx;
            }
        }
    }
}

