/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.text.NumberFormat;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.guids.GUIDDispenser;
import r01f.guids.GUIDDispenserManager;
import r01f.internal.BootstrapGuiceModule;

public class TestGUIDGenerator {
    private static final Logger log = LoggerFactory.getLogger(TestGUIDGenerator.class);

    public static void main(String[] args) {
        try {
            int testTimes = 1000;
            boolean debug = true;
            long[] marks = new long[testTimes];
            Injector injector = Guice.createInjector((Module[])new Module[]{new BootstrapGuiceModule()});
            MyInjectedGUIDGeneratorTest testInjected = (MyInjectedGUIDGeneratorTest)injector.getInstance(MyInjectedGUIDGeneratorTest.class);
            GUIDDispenserManager guidDispenserManager = (GUIDDispenserManager)injector.getInstance(GUIDDispenserManager.class);
            System.out.println("\r\n\r\n...start!");
            int i = 0;
            while (i < testTimes) {
                long t1 = System.nanoTime();
                String uid1 = testInjected.generateGuid();
                GUIDDispenser disp1 = guidDispenserManager.instanceFor("r01fb", "default");
                String uid2 = disp1.generateGUID();
                if (debug) {
                    log.info("> UID {}: {} / {}", (Object[])new String[]{Integer.toString(i), uid1, uid2});
                }
                long t2 = System.nanoTime();
                marks[i] = t2 - t1;
                ++i;
            }
            System.out.println("\r\n\r\n\r\n");
            long avg = 0L;
            NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
            int i2 = 0;
            while (i2 < testTimes) {
                System.out.println("<" + i2 + ">\t[" + nf.format(marks[i2]) + "]");
                if (i2 > 1) {
                    avg += marks[i2];
                }
                ++i2;
            }
            System.out.println("------------------------------");
            System.out.println("\t[" + nf.format(avg / (long)testTimes) + "] nanos\r\n\r\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class MyInjectedGUIDGeneratorTest {
        @Inject
        private GUIDDispenserManager _guidDispenserManager;

        public String generateGuid() {
            return this._guidDispenserManager.instanceFor("r01fb", "default").generateGUID();
        }
    }
}

