/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.security.SecureRandom;
import java.util.Date;
import r01f.guids.GUIDDispenser;
import r01f.guids.GUIDDispenserDef;
import r01f.guids.GUIDDispenserFlavourFactory;

public class SimpleGUIDDispenser
implements GUIDDispenser {
    private static String LETTERS = "0123456789abcdefghijklmnopqrstuvxyz";
    private GUIDDispenserDef _dispDef = null;

    @Inject
    public SimpleGUIDDispenser(@Assisted GUIDDispenserDef def) {
        this._dispDef = def;
    }

    @Override
    public String generateGUID() {
        int guidLength = this._dispDef.getLength();
        SecureRandom randomGen = new SecureRandom();
        long timeStampLong = new Date().getTime();
        int objectHashCode = System.identityHashCode(this);
        long secureInt = randomGen.nextLong();
        String uniqueId = String.valueOf(Long.toHexString(timeStampLong)) + Integer.toHexString(objectHashCode) + Long.toHexString(secureInt);
        char[] resultCharArray = new char[guidLength];
        int i = 0;
        while (i < guidLength - uniqueId.length()) {
            resultCharArray[i] = LETTERS.charAt(randomGen.nextInt(LETTERS.length()));
            ++i;
        }
        int cont = uniqueId.length() - 1;
        int i2 = guidLength;
        while (i2 > 0) {
            if (cont >= 0) {
                resultCharArray[i2 - 1] = uniqueId.charAt(cont);
            }
            --cont;
            --i2;
        }
        return String.valueOf(this._dispDef.guidPrefix()) + new String(resultCharArray);
    }

    static interface SimpleGUIDDispenserFactory
    extends GUIDDispenserFlavourFactory {
    }
}

