/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import java.io.Serializable;
import r01f.guids.HighLowMaxForKeyReachedException;

class HighLowKey
implements Serializable {
    private static final long serialVersionUID = 2379521800350045150L;
    private static byte MAX_VALUE = (byte)-1;
    private static byte MIN_VALUE = 0;
    private byte[] _value = null;

    public HighLowKey(int newLength) {
        this._value = new byte[newLength];
        this.setToZero();
    }

    public HighLowKey(String inStr) {
        this._value = HighLowKey._fromStringOfHexToByteArray(inStr);
    }

    public void setToZero() {
        int i = 0;
        while (i < this._value.length) {
            this._value[i] = MIN_VALUE;
            ++i;
        }
    }

    public void increment() throws HighLowMaxForKeyReachedException {
        this._value = this._increment(this._value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this._value.length) {
            String hex = "0" + Integer.toHexString(this._value[i]);
            String end = hex.substring(hex.length() - 2);
            sb.append(end.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    private byte[] _increment(byte[] array) throws HighLowMaxForKeyReachedException {
        return this._incrementElement(array, 0);
    }

    private byte[] _incrementElement(byte[] array, int index) throws HighLowMaxForKeyReachedException {
        if (array[index] == MAX_VALUE) {
            if (index == array.length - 1) {
                throw new HighLowMaxForKeyReachedException();
            }
            this._incrementElement(array, index + 1);
            array[index] = MIN_VALUE;
        } else {
            int n = index;
            array[n] = (byte)(array[n] + 1);
        }
        return array;
    }

    private static byte[] _fromStringOfHexToByteArray(String str) {
        int size = str.length() / 2;
        byte[] b = new byte[size];
        int i = 0;
        while (i < size) {
            String chunk = str.substring(i * 2, i * 2 + 2);
            b[i] = (byte)Integer.parseInt(chunk, 16);
            ++i;
        }
        return b;
    }
}

