/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.guids.GUIDDispenser;
import r01f.guids.GUIDDispenserDef;
import r01f.guids.GUIDDispenserFlavourFactory;
import r01f.guids.HighLowGUIDPersist;
import r01f.guids.HighLowKey;
import r01f.guids.HighLowMaxForKeyReachedException;

public class HighLowGUIDDispenser
implements GUIDDispenser {
    private static final Logger log = LoggerFactory.getLogger(HighLowGUIDDispenser.class);
    private Map<String, HighLowGUIDPersist> _highLowGUIDPersistFactories;
    private GUIDDispenserDef _dispDef;
    private HighLowGUIDPersist _guidPersist = null;
    private HighLowKey _currHighKey = null;
    private HighLowKey _currLowKey = null;

    @Inject
    public HighLowGUIDDispenser(@Assisted GUIDDispenserDef dispDef, Map<String, HighLowGUIDPersist> highLowGUIDPersistFactories) {
        this._highLowGUIDPersistFactories = highLowGUIDPersistFactories;
        this._dispDef = new GUIDDispenserDef(dispDef);
        this._guidPersist = this._highLowGUIDPersistFactories.get(dispDef.getProperty("persistenceBindingId"));
        if (this._dispDef.getProperty("highKeyBytes") == null) {
            log.warn("No se ha definido la propiedad {}properties/highKeyBytes en el fichero definici\u00f3n de guids de la aplicacion {}. Se toma un tama\u00f1o de {}", (Object[])new String[]{HighLowGUIDDispenser._xPathBase(this._dispDef.getSequenceName()), this._dispDef.getAppCode(), Integer.toString(this._dispDef.getLength() / 2)});
            this._dispDef.putProperty("highKeyBytes", Integer.toString(this._dispDef.getLength() / 2));
        }
        if (this._dispDef.getProperty("lowKeyBytes") == null) {
            log.warn("No se ha definido la propiedad {}properties/lowKeyBytes en el fichero de properties de la aplicacion {}. Se toma un tama\u00f1o de {}", (Object[])new String[]{HighLowGUIDDispenser._xPathBase(this._dispDef.getSequenceName()), this._dispDef.getAppCode(), Integer.toString(this._dispDef.getLength() / 2)});
            this._dispDef.putProperty("lowKeyBytes", Integer.toString(this._dispDef.getLength() / 2));
        }
        if (this._dispDef.getProperty("persistenceBindingId") == null) {
            log.warn("No se ha definido la propiedad {}properties/persistenceBindingId en el fichero definici\u00f3n de guids de la aplicacion {}. Se toma la persistencia en MEMORIA por defecto!!!!", (Object)HighLowGUIDDispenser._xPathBase(this._dispDef.getSequenceName()), (Object)this._dispDef.getAppCode());
            this._dispDef.putProperty("persistenceBindingId", "inMemoryHighKeyPersist");
        }
        this._currLowKey = new HighLowKey(Integer.parseInt(this._dispDef.getProperty("lowKeyBytes")));
        this._moveToNextHighKey();
        System.out.println("---->" + this._highLowGUIDPersistFactories);
    }

    private static String _xPathBase(String sequenceName) {
        return "guidGenerator/sequence[@name='" + sequenceName + "']/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateGUID() {
        String theUIdString = null;
        HighLowKey highLowKey = this._currLowKey;
        synchronized (highLowKey) {
            try {
                this._currLowKey.increment();
            }
            catch (HighLowMaxForKeyReachedException maxEx) {
                this._moveToNextHighKey();
                this._currLowKey.setToZero();
            }
        }
        theUIdString = String.valueOf(this._currHighKey.toString()) + this._currLowKey.toString() + this._dispDef.getUniqueID();
        return theUIdString;
    }

    private boolean _moveToNextHighKey() {
        boolean outOK = false;
        try {
            if (this._currHighKey != null) {
                this._currHighKey.increment();
                outOK = this._guidPersist.updateGUID(this._dispDef, this._currHighKey);
            } else {
                this._currHighKey = this._guidPersist.getHighKeyValue(this._dispDef);
                if (this._currHighKey == null) {
                    this._currHighKey.setToZero();
                    outOK = this._guidPersist.updateGUID(this._dispDef, this._currHighKey);
                } else {
                    outOK = true;
                }
            }
        }
        catch (HighLowMaxForKeyReachedException maxKeyEx) {
            log.error("Se han agotado los HIGH; hay un riesgo GRANDE de repetici\u00f3n de GUIDs... revisa el tama\u00f1o del guid (definici\u00f3n de guids)!!", (Throwable)maxKeyEx);
            this._currHighKey.setToZero();
        }
        if (!outOK) {
            log.error("NO se ha conseguido actualizar el valor HIGH en la persistencia del GUID");
        }
        return outOK;
    }

    static interface HighLowGUIDDispenserFactory
    extends GUIDDispenserFlavourFactory {
    }
}

