/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.guids.GUIDDispenserDef;
import r01f.guids.HighLowGUIDPersist;
import r01f.guids.HighLowKey;

public class HighLowBBDDGUIDPersist
implements HighLowGUIDPersist {
    private static final Logger log = LoggerFactory.getLogger(HighLowBBDDGUIDPersist.class);
    private static final String CONXNAME = "conxName";
    private static final String GUIDSTABLE = "guidsTable";
    private static final String HIGHKEYCOLUMN = "highKeyColumn";
    private static final String SEQUENCENAMECOLUMN = "seqNameColumn";

    @Override
    public HighLowKey getHighKeyValue(GUIDDispenserDef dispDef) {
        if (this._checkDispenserDef(dispDef) != null) {
            throw new IllegalArgumentException(this._checkDispenserDef(dispDef));
        }
        String conxName = dispDef.getProperty(CONXNAME);
        String guidsTable = dispDef.getProperty(GUIDSTABLE);
        String highKeyCol = dispDef.getProperty(HIGHKEYCOLUMN);
        String seqCol = dispDef.getProperty(SEQUENCENAMECOLUMN);
        HighLowKey outKey = null;
        try {
            Connection conx = null;
            try {
                Statement ps = null;
                try {
                    ResultSet rs = null;
                    try {
                        String sqlSELECT = null;
                        sqlSELECT = "SELECT " + highKeyCol + " " + "FROM " + guidsTable + " " + "WHERE " + seqCol + "= ?";
                        ps = conx.prepareStatement(sqlSELECT);
                        ps.setString(1, dispDef.getSequenceName());
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            outKey = new HighLowKey(rs.getString(highKeyCol));
                        }
                    }
                    finally {
                        if (Collections.singletonList(rs).get(0) != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(ps).get(0) != null) {
                        ps.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conx).get(0) != null) {
                    conx.close();
                }
            }
        }
        catch (SQLException sqlEx) {
            log.error("Error al obtener el valor de la parte high de la clave: {}", (Object)sqlEx.getMessage(), (Object)sqlEx);
        }
        return outKey;
    }

    @Override
    public boolean updateGUID(GUIDDispenserDef dispDef, HighLowKey newHighKey) {
        if (this._checkDispenserDef(dispDef) != null) {
            throw new IllegalArgumentException(this._checkDispenserDef(dispDef));
        }
        if (newHighKey == null) {
            throw new IllegalArgumentException("La nueva clave high NO es valida!");
        }
        String conxName = dispDef.getProperty(CONXNAME);
        String guidsTable = dispDef.getProperty(GUIDSTABLE);
        String highKeyCol = dispDef.getProperty(HIGHKEYCOLUMN);
        String seqCol = dispDef.getProperty(SEQUENCENAMECOLUMN);
        boolean outResult = false;
        try {
            Connection conx = null;
            try {
                Statement ps = null;
                try {
                    String sqlUPDATE = "UPDATE " + guidsTable + " " + "SET " + highKeyCol + " = ? " + "WHERE " + seqCol + " = ?";
                    ps = conx.prepareStatement(sqlUPDATE);
                    ps.setString(1, newHighKey.toString());
                    ps.setString(2, dispDef.getSequenceName());
                    outResult = ps.executeUpdate() != 1;
                }
                finally {
                    if (Collections.singletonList(ps).get(0) != null) {
                        ps.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(conx).get(0) != null) {
                    conx.close();
                }
            }
        }
        catch (SQLException sqlEx) {
            log.error("Error al actualizar el valor high de la clave en la base de datos: {}", (Object)sqlEx.getMessage(), (Object)sqlEx);
        }
        return outResult;
    }

    private String _checkDispenserDef(GUIDDispenserDef dispDef) {
        StringBuilder sb = new StringBuilder("");
        if (dispDef == null) {
            sb.append("\r\nDescriptor del dispenser NO es valido!\r\n");
        } else if (dispDef.getProperties() == null) {
            sb.append("\tNo se han definido las propiedades del dispenser que permiten conocer la Base de Datos\r\n");
        } else {
            String conxName = dispDef.getProperty(CONXNAME);
            String guidsTable = dispDef.getProperty(GUIDSTABLE);
            String highKeyCol = dispDef.getProperty(HIGHKEYCOLUMN);
            if (conxName == null) {
                sb.append("\tFalta la propiedad conxName en la definicion del dispenser " + dispDef.getSequenceName());
            }
            if (guidsTable == null) {
                sb.append("\tFalta la propiedad guidsTable en la definicion del dispenser " + dispDef.getSequenceName());
            }
            if (highKeyCol == null) {
                sb.append("\tFalta la propiedad highKeyColumn en la definicion del dispenser " + dispDef.getSequenceName());
            }
            if (guidsTable == null) {
                sb.append("\tFalta la propiedad guidsTable en la definicion del dispenser " + dispDef.getSequenceName());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

