/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import r01f.guids.GUIDDispenser;
import r01f.guids.GUIDDispenserDef;
import r01f.guids.GUIDDispenserFlavourFactory;
import r01f.util.types.Strings;
import r01f.xmlproperties.XMLProperties;
import r01f.xmlproperties.XMLPropertiesManager;

public class GUIDDispenserManager {
    private static final Logger log = LoggerFactory.getLogger(GUIDDispenserManager.class);
    @Inject
    private XMLProperties _xmlProperties;
    @Inject
    private Map<String, GUIDDispenserFlavourFactory> _dispensersFactories;
    private Map<String, GUIDDispenser> _dispensers;

    public GUIDDispenser instanceFor(String appCode) {
        return this.instanceFor(appCode, "default");
    }

    public GUIDDispenser instanceFor(String appCode, String sequenceId) {
        GUIDDispenser outDispenser;
        GUIDDispenser gUIDDispenser = outDispenser = this._dispensers != null ? this._dispensers.get(String.valueOf(appCode) + "." + sequenceId) : null;
        if (outDispenser == null) {
            GUIDDispenserDef def = GUIDDispenserManager._loadDispenserDefFor(this._xmlProperties, appCode, sequenceId);
            outDispenser = this.instanceFor(def);
        }
        return outDispenser;
    }

    public GUIDDispenser instanceFor(GUIDDispenserDef dispDef) {
        GUIDDispenser outDispenser = null;
        if (dispDef == null) {
            log.error("La definicion del dispenser de GUIDs es nula; NO se puede crear el dispenser");
        } else {
            String dispenserKey = String.valueOf(dispDef.getAppCode()) + "." + dispDef.getSequenceName();
            GUIDDispenser gUIDDispenser = outDispenser = this._dispensers != null ? this._dispensers.get(dispenserKey) : null;
            if (outDispenser == null) {
                log.trace("El GUIDDispenser {} de la aplicacion {} NO estaba creado...se crea ahora!", (Object)dispDef.getSequenceName(), (Object)dispDef.getAppCode());
                outDispenser = this._dispensersFactories.get(dispDef.getFactoryBindingId()).factoryFor(dispDef);
                if (outDispenser != null) {
                    if (this._dispensers == null) {
                        this._dispensers = new HashMap<String, GUIDDispenser>(10, 0.5f);
                    }
                    this._dispensers.put(dispenserKey, outDispenser);
                    log.trace("GUIDDispenser created: >\r\n{}", (Object)dispDef.debugInfo());
                } else {
                    log.error("No se puede crear el dispenser de guids: {}/{}", (Object)dispDef.getAppCode(), (Object)dispDef.getSequenceName());
                }
            }
        }
        return outDispenser;
    }

    private static String _xPathBase(String sequenceName) {
        return "guidGenerator/sequence[@name='" + sequenceName + "']/";
    }

    private static GUIDDispenserDef _loadDispenserDefFor(XMLProperties xmlProperties, String appCode, String sequenceName) {
        String factoryBindingId;
        log.trace("Loading the config for dispenser {} in app {}", (Object)sequenceName, (Object)appCode);
        if (appCode == null || sequenceName == null) {
            String err = Strings.customize("No se puede cargar la configuracion del GUIDDispenser ya que el codigo de aplicacion o el nombre de secuencia es null: appCode={} / sequenceId={}", appCode, sequenceName).toString();
            throw new IllegalArgumentException(err);
        }
        XMLPropertiesManager props = xmlProperties.forApp(appCode);
        int length = props.of("guids").getInteger(String.valueOf(GUIDDispenserManager._xPathBase(sequenceName)) + "length", GUIDDispenserDef.GUID_DEFAULT_LENGTH);
        String uniqueID = props.of("guids").getString(String.valueOf(GUIDDispenserManager._xPathBase(sequenceName)) + "uniqueId", "0-unknown");
        if (uniqueID == null) {
            log.warn("No se ha definido la propiedad {}/uniqueId en el fichero de properties de la aplicacion {}. Se toma un valor '0-unknown'", (Object[])new String[]{GUIDDispenserManager._xPathBase(sequenceName), sequenceName, appCode});
        }
        if ((factoryBindingId = props.of("guids").getString(String.valueOf(GUIDDispenserManager._xPathBase(sequenceName)) + "factoryBindingId", "simpleGUIDDispenser")) == null) {
            log.warn("No se ha definido la propiedad {}/factoryBindingId en el fichero de properties de definici\u00f3n de guids de la aplicacion {}. Se toma un valor 'simpleGUIDDispenser'", (Object[])new String[]{GUIDDispenserManager._xPathBase(sequenceName), sequenceName, appCode});
        }
        Properties properties = props.of("guids").getProperties(String.valueOf(GUIDDispenserManager._xPathBase(sequenceName)) + "properties");
        GUIDDispenserDef outDispDef = new GUIDDispenserDef(appCode, sequenceName, length, uniqueID, factoryBindingId, properties);
        return outDispDef;
    }
}

