/*
 * Decompiled with CFR 0.152.
 */
package r01f.guids;

import java.util.Map;
import java.util.Properties;
import r01f.debug.Debuggable;
import r01f.util.types.Strings;

class GUIDDispenserDef
implements Debuggable {
    public static int GUID_DEFAULT_LENGTH = 36;
    private String _appCode;
    private String _sequenceName;
    private String _uniqueID;
    private int _length = GUID_DEFAULT_LENGTH;
    private String _factoryBindingId;
    private Properties _properties;

    public GUIDDispenserDef(String newAppCode, String newSequenceName, int newLength, String newUniqueID, String newFactoryBindingId, Properties newProps) {
        this._appCode = newAppCode;
        this._sequenceName = newSequenceName;
        this._length = newLength;
        this._uniqueID = newUniqueID;
        this._factoryBindingId = newFactoryBindingId;
        this._properties = newProps;
        this._build();
    }

    public GUIDDispenserDef(GUIDDispenserDef other) {
        this(other.getAppCode(), other.getSequenceName(), other.getLength(), other.getUniqueID(), other.getFactoryBindingId(), other.getProperties());
    }

    private void _build() {
        if (this._uniqueID == null) {
            this._uniqueID = "un";
        }
        if (this._uniqueID.length() < 2) {
            this._uniqueID = Strings.of((CharSequence)this._uniqueID).rightPad('0', 2).asString();
        }
    }

    public String getProperty(String propName) {
        return this._properties != null ? this._properties.getProperty(propName) : null;
    }

    public void putProperty(String propName, String propValue) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        this._properties.put(propName, propValue);
    }

    public String guidPrefix() {
        String outPrefix = null;
        outPrefix = Strings.isNullOrEmpty(this._appCode) ? "UNKN" : (this._appCode.length() > 4 ? this._appCode.substring(0, 4) : (this._appCode.length() < 4 ? Strings.of((CharSequence)this._appCode).rightPad('0', 4).asString() : this._appCode));
        if (this._uniqueID != null) {
            outPrefix = this._uniqueID.length() >= 2 ? String.valueOf(outPrefix) + this._uniqueID.charAt(0) + this._uniqueID.charAt(1) : String.valueOf(outPrefix) + this._uniqueID.charAt(0);
        }
        return outPrefix;
    }

    @Override
    public String debugInfo() {
        Strings.StringWrapper sw = Strings.create(200).addCustomized("\tappCode: {}\r\n", this._appCode).addCustomized("\tsequenceName: {}\r\n", this._sequenceName).addCustomized("\tuniqueId: {}\r\n", this._uniqueID).addCustomized("\tdispenserId: {}\r\n", this._factoryBindingId);
        if (this._properties != null) {
            for (Map.Entry<Object, Object> me : this._properties.entrySet()) {
                sw.addCustomized("\t\t{}:{}\r\n", me.getKey().toString(), me.getValue().toString());
            }
        }
        return sw.asString();
    }

    public String getAppCode() {
        return this._appCode;
    }

    public void setAppCode(String _appCode) {
        this._appCode = _appCode;
    }

    public String getSequenceName() {
        return this._sequenceName;
    }

    public void setSequenceName(String _sequenceName) {
        this._sequenceName = _sequenceName;
    }

    public String getUniqueID() {
        return this._uniqueID;
    }

    public void setUniqueID(String _uniqueID) {
        this._uniqueID = _uniqueID;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int _length) {
        this._length = _length;
    }

    public String getFactoryBindingId() {
        return this._factoryBindingId;
    }

    public void setFactoryBindingId(String _factoryBindingId) {
        this._factoryBindingId = _factoryBindingId;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setProperties(Properties _properties) {
        this._properties = _properties;
    }
}

