/*
 * Decompiled with CFR 0.152.
 */
package r01f.exceptions;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import r01f.exceptions.EnrichedExceptionCustomizationsInterfaces;
import r01f.exceptions.EnrichedThrowable;
import r01f.exceptions.ExceptionSeverity;
import r01f.reflection.Reflection;
import r01f.util.types.Lists;
import r01f.util.types.Strings;

public class EnrichedThrowableCustomizations<T extends EnrichedThrowable, S extends Enum<S>>
implements EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S>,
EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsReader<T, S>,
Serializable {
    private static final long serialVersionUID = -8173523507126756998L;
    private T _wrappedException;
    private Class<T> _wrappedExceptionType;
    private boolean _throwingUnWrapped = false;
    private String _message;
    private List<TraceInfo> _info;
    private S _subClass;
    private int _group = Integer.MIN_VALUE;
    private int _code = Integer.MIN_VALUE;
    private ExceptionSeverity _severity = ExceptionSeverity.DEFAULT;
    private boolean _hasToBeLogged = false;

    public EnrichedThrowableCustomizations(String msg, T wrappedEx, Class<T> wrappedExType) {
        this._message = msg;
        this._wrappedException = wrappedEx;
        this._wrappedExceptionType = wrappedExType;
    }

    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> writer() {
        return this;
    }

    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsReader<T, S> reader() {
        return this;
    }

    @Override
    public T throwWrapped() {
        return this._wrappedException;
    }

    @Override
    public T throwWrapped(String info) {
        this.addInfo(info);
        return this.throwWrapped();
    }

    @Override
    public T throwUnWrapped() {
        String msg = this._wrappedException.getStackTraceAsString();
        EnrichedThrowable newExInstance = (EnrichedThrowable)Reflection.type(this._wrappedExceptionType).withConstructor(String.class).load(msg).instance();
        newExInstance.customized().throwingUnWrapped();
        newExInstance.fillInStackTrace();
        return (T)newExInstance;
    }

    @Override
    public T throwUnWrapped(String info) {
        this.addInfo(info);
        return this.throwUnWrapped();
    }

    @Override
    public void throwingUnWrapped() {
        this._throwingUnWrapped = true;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> withMessage(String theMessage) {
        this._message = !Strings.isNullOrEmpty(this._message) ? Strings.of((CharSequence)this._message).add((CharSequence)theMessage).asString() : theMessage;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> withMessage(String messageWithPlaceHolders, String ... vars) {
        this._message = !Strings.isNullOrEmpty(messageWithPlaceHolders) ? Strings.of((CharSequence)messageWithPlaceHolders).customizeWith(vars).asString() : null;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> addInfo(String ... theInfo) {
        if (theInfo == null) {
            return this;
        }
        StackTraceElement[] tels = Thread.currentThread().getStackTrace();
        StackTraceElement tel = tels[tels.length - 1];
        String[] stringArray = theInfo;
        int n = theInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            TraceInfo info = new TraceInfo(tel.getFileName(), tel.getClassName(), tel.getMethodName(), tel.getLineNumber(), i);
            if (this._info == null) {
                this._info = Lists.newArrayList();
            }
            this._info.add(info);
            ++n2;
        }
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> subClass(S theSubClass) {
        this._subClass = theSubClass;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> withSeverity(ExceptionSeverity severity) {
        this._severity = severity;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> recoverable() {
        this._severity = ExceptionSeverity.RECOVERABLE;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> fatal() {
        this._severity = ExceptionSeverity.FATAL;
        this._hasToBeLogged = true;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> inGroup(int group) {
        this._group = group;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> withCode(int code) {
        this._code = code;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> logged() {
        this._hasToBeLogged = true;
        return this;
    }

    @Override
    public EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> developerWarn() {
        System.out.println("\r\n\r\n\r\n\r\nATENCION!!!!!!\r\nSe ha producido una excepcion debida a un error en el codigo. Revisar ANTES de pasar a cualquier entorno:");
        this._wrappedException.printStackTrace(System.out);
        System.out.println("\r\n\r\n\r\n\r\n");
        return this;
    }

    @Override
    public Throwable wrappedException() {
        return (Throwable)this._wrappedException;
    }

    @Override
    public boolean isThrowingUnWrapped() {
        return this._throwingUnWrapped;
    }

    @Override
    public String getMessage() {
        Strings.StringWrapper sw = Strings.create();
        if (this._subClass != null) {
            sw.add((CharSequence)"\r\n|     SubClass: [").add((CharSequence)((Enum)this._subClass).name()).add((CharSequence)"]");
        }
        if (this._group > 0 || this._code > 0) {
            sw.add((CharSequence)"\r\n|   Group/Code: {").add((CharSequence)(this._group > 0 ? Integer.toString(this._group) : "")).add((CharSequence)(this._group > 0 && this._code > 0 ? ":" : "")).add((CharSequence)(this._code > 0 ? Integer.toString(this._code) : "")).add((CharSequence)"}");
        }
        if (this._message != null) {
            if (!this._throwingUnWrapped) {
                sw.add((CharSequence)"\r\n|      Message: ").add((CharSequence)this._message.replaceAll("\r\n", "\r\n|               "));
            } else {
                sw.add((CharSequence)this._message);
            }
        }
        if (!Lists.isNullOrEmpty(this._info)) {
            sw.add((CharSequence)"\r\n|AditionalInfo:");
            Iterator<TraceInfo> it = this._info.iterator();
            while (it.hasNext()) {
                sw.add((CharSequence)"\r\n|    ");
                sw.add((CharSequence)it.next().toString());
            }
        }
        return sw.asString();
    }

    @Override
    public S getSubClass() {
        return this._subClass;
    }

    @Override
    public int getGroup() {
        return this._group;
    }

    @Override
    public int getCode() {
        return this._code;
    }

    @Override
    public ExceptionSeverity getSeverity() {
        return this._severity;
    }

    @Override
    public boolean isMoreSeriousThan(EnrichedThrowable ex) {
        return this.getSeverity().isMorSeriousThan(ex.customizations().getSeverity());
    }

    @Override
    public boolean hasToBeLogged() {
        return this._hasToBeLogged;
    }

    @Override
    public boolean isSubClassOf(S subClass) {
        return this._subClass != null && ((Enum)this._subClass).equals(subClass);
    }

    @Override
    public boolean isAnyOfSubClasses(S ... subClasses) {
        if (this._subClass == null || subClasses == null || subClasses.length == 0) {
            return false;
        }
        boolean found = false;
        S[] SArray = subClasses;
        int n = subClasses.length;
        int n2 = 0;
        while (n2 < n) {
            S sub = SArray[n2];
            if (((Enum)sub).equals(this._subClass)) {
                found = true;
                break;
            }
            ++n2;
        }
        return found;
    }

    private class TraceInfo
    implements Serializable {
        private static final long serialVersionUID = 5936184738006005471L;
        String fileName;
        String className;
        String methodName;
        int lineNumber;
        String info;

        public String toString() {
            return Strings.create().add((CharSequence)this.info).add((CharSequence)" >> ").add((CharSequence)this.className).add((CharSequence)".").add((CharSequence)this.methodName).add((CharSequence)"(").add((CharSequence)this.fileName).add((CharSequence)":").add(this.lineNumber).add((CharSequence)")").asString();
        }

        @ConstructorProperties(value={"fileName", "className", "methodName", "lineNumber", "info"})
        public TraceInfo(String fileName, String className, String methodName, int lineNumber, String info) {
            this.fileName = fileName;
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
            this.info = info;
        }
    }
}

