/*
 * Decompiled with CFR 0.152.
 */
package r01f.exceptions;

import com.google.common.base.Throwables;
import java.util.List;
import r01f.exceptions.EnrichedException;
import r01f.exceptions.EnrichedExceptionCustomizationsInterfaces;
import r01f.exceptions.EnrichedThrowable;
import r01f.exceptions.EnrichedThrowableCustomizations;
import r01f.util.types.Lists;

public abstract class EnrichedRuntimeException
extends RuntimeException
implements EnrichedThrowable {
    private static final long serialVersionUID = 3397096436745819652L;
    private EnrichedThrowableCustomizations<? extends EnrichedThrowable, ? extends Enum<?>> _exWrapper;

    public EnrichedRuntimeException() {
        this._wrap(null, null);
    }

    public EnrichedRuntimeException(String msg) {
        super(msg);
        this._wrap(msg, null);
    }

    public EnrichedRuntimeException(Throwable otherEx) {
        super(otherEx);
        this._wrap(null, otherEx);
    }

    public EnrichedRuntimeException(String msg, Throwable otherEx) {
        super(msg, otherEx);
        this._wrap(msg, otherEx);
    }

    @Override
    public <T extends EnrichedThrowable, S extends Enum<S>> EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsReader<T, S> customizations() {
        return (EnrichedThrowableCustomizations)this._exWrapper.reader();
    }

    @Override
    public <T extends EnrichedThrowable, S extends Enum<S>> EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsWriter<T, S> customized() {
        return (EnrichedThrowableCustomizations)this._exWrapper.writer();
    }

    private void _wrap(String msg, Throwable otherEx) {
        this._exWrapper = new EnrichedThrowableCustomizations(msg, this, this.getClass());
        EnrichedExceptionCustomizationsInterfaces.ExceptionCustomizationsReader otherExCustomizations = null;
        if (otherEx instanceof EnrichedException) {
            EnrichedException otheEnrichedEx = (EnrichedException)otherEx;
            otherExCustomizations = otheEnrichedEx.customizations();
        } else if (otherEx instanceof EnrichedRuntimeException) {
            EnrichedRuntimeException otheEnrichedEx = (EnrichedRuntimeException)otherEx;
            otherExCustomizations = otheEnrichedEx.customizations();
        }
        if (otherExCustomizations != null) {
            if (otherExCustomizations.isMoreSeriousThan(this)) {
                this.customized().withSeverity(otherExCustomizations.getSeverity());
            }
            if (otherExCustomizations.hasToBeLogged()) {
                this.customized().logged();
            }
        }
    }

    @Override
    public String getMessage() {
        return this._exWrapper.getMessage();
    }

    public Throwable getRootCause() {
        return Throwables.getRootCause((Throwable)this);
    }

    public List<Throwable> getCausalChain() {
        return Throwables.getCausalChain((Throwable)this);
    }

    public List<Throwable> getCausalChainReversed() {
        List<Throwable> causalChain = this.getCausalChain();
        return Lists.reverse(causalChain);
    }

    public String getRootClassName() {
        StackTraceElement[] tes = this.getStackTrace();
        return tes[tes.length - 1].getClassName();
    }

    public String getRootMethod() {
        StackTraceElement[] tes = this.getStackTrace();
        return tes[tes.length - 1].getMethodName();
    }

    public String getRootTraceElement() {
        StackTraceElement[] tes = this.getStackTrace();
        return tes[tes.length - 1].toString();
    }

    @Override
    public String getStackTraceAsString() {
        String outStackTraceAsStr = Throwables.getStackTraceAsString((Throwable)this._exWrapper.wrappedException());
        return outStackTraceAsStr;
    }
}

