/*
 * Decompiled with CFR 0.152.
 */
package r01f.ejb;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class JNDIContextLocator {
    private static final String DEFAULT_JNDI_CONTEXT_URL = "default";
    private Map<String, Context> _contextCache = new Hashtable<String, Context>(3, 0.7f);

    JNDIContextLocator() {
    }

    public static JNDIContextLocator getInstance() {
        return JNDIContextCacheSingletonHolder.instance;
    }

    public Context getInitialContext() throws NamingException {
        Context outCtx = this.getInitialContext((Properties)null);
        return outCtx;
    }

    public Context getInitialContext(String contextURL) throws NamingException {
        Context outCtx = null;
        if (contextURL != null) {
            Properties props = new Properties();
            props.put("url", contextURL);
            outCtx = this.getInitialContext(props);
        } else {
            outCtx = this.getInitialContext((Properties)null);
        }
        return outCtx;
    }

    public Context getInitialContext(Properties props) throws NamingException {
        Context outCtx = null;
        if (props == null) {
            outCtx = this._contextCache.get(DEFAULT_JNDI_CONTEXT_URL);
            if (outCtx == null) {
                outCtx = new InitialContext();
                this._contextCache.put(DEFAULT_JNDI_CONTEXT_URL, outCtx);
            }
        } else {
            String url = props.get("url") != null ? props.get("url").toString() : null;
            String factory = props.get("factory") != null ? props.get("factory").toString() : null;
            String user = props.get("user") != null ? props.get("user").toString() : null;
            String password = props.get("password") != null ? props.get("password").toString() : null;
            outCtx = url != null ? this._contextCache.get(url) : this._contextCache.get(DEFAULT_JNDI_CONTEXT_URL);
            if (outCtx == null && url != null) {
                Properties h = new Properties();
                h.put("java.naming.provider.url", url);
                if (factory != null) {
                    h.put("java.naming.factory.initial", factory);
                }
                if (user != null) {
                    h.put("java.naming.security.principal", user);
                }
                if (password != null) {
                    h.put("java.naming.security.credentials", password);
                }
                outCtx = new InitialContext(h);
            } else if (outCtx == null && url == null) {
                outCtx = new InitialContext();
            }
            this._contextCache.put(url, outCtx);
        }
        return outCtx;
    }

    private static final class JNDIContextCacheSingletonHolder {
        static final JNDIContextLocator instance = new JNDIContextLocator();

        private JNDIContextCacheSingletonHolder() {
        }
    }
}

