/*
 * Decompiled with CFR 0.152.
 */
package r01f.ejb;

import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import r01f.ejb.EJB;
import r01f.ejb.EJBFactory;
import r01f.reflection.Reflection;

public class EJBGuiceListeners {

    public static class EJBMemberInjector<T>
    implements MembersInjector<T> {
        private final Field field;
        private EJB annotation;

        EJBMemberInjector(Field f) {
            this.field = f;
            this.annotation = f.getAnnotation(EJB.class);
        }

        public void injectMembers(T t) {
            Object ejb = null;
            if (this.annotation.localHomeType() == EJBLocalHome.class || this.annotation.homeType() == EJBHome.class) {
                Class<? extends EJBLocalHome> homeType = this.annotation.local() ? this.annotation.localHomeType() : this.annotation.homeType();
                ejb = EJBFactory.createEJB2(this.annotation.jndiName(), this.annotation.local(), homeType);
            } else {
                ejb = EJBFactory.createEJB3(this.annotation.jndiName(), this.annotation.local(), this.field.getType());
            }
            Reflection.of(t).field(this.field).set(ejb);
        }
    }

    public static class EJBTypeListener
    implements TypeListener {
        public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
            Field[] fieldArray = typeLiteral.getRawType().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.isAnnotationPresent(EJB.class)) {
                    typeEncounter.register(new EJBMemberInjector(field));
                }
                ++n2;
            }
        }
    }
}

