/*
 * Decompiled with CFR 0.152.
 */
package r01f.ejb;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import r01f.ejb.JNDIContextLocator;
import r01f.reflection.Reflection;
import r01f.util.types.Strings;

public class EJBFactory {
    public static <T> T createEJB3(String jndiName, boolean local, Class<T> type) {
        return EJBFactory.createEJB3(null, jndiName, local, type);
    }

    public static <T> T createEJB3(Properties jndiContextProps, String jndiName, boolean local, Class<T> type) {
        Object outEJB = null;
        try {
            Context initialContext = JNDIContextLocator.getInstance().getInitialContext(jndiContextProps);
            String theJNDIName = String.valueOf(jndiName) + (local ? "Local" : "");
            Object obj = initialContext.lookup(theJNDIName);
            outEJB = local ? obj : PortableRemoteObject.narrow((Object)obj, type);
        }
        catch (NamingException namEx) {
            String err = Strings.of((CharSequence)"NO se ha podido obtener un contexto jndi contra el LDAP").asString();
            System.out.println(err);
        }
        return (T)outEJB;
    }

    public static <T> T createEJB2(String jndiName, boolean local, Class<?> homeType) {
        return EJBFactory.createEJB2(null, jndiName, local, homeType);
    }

    public static <T> T createEJB2(Properties jndiContextProps, String jndiName, boolean local, Class<?> homeType) {
        T outEJB = null;
        try {
            Context initialContext = JNDIContextLocator.getInstance().getInitialContext(jndiContextProps);
            String theJNDIName = String.valueOf(jndiName) + (local ? "Local" : "");
            Object home = initialContext.lookup(theJNDIName);
            Object homeNarrowed = PortableRemoteObject.narrow((Object)home, homeType);
            outEJB = Reflection.of(homeNarrowed).method("create").invoke();
        }
        catch (NamingException namEx) {
            String err = Strings.of((CharSequence)"NO se ha podido obtener un contexto jndi contra el LDAP").asString();
            System.out.println(err);
        }
        return outEJB;
    }
}

