/*
 * Decompiled with CFR 0.152.
 */
package r01f.ejb;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import r01f.ejb.JNDIContextLocator;
import r01f.reflection.Reflection;
import r01f.reflection.ReflectionException;
import r01f.util.types.Strings;

public class EJB2HomeLocator {
    private static final String LOCALHOME_INTERFACE_JNDINAME_PREFIX = "";
    private static final String LOCALHOME_INTERFACE_JNDINAME_SUFFIX = "Local";
    private static final String REMOTEHOME_INTERFACE_JNDINAME_PREFIX = "";
    private static final String REMOTEHOME_INTERFACE_JNDINAME_SUFFIX = "";
    private transient Map<String, Object> _ejbHomeReferencesCache = new Hashtable<String, Object>(20, 0.5f);

    EJB2HomeLocator() {
    }

    public static EJB2HomeLocator getInstance() {
        return EJB2HomeLocator.getInstance(null);
    }

    public static EJB2HomeLocator getInstance(Properties props) {
        try {
            JNDIContextLocator.getInstance().getInitialContext(props);
        }
        catch (NamingException namEx) {
            String err = Strings.of((CharSequence)"No se ha podido obtener el contexto inicial del \u00e1rbol JNDI: {}").customizeWith(namEx.getMessage()).asString();
            System.out.println(err);
        }
        return LocatorSingletonHolder.instance;
    }

    private Object _retrieveHomeReference(String jndiContextProviderURL, String jndiName, boolean local) {
        Object home;
        String theJNDIName = null;
        theJNDIName = local ? jndiName + LOCALHOME_INTERFACE_JNDINAME_SUFFIX : jndiName;
        Object object = home = this._ejbHomeReferencesCache.isEmpty() ? null : this._ejbHomeReferencesCache.get(theJNDIName);
        if (home == null) {
            try {
                Object object2 = home = local ? JNDIContextLocator.getInstance().getInitialContext().lookup(theJNDIName) : JNDIContextLocator.getInstance().getInitialContext(jndiContextProviderURL).lookup(theJNDIName);
                if (home != null) {
                    this._ejbHomeReferencesCache.put(theJNDIName, home);
                }
            }
            catch (NamingException namEx) {
                String err = Strings.of((CharSequence)"NO se ha podido obtener un contexto jndi contra el LDAP: {}").customizeWith(namEx.getExplanation()).asString();
                System.out.println(err);
            }
        }
        if (home == null) {
            String err = Strings.of((CharSequence)"NO se ha encontrado el interfaz home {} del ejb con el nombre jndi={}").customizeWith(local ? "local" : "remoto", theJNDIName).asString();
            System.out.println(err);
        }
        return home;
    }

    public EJBLocalHome getLocalHome(String jndiName) {
        Object home = this._retrieveHomeReference(null, jndiName, true);
        return (EJBLocalHome)home;
    }

    public EJBLocalHome getLocalHome(String jndiName, Class<?> homeType) {
        EJBLocalHome home = this.getLocalHome(jndiName);
        if (home != null) {
            try {
                home = (EJBLocalHome)PortableRemoteObject.narrow((Object)home, homeType);
            }
            catch (ClassCastException ccEx) {
                String err = Strings.of((CharSequence)"Error al hacer un narrow a {} del objeto home de tipo {} > {}").customizeWith(homeType.getName(), home.getClass().getName(), ccEx.getMessage()).asString();
                System.out.println(err);
            }
        }
        return home;
    }

    public EJBLocalHome getLocalHome(String jndiName, String homeClassName) {
        EJBLocalHome home = null;
        try {
            home = this.getLocalHome(jndiName, Reflection.type(homeClassName).getType());
        }
        catch (ReflectionException cnfEx) {
            String err = Strings.of((CharSequence)"NO se ha encontrado la clase {} para hacer un narrow del objeto home > {}").customizeWith(homeClassName, cnfEx.getMessage()).asString();
            System.out.println(err);
        }
        return home;
    }

    public boolean existsLocalHome(String jndiName) {
        EJBLocalHome home = this.getLocalHome(jndiName);
        return home != null;
    }

    public EJBHome getRemoteHome(String jndiName) {
        return this.getRemoteHome(null, jndiName);
    }

    public EJBHome getRemoteHome(String jndiName, Class<?> homeType) {
        return this.getRemoteHome(null, jndiName, homeType);
    }

    public EJBHome getRemoteHome(String jndiContextProviderURL, String jndiName) {
        Object home = this._retrieveHomeReference(jndiContextProviderURL, jndiName, false);
        return (EJBHome)home;
    }

    public EJBHome getRemoteHome(String jndiContextProviderURL, String jndiName, Class<?> homeType) {
        EJBHome home = this.getRemoteHome(jndiContextProviderURL, jndiName);
        if (home != null && homeType != null) {
            try {
                home = (EJBHome)PortableRemoteObject.narrow((Object)home, homeType);
            }
            catch (ClassCastException ccEx) {
                String err = Strings.of((CharSequence)"Error al hacer un narrow a {} del objeto home de tipo {} > {}").customizeWith(homeType.getName(), home.getClass().getName(), ccEx.getMessage()).asString();
                System.out.println(err);
            }
        }
        return home;
    }

    public EJBHome getRemoteHome(String jndiContextProviderURL, String jndiName, String homeClassName) {
        EJBHome home = null;
        try {
            home = this.getRemoteHome(jndiContextProviderURL, jndiName, Reflection.type(homeClassName).getType());
        }
        catch (ReflectionException cnfEx) {
            String err = Strings.of((CharSequence)"NO se ha encontrado la clase {} para hacer un narrow del objeto home > {}").customizeWith(homeClassName, cnfEx.getMessage()).asString();
            System.out.println(err);
        }
        return home;
    }

    private static final class LocatorSingletonHolder {
        static final EJB2HomeLocator instance = new EJB2HomeLocator();

        private LocatorSingletonHolder() {
        }
    }
}

