/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import lombok.AccessLevel;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.experimental.FieldDefaults;
import lombok.experimental.NonFinal;
import lombok.experimental.PackagePrivate;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlerPriority(value=-512)
public class HandleFieldDefaults
extends EclipseAnnotationHandler<FieldDefaults> {
    public boolean generateFieldDefaultsForType(EclipseNode typeNode, EclipseNode pos, AccessLevel level, boolean makeFinal, boolean checkForTypeLevelFieldDefaults) {
        boolean notAClass;
        if (checkForTypeLevelFieldDefaults && EclipseHandlerUtil.hasAnnotation(FieldDefaults.class, typeNode)) {
            return true;
        }
        TypeDeclaration typeDecl = null;
        if (typeNode.get() instanceof TypeDeclaration) {
            typeDecl = (TypeDeclaration)typeNode.get();
        }
        int modifiers = typeDecl == null ? 0 : typeDecl.modifiers;
        boolean bl = notAClass = (modifiers & 0x2200) != 0;
        if (typeDecl == null || notAClass) {
            pos.addError("@FieldDefaults is only supported on a class or an enum.");
            return false;
        }
        for (EclipseNode field : typeNode.down()) {
            FieldDeclaration fieldDecl;
            if (field.getKind() != AST.Kind.FIELD || !EclipseHandlerUtil.filterField(fieldDecl = (FieldDeclaration)field.get(), false)) continue;
            this.setFieldDefaultsForField(field, (ASTNode)pos.get(), level, makeFinal);
        }
        return true;
    }

    public void setFieldDefaultsForField(EclipseNode fieldNode, ASTNode pos, AccessLevel level, boolean makeFinal) {
        FieldDeclaration field = (FieldDeclaration)fieldNode.get();
        if (level != null && level != AccessLevel.NONE && (field.modifiers & 7) == 0 && !EclipseHandlerUtil.hasAnnotation(PackagePrivate.class, fieldNode)) {
            field.modifiers |= EclipseHandlerUtil.toEclipseModifier(level);
        }
        if (makeFinal && (field.modifiers & 0x10) == 0 && !EclipseHandlerUtil.hasAnnotation(NonFinal.class, fieldNode)) {
            field.modifiers |= 0x10;
        }
        fieldNode.rebuild();
    }

    @Override
    public void handle(AnnotationValues<FieldDefaults> annotation, Annotation ast, EclipseNode annotationNode) {
        EclipseNode node = (EclipseNode)annotationNode.up();
        FieldDefaults instance = annotation.getInstance();
        AccessLevel level = instance.level();
        boolean makeFinal = instance.makeFinal();
        if (level == AccessLevel.NONE && !makeFinal) {
            annotationNode.addError("This does nothing; provide either level or makeFinal or both.");
            return;
        }
        if (node == null) {
            return;
        }
        this.generateFieldDefaultsForType(node, annotationNode, level, makeFinal, false);
    }
}

