/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties.customizer;

import com.ejie.r01f.file.DirectoryWalker;
import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.MainParamsParser;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.customizer.XMLPropertiesCustomizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLPropertiesCustomizerFileProcessor {
    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            MainParamsParser mainParamsParser = new MainParamsParser();
            mainParamsParser.addParamDef("-appCode", "Codigo de aplicacion", MainParamsParser.PARAM_TYPE_GENERAL, true);
            mainParamsParser.addParamDef("-env", "Entorno (loc/sb_des/des/sb_pru/pru/pro)", MainParamsParser.PARAM_TYPE_GENERAL, true);
            mainParamsParser.addParamDef("-exceptionRegExp", "Expresion regular que indica que appCodes no se aplican segun el env ", MainParamsParser.PARAM_TYPE_GENERAL, true);
            mainParamsParser.addParamDef("-varsFile", "Fichero XML con los valores de las variables", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-targetDir", "Directorio donde dejar los ficheros customizados", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-templatesDir", "Directorio donde se encuentran los ficheros 'plantilla'", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            mainParamsParser.addParamDef("-keepNotMatchingIfs", "Devolver las condiciones if que no se cumplan", MainParamsParser.PARAM_TYPE_BOOLEAN, false);
            mainParamsParser.parseParams(args);
            if (mainParamsParser.areValid()) {
                boolean keepNotMatchingIfs;
                String appCode = mainParamsParser.getParam("-appCode");
                String env = mainParamsParser.getParam("-env");
                String exceptionRegExp = mainParamsParser.getParam("-exceptionRegExp");
                String templatesDirPath = mainParamsParser.getParam("-templatesDir");
                String targetDirPath = mainParamsParser.getParam("-targetDir");
                String varsFilePath = mainParamsParser.getParam("-varsFile");
                HashMap<String, ArrayList<String>> exceptionMap = new HashMap<String, ArrayList<String>>();
                if (exceptionRegExp != null && exceptionRegExp.length() > 0) {
                    String[] exceptionRegExps = exceptionRegExp.split(",");
                    int i = 0;
                    while (i < exceptionRegExps.length) {
                        String[] parKeyValue = exceptionRegExps[i].split(":");
                        String key = parKeyValue[0];
                        ArrayList<String> appsToExclude = new ArrayList<String>(Arrays.asList(parKeyValue[1].split(";")));
                        exceptionMap.put(key, appsToExclude);
                        ++i;
                    }
                }
                boolean bl = mainParamsParser.getParam("-keepNotMatchingIfs") != null ? mainParamsParser.getParam("-keepNotMatchingIfs").equalsIgnoreCase("true") : (keepNotMatchingIfs = false);
                if (appCode != null && env != null && templatesDirPath == null && targetDirPath == null && varsFilePath == null) {
                    String[] envSplitted = env.split(",");
                    int j = 0;
                    while (j < envSplitted.length) {
                        String[] appCodeSplitted = appCode.split(",");
                        int i = 0;
                        while (i < appCodeSplitted.length) {
                            String appCodeRoot = appCode.substring(0, appCodeSplitted[i].length() - 1);
                            templatesDirPath = "d:/tools/workSpaces/" + appCodeRoot + "/" + appCodeSplitted[i] + "Classes/" + appCodeSplitted[i] + "/template";
                            targetDirPath = "d:/tools/workSpaces/" + appCodeRoot + "/" + appCodeSplitted[i] + "Classes/" + appCodeSplitted[i] + "/" + envSplitted[j] + "/" + (envSplitted[j].equalsIgnoreCase("loc") || envSplitted[j].equalsIgnoreCase("other") ? "" : String.valueOf(appCodeSplitted[i]) + "/");
                            String[] domainAndEnv = envSplitted[j].split("/");
                            varsFilePath = domainAndEnv.length == 1 ? "d:/tools/workSpaces/r01/r01mLibs/_ejie_environment_properties/" + appCodeRoot + "/" + appCodeRoot + ".properties.vars." + envSplitted[j] + ".xml" : "d:/tools/workSpaces/r01/r01mLibs/_ejie_environment_properties/" + appCodeRoot + "/" + envSplitted[j] + "/" + appCodeRoot + ".properties.vars." + domainAndEnv[0] + ".xml";
                            R01FLog.to("r01f.test").fine("\r\n\r\n\r\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
                            R01FLog.to("r01f.test").fine("Parametros de llamada:");
                            R01FLog.to("r01f.test").fine("...-appCode=" + appCodeSplitted[i]);
                            R01FLog.to("r01f.test").fine("...-env=" + envSplitted[j]);
                            R01FLog.to("r01f.test").fine("...-templatesDir=" + templatesDirPath);
                            R01FLog.to("r01f.test").fine("...-targetDir=" + targetDirPath);
                            R01FLog.to("r01f.test").fine("...-varsFile=" + varsFilePath);
                            R01FLog.to("r01f.test").fine("\r\n\r\n..............................................................");
                            boolean customize = true;
                            for (String pattern : exceptionMap.keySet()) {
                                Pattern p = Pattern.compile(".*" + pattern + ".*");
                                Matcher m = p.matcher(envSplitted[j]);
                                if (!m.matches() || !((List)exceptionMap.get(pattern)).contains(appCodeSplitted[i])) continue;
                                customize = false;
                                break;
                            }
                            if (customize) {
                                XMLPropertiesCustomizerFileProcessor._customizeProperties(keepNotMatchingIfs, appCode, templatesDirPath, targetDirPath, varsFilePath);
                            }
                            ++i;
                        }
                        ++j;
                    }
                } else if (templatesDirPath != null && targetDirPath != null && varsFilePath != null) {
                    XMLPropertiesCustomizerFileProcessor._customizeProperties(keepNotMatchingIfs, appCode, templatesDirPath, targetDirPath, varsFilePath);
                } else {
                    R01FLog.to("r01f.test").fine("\r\n\r\n\r\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
                    R01FLog.to("r01f.test").fine("Error en los parametros de llamada. Hay dos formas de utilizaci\u00f3n:");
                    R01FLog.to("r01f.test").fine("...-appCode=[codigoAplicacion]");
                    R01FLog.to("r01f.test").fine("...-env=[Entorno (loc/sb_des/des/sb_pru/pru/pro)");
                    R01FLog.to("r01f.test").fine("...-templatesDir=[directorio con las plantillas] -targetDir=[directorio destino] -varsFile=[fichero de varialbes]");
                    R01FLog.to("r01f.test").fine("\r\n\r\n..............................................................");
                    System.exit(0);
                }
            } else {
                R01FLog.to("r01f.test").fine("ERROR AL INVOCAR AL PROGRAMA.\r\nFaltan parametros:");
                R01FLog.to("r01f.test").fine(mainParamsParser.getParamsUsageMessage());
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void _customizeProperties(boolean keepNotMatchingIfs, String appCode, String templatesDirPath, String targetDirPath, String varsFilePath) throws Exception {
        XMLPropertiesCustomizerFileProcessor proc;
        File templatesDirFile = new File(templatesDirPath);
        if (!templatesDirFile.exists()) {
            throw new Exception("No existe el directorio " + templatesDirPath + " con las plantillas de los ficheros de propiedades!");
        }
        if (!templatesDirFile.isDirectory()) {
            throw new Exception(String.valueOf(templatesDirPath) + " NO es un DIRECTORIO!");
        }
        File targetDirFile = new File(targetDirPath);
        if (!targetDirFile.exists()) {
            throw new Exception("No existe el directorio destino " + targetDirFile + " donde se van a dejar las propiedades parametrizadas");
        }
        if (!targetDirFile.isDirectory()) {
            throw new Exception(targetDirFile + " NO es un DIRECTORIO!");
        }
        File varsFile = new File(varsFilePath);
        if (!varsFile.exists()) {
            throw new Exception("No existe el fichero XML con las variables " + varsFilePath);
        }
        if (varsFile.isDirectory()) {
            throw new Exception(varsFile + " NO es un fichero!!!");
        }
        R01FLog.to("r01f.test").fine("\r\n\r\n\r\n::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::");
        R01FLog.to("r01f.test").fine("Parametrizando los ficheros de propiedades del directorio " + templatesDirPath + "...");
        R01FLog.to("r01f.test").fine("...se utilizan las variables del fichero " + varsFilePath);
        R01FLog.to("r01f.test").fine("...los ficheros parametrizados resultantes se dejaran en el directorio " + targetDirPath);
        R01FLog.to("r01f.test").fine("\r\n\r\n..............................................................");
        XMLPropertiesCustomizer customizer = new XMLPropertiesCustomizer(appCode, keepNotMatchingIfs);
        Properties vars = customizer.parseVarsXMLFile(new FileInputStream(varsFilePath));
        R01FLog.to("r01f.test").fine("Valores de las variables:\r\n" + customizer.composeVarsDebugInfo(vars));
        R01FLog.to("r01f.test").fine("\r\n\r\n..............................................................");
        R01FLog.to("r01f.test").fine("Customizando los ficheros de propiedades:");
        XMLPropertiesCustomizerFileProcessor xMLPropertiesCustomizerFileProcessor = proc = new XMLPropertiesCustomizerFileProcessor();
        xMLPropertiesCustomizerFileProcessor.getClass();
        CustomizerDirWalkerEventListener eventListener = xMLPropertiesCustomizerFileProcessor.new CustomizerDirWalkerEventListener(customizer, vars, targetDirPath);
        DirectoryWalker dirWalk = new DirectoryWalker(templatesDirPath, eventListener);
        while (dirWalk.hasNext()) {
            dirWalk.next();
        }
    }

    private class CustomizerDirWalkerEventListener
    implements DirectoryWalkerEventListener {
        private String _targetDirPath = null;
        private XMLPropertiesCustomizer _propsCustomizer = null;
        private Properties _vars = null;
        private String _currTargetDirPath = null;
        private Stack _prevTargetDirPaths = null;
        private static final String REPOSITORY_PATH_CVS = "CVS";
        private static final String REPOSITORY_PATH_SVN = ".svn";

        public CustomizerDirWalkerEventListener() {
        }

        public CustomizerDirWalkerEventListener(XMLPropertiesCustomizer customizer, Properties vars, String targetDirPath) {
            this._propsCustomizer = customizer;
            this._vars = vars;
            this._currTargetDirPath = this._targetDirPath = targetDirPath;
            this._prevTargetDirPaths = new Stack();
        }

        @Override
        public void enteringDirectory(File theDirectory) {
            if (theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_CVS) > 0 || theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_SVN) > 0) {
                return;
            }
            this._prevTargetDirPaths.push(this._currTargetDirPath);
            this._currTargetDirPath = String.valueOf(this._currTargetDirPath) + File.separator + theDirectory.getName();
            String newDirPath = StringUtils.replaceVariableValues(this._currTargetDirPath, '$', (Map)this._vars);
            File newDir = new File(newDirPath);
            if (!newDir.exists()) {
                newDir.mkdir();
            }
        }

        @Override
        public void exitingDirectory(File theDirectory) {
            if (theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_CVS) > 0 || theDirectory.getAbsolutePath().indexOf(REPOSITORY_PATH_SVN) > 0) {
                return;
            }
            this._currTargetDirPath = (String)this._prevTargetDirPaths.pop();
        }

        @Override
        public void file(File theFile) {
            try {
                if (theFile.getAbsolutePath().indexOf(REPOSITORY_PATH_CVS) > 0 || theFile.getAbsolutePath().indexOf(REPOSITORY_PATH_SVN) > 0) {
                    return;
                }
                System.out.print("- fichero: " + theFile.getAbsolutePath() + "\n");
                String currFileCustomized = this._propsCustomizer.customize((Reader)new FileReader(theFile), this._vars);
                R01FLog.to("r01f.test").fine(" [OK]");
                String filePath = String.valueOf(this._currTargetDirPath) + File.separator + theFile.getName();
                filePath = StringUtils.replaceVariableValues(filePath, '$', (Map)this._vars);
                FileUtils.saveFile(new File(filePath), new ByteArrayInputStream(currFileCustomized.getBytes()));
            }
            catch (FileNotFoundException fnfEx) {
                R01FLog.to("r01f.test").fine("[error]");
                fnfEx.printStackTrace(System.out);
            }
            catch (IOException ioEx) {
                R01FLog.to("r01f.test").fine("[error]");
                ioEx.printStackTrace(System.out);
            }
        }
    }
}

