/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties.customizer;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.TextCustomizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPropertiesCustomizer {
    private static final transient String VARIABLE_BEGIN = "$[";
    private static final transient String VARIABLE_END = "]$";
    private static final transient String IF_BEGIN = "<!--#if";
    private static final transient String IF_END = "#endif-->";
    private String _appCode;
    private TextCustomizer _customizer = new TextCustomizer();

    public XMLPropertiesCustomizer() {
    }

    public XMLPropertiesCustomizer(String appCode, boolean keepNotMatchingIfs) {
        this();
        this._customizer.setKeepNotMatchingIfs(keepNotMatchingIfs);
        this._appCode = appCode;
    }

    public String customize(Reader propsReader, Properties vars) throws IOException {
        return this._customizer.customize(propsReader, vars);
    }

    public String customize(Reader propsReader, InputStream varsXML) throws IOException, SAXException {
        Properties vars = this.parseVarsXMLFile(varsXML);
        return this.customize(propsReader, vars);
    }

    public Properties parseVarsXMLFile(InputStream varsXML) throws SAXException {
        PropertiesValuesLoader propsLoader = new PropertiesValuesLoader(this._appCode);
        return propsLoader.load(varsXML);
    }

    public String composeVarsDebugInfo(Properties vars) {
        return this._customizer.composeVarsDebugInfo(vars);
    }

    private String _doCustomizeProperties(Reader r, Properties vars) throws IOException {
        if (r == null) {
            throw new IOException("El reader es null: No se puede customizar el fichero de propiedades!");
        }
        return this._customizer.customize(r, vars);
    }

    public static void main(String[] args) {
        try {
            XMLPropertiesCustomizer customizer = new XMLPropertiesCustomizer();
            String props = "<properties>\r\n    <!--#if{$var1$=='var1Value'}\r\n    <miPropiedad>$[var1]$</miPropiedad>\r\n    #endif-->\r\n    <miPropiedad2 attr='$[var3]$'>\r\n        <value>Esto es va1=$[var1]$' (sustituido)</value>\r\n    </miPropiedad2>\r\n    <miXML>\r\n        $[varXML]$\r\n    </miXML>\r\n</properties>";
            Properties vars = new Properties();
            vars.setProperty("var1", "var1Value");
            vars.setProperty("var2", "var2Value");
            vars.setProperty("varXML", "<hola>\r\n\t<adios>by</adios>\r\n</hola>\r\n");
            String propsCustomizationsXML = "<propertiesCustomizations>\r\n   <property name='var1'><![CDATA[var1Value]]></property>\r\n   <property name='var2'><![CDATA[var2Value]]></property>\r\n   <property name='var3'><![CDATA[var3Value]]></property>\r\n   <property name='varXML'><![CDATA[Esto es un XML]]></property>\r\n</propertiesCustomizations>";
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            int times = 0;
            while (times < testTimes) {
                Properties vs = customizer.parseVarsXMLFile(new ByteArrayInputStream(propsCustomizationsXML.getBytes()));
                R01FLog.to("r01f.test").fine("Variables: \r\n" + customizer.composeVarsDebugInfo(vs));
                R01FLog.to("r01f.test").fine(customizer.customize((Reader)new StringReader(props), vars));
                R01FLog.to("r01f.test").fine("\r\n\r\n\r\n\r\n--------------------------------------------------------------");
                R01FLog.to("r01f.test").fine(customizer.customize((Reader)new StringReader(props), new ByteArrayInputStream(propsCustomizationsXML.getBytes())));
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class PropertiesValuesLoader
    extends DefaultHandler {
        private String PROPERTY_TAG = "property";
        private String PROPERTY_NAME_ATTR = "name";
        private Properties _props;
        private String _theAppCode;
        private String _currPropertyName;
        private StringBuffer _currPropertyValue;

        public PropertiesValuesLoader() {
        }

        public PropertiesValuesLoader(String appCode) {
            this._theAppCode = appCode;
        }

        public Properties load(InputStream is) throws SAXException {
            this._loadFromXML(is);
            this._props.put("appCode", this._theAppCode);
            for (Map.Entry<Object, Object> me : this._props.entrySet()) {
                String varName;
                String currVar = (String)me.getValue();
                String regExp = ".*\\$\\[([^]]*)\\]\\$.*";
                Pattern p = Pattern.compile(regExp, 32);
                Matcher m = p.matcher(currVar);
                if (!m.matches() || (varName = m.group(1)) == null) continue;
                String varValue = this._props.getProperty(varName);
                if (varValue == null) {
                    throw new SAXException("La variable " + varName + " NO tiene valor!!!");
                }
                currVar = currVar.replaceAll("\\$\\[" + varName + "\\]\\$", varValue);
                this._props.setProperty((String)me.getKey(), currVar);
            }
            return this._props;
        }

        public Properties load(String inXMLStr) throws SAXException {
            this.load(new ByteArrayInputStream(inXMLStr.getBytes()));
            return this._props;
        }

        private void _loadFromXML(InputStream is) throws SAXException {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, (DefaultHandler)this);
            }
            catch (ParserConfigurationException pcEx) {
                throw new SAXException("Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
            }
            catch (IOException ioEx) {
                throw new SAXException("Error de IO " + ioEx.getMessage());
            }
        }

        @Override
        public void startDocument() {
            this._props = new Properties();
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equalsIgnoreCase(this.PROPERTY_TAG) && attrs != null && attrs.getValue(this.PROPERTY_NAME_ATTR) != null) {
                this._currPropertyName = attrs.getValue(this.PROPERTY_NAME_ATTR);
                this._currPropertyValue = new StringBuffer();
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            String s = new String(buf, offset, len);
            if (this._currPropertyValue != null) {
                this._currPropertyValue.append(s);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (eName.equalsIgnoreCase(this.PROPERTY_TAG) && this._currPropertyName != null) {
                this._props.setProperty(this._currPropertyName.trim(), this._currPropertyValue.toString().trim());
            }
            this._currPropertyName = null;
            this._currPropertyValue = null;
        }
    }
}

