/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlproperties;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLPropertiesManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XMLProperties {
    private static final String _PROPERTIES_PATTERN_SYSPROP_NAME = "EJIE_PROPERTIES_PATTERN";
    private static final String _PROPERTIES_CONFIGROOT_SYSPROP_NAME = "EJIE_CONFIG_FILES_ROOT";
    private static XMLPropertiesManager _xManager;

    static {
        String warningMsgSep = "*************************************************************************************************";
        String propsPathPattern = System.getProperty(_PROPERTIES_PATTERN_SYSPROP_NAME);
        if (propsPathPattern == null) {
            String propsLoader = XMLPropertiesManager.getPropertiesLoader();
            if (propsLoader == null || propsLoader.equalsIgnoreCase("fileLoader")) {
                String configFileRoot = System.getProperty(_PROPERTIES_CONFIGROOT_SYSPROP_NAME);
                propsPathPattern = configFileRoot != null ? (configFileRoot.endsWith("/") ? String.valueOf(configFileRoot) + "[entityCode]/[entityCode].properties.xml" : String.valueOf(configFileRoot) + "/[entityCode]/[entityCode].properties.xml") : (System.getProperty("os.name").startsWith("Windows") ? "d:/eAdmin/config/[entityCode]/[entityCode].properties.xml" : "/config/[entityCode]/[entityCode].properties.xml");
                String warningMsg = "\r\nLa carga de propiedades se hace en base a FileLoader\r\n";
                warningMsg = String.valueOf(warningMsg) + "NO se ha establecido el patr\u00f3n con el fichero de propiedades!!!!\r\n";
                warningMsg = String.valueOf(warningMsg) + "se toma la configuracion dependiente del sistema operativo: " + propsPathPattern + "\r\n";
                Logger.global.warning(String.valueOf(warningMsgSep) + warningMsg + warningMsgSep);
            } else if (propsLoader.equalsIgnoreCase("classPathLoader")) {
                propsPathPattern = "/[entityCode]/[entityCode].properties.xml";
                String warningMsg = "\r\nLa carga de propiedades se hace en base a classPathLoader\r\n";
                warningMsg = String.valueOf(warningMsg) + "\r\nNO se ha establecido el patr\u00f3n con el fichero de propiedades!!!!\r\n";
                warningMsg = String.valueOf(warningMsg) + "se toma la configuracion por defecto: " + propsPathPattern + "\r\n";
                Logger.global.warning(String.valueOf(warningMsgSep) + warningMsg + warningMsgSep);
            }
        }
        String usageMsg = "\r\n\tSe puede establecer el patr\u00f3n para los ficheros de propiedades de dos formas:\r\n\t\t- System.setProperty(EJIE_PROPERTIES_PATTERN,pattern utilizando [entityCode] como variable del c\u00f3digo de aplicacion)\r\n\t\t- Establecer la propiedad EJIE_PROPERTIES_PATTERN en el arranque de la jvm con el parametro: -DEJIE_PROPERTIES_PATTERN=pattern utilizando [entityCode] como variable del c\u00f3digo de aplicacion";
        Logger.global.warning("\r\n\r\n" + warningMsgSep + "\r\nPATRON DE CARGA DE PROPIEDADES :" + propsPathPattern + "\r\n" + usageMsg + "\r\n" + warningMsgSep + "\r\n\r\n\r\n");
        _xManager = new XMLPropertiesManager(propsPathPattern, "properties");
    }

    protected XMLProperties() {
    }

    public static boolean existProperty(String appCode, String propXPath) {
        return _xManager.existProperty(appCode, propXPath);
    }

    public static String getProperty(String appCode, String propXPath) {
        return _xManager.getProperty(appCode, propXPath);
    }

    public static String getProperty(String appCode, String propXPath, String defaultValue) {
        String outValue = XMLProperties.getProperty(appCode, propXPath);
        return outValue != null ? outValue : defaultValue;
    }

    public static String get(String appCode, String propXPath) {
        return XMLProperties.getProperty(appCode, propXPath);
    }

    public static String get(String appCode, String propXPath, String defValue) {
        String outValue = XMLProperties.get(appCode, propXPath);
        return outValue != null ? outValue : defValue;
    }

    public static String customize(String appCode, String propXPath, String[] variables) {
        return _xManager.customize(appCode, propXPath, variables);
    }

    public static String getCustomized(String appCode, String propXPath, String[] variables) {
        return _xManager.customize(appCode, propXPath, variables);
    }

    public static Node getPropertyNode(String appCode, String propXPath) {
        return _xManager.getPropertyNode(appCode, propXPath);
    }

    public static NodeIterator getPropertyNodeIterator(String appCode, String propXPath) {
        return _xManager.getPropertyNodeIterator(appCode, propXPath);
    }

    public static List getPropertyList(String appCode, String propXPath) {
        return _xManager.getPropertyList(appCode, propXPath);
    }

    public static List getPropertyList(String appCode, String propXPath, List defaultValue) {
        List outValue = _xManager.getPropertyList(appCode, propXPath);
        return outValue != null ? outValue : defaultValue;
    }

    public static List getPropertyList(String appCode, String propXPath, String[] defaultValue) {
        ArrayList<String> defList = null;
        if (defaultValue != null && defaultValue.length > 0) {
            defList = new ArrayList<String>(defaultValue.length);
            int i = 0;
            while (i < defaultValue.length) {
                defList.add(defaultValue[i]);
                ++i;
            }
        }
        List outValue = XMLProperties.getPropertyList(appCode, propXPath, defList);
        return outValue;
    }

    public static Properties getProperties(String appCode, String propXPath) {
        return _xManager.getProperties(appCode, propXPath);
    }

    public static String getString(String appCode, String propXPath) {
        return _xManager.getProperty(appCode, propXPath);
    }

    public static String getString(String appCode, String propXPath, String defaultValue) {
        String outValue = XMLProperties.getString(appCode, propXPath);
        return outValue != null ? outValue : defaultValue;
    }

    public static char getChar(String appCode, String propXPath) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return '\u0000';
        }
        return strProp.charAt(0);
    }

    public static char getChar(String appCode, String propXPath, char defaultValue) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return defaultValue;
        }
        return strProp.charAt(0);
    }

    public static boolean getBoolean(String appCode, String propXPath) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return false;
        }
        return (strProp = strProp.trim()).equalsIgnoreCase("true");
    }

    public static boolean getBoolean(String appCode, String propXPath, boolean defValue) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return defValue;
        }
        return (strProp = strProp.trim()).equalsIgnoreCase("true");
    }

    public static int getInt(String appCode, String propXPath) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(strProp);
    }

    public static int getInt(String appCode, String propXPath, int defaultValue) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return defaultValue;
        }
        return Integer.parseInt(strProp);
    }

    public static long getLong(String appCode, String propXPath) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(strProp);
    }

    public static long getLong(String appCode, String propXPath, long defaultValue) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return defaultValue;
        }
        return Long.parseLong(strProp);
    }

    public static double getDouble(String appCode, String propXPath) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(strProp);
    }

    public static double getDouble(String appCode, String propXPath, double defaultValue) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return defaultValue;
        }
        return Double.parseDouble(strProp);
    }

    public static float getFloat(String appCode, String propXPath) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return Float.MIN_VALUE;
        }
        return Float.parseFloat(strProp);
    }

    public static float getFloat(String appCode, String propXPath, float defaultValue) {
        String strProp = _xManager.getProperty(appCode, propXPath);
        if (strProp == null) {
            return defaultValue;
        }
        return Float.parseFloat(strProp);
    }

    public static void reload() {
        _xManager.reload();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1000;
            int times = 0;
            while (times < testTimes) {
                R01FLog.to("r01f.test").fine("=======================XMLProperties============================");
                R01FLog.to("r01f.test").fine("--->p03.elemento: " + XMLProperties.getProperty("p03", "elemento/valor"));
                R01FLog.to("r01f.test").fine("--->r01.elemento: " + XMLProperties.getProperty("r01", "elemento/valor"));
                R01FLog.to("r01f.test").fine("\r\n--->p03.lista:");
                List lista3 = XMLProperties.getPropertyList("p03", "lista/elemento");
                if (lista3 != null) {
                    Iterator it = lista3.iterator();
                    while (it.hasNext()) {
                        System.out.print(String.valueOf((String)it.next()) + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").fine("\r\n--->r01.lista:");
                List lista1 = XMLProperties.getPropertyList("r01", "lista/elemento");
                if (lista1 != null) {
                    Iterator it = lista1.iterator();
                    while (it.hasNext()) {
                        System.out.print(String.valueOf((String)it.next()) + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").fine("\r\n--->p03.properties:");
                Properties props3 = XMLProperties.getProperties("p03", "props");
                if (props3 != null) {
                    for (Map.Entry<Object, Object> me : props3.entrySet()) {
                        System.out.print(String.valueOf((String)me.getKey()) + ":" + (String)me.getValue() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").fine("\r\n--->r01.properties:");
                Properties props1 = XMLProperties.getProperties("r01", "props");
                if (props1 != null) {
                    for (Map.Entry<Object, Object> me : props1.entrySet()) {
                        System.out.print(String.valueOf((String)me.getKey()) + ":" + (String)me.getValue() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").fine("\r\n--->r01.database:");
                Properties props4 = XMLProperties.getProperties("r01", "database/connection[@name='uidGenerator']");
                if (props4 != null) {
                    for (Map.Entry<Object, Object> me : props4.entrySet()) {
                        System.out.print(String.valueOf((String)me.getKey()) + ":" + (String)me.getValue() + "\r\n");
                    }
                }
                R01FLog.to("r01f.test").fine("\r\n\r\n\r\n----------------------------------------------------");
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String printDebugInfo() {
        return _xManager.printDebugInfo();
    }

    public static String getDebugInfo() {
        return _xManager.printDebugInfo();
    }
}

