/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xmlbuilder;

import com.ejie.r01f.xmlbuilder.XMLAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XMLNode
implements Serializable {
    private static final long serialVersionUID = 5653300885241070853L;
    private String name;
    private String value;
    private boolean isCDATA;
    private Map nodesMap;
    private Map attrsMap;
    private List attributes;
    private List subNodes;

    public XMLNode() {
    }

    public XMLNode(boolean newIsCDATA) {
        this.isCDATA = newIsCDATA;
    }

    public XMLNode(String newNodeName) {
        this.name = newNodeName;
    }

    public XMLNode(String newNodeName, String newNodeValue) {
        this.name = newNodeName;
        this.value = newNodeValue;
    }

    public XMLNode(String newNodeName, boolean newIsCDATA) {
        this(newNodeName);
        this.isCDATA = newIsCDATA;
    }

    public XMLNode(String newNodeName, String newNodeValue, boolean newIsCDATA) {
        this(newNodeName, newNodeValue);
        this.isCDATA = newIsCDATA;
    }

    public String getNodeName() {
        return this.name == null ? "" : this.name;
    }

    public void setNodeName(String inName) {
        this.name = inName;
    }

    public String getNodeValue() {
        return this.value == null ? "" : this.value;
    }

    public void setNodeValue(String newValue) {
        this.value = newValue;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }

    public void setCDATA(boolean newIsCDATA) {
        this.isCDATA = newIsCDATA;
    }

    public List getSubNodes() {
        return this.subNodes;
    }

    public XMLNode getSubNode(String nodeName) {
        if (this.nodesMap == null) {
            return null;
        }
        return (XMLNode)this.nodesMap.get(nodeName);
    }

    public void addSubNode(XMLNode newSubNode) {
        if (this.subNodes == null) {
            this.subNodes = new ArrayList();
        }
        this.subNodes.add(newSubNode);
        if (this.nodesMap == null) {
            this.nodesMap = new HashMap();
        }
        this.nodesMap.put(newSubNode.getNodeName(), newSubNode);
    }

    public XMLNode removeSubNode(String nodeName) {
        if (this.subNodes == null) {
            return null;
        }
        XMLNode oldNode = (XMLNode)this.nodesMap.remove(nodeName);
        if (oldNode != null) {
            this.subNodes.remove(oldNode);
        }
        return oldNode;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public XMLAttribute getAttribute(String attrName) {
        if (this.attrsMap == null) {
            return null;
        }
        return (XMLAttribute)this.attrsMap.get(attrName);
    }

    public void addAttribute(XMLAttribute newAttr) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(newAttr);
        if (this.attrsMap == null) {
            this.attrsMap = new HashMap();
        }
        this.attrsMap.put(newAttr.getAttributeName(), newAttr);
    }

    public void addAttribute(String attrName, String attrValue) {
        this.addAttribute(new XMLAttribute(attrName, attrValue));
    }

    public XMLAttribute removeAttribute(String attrName) {
        if (this.attributes == null) {
            return null;
        }
        XMLAttribute oldAttr = (XMLAttribute)this.attrsMap.remove(attrName);
        if (oldAttr != null) {
            this.attributes.remove(oldAttr);
        }
        return oldAttr;
    }

    public boolean isEmpty() {
        return this.value == null && this.subNodes == null && this.attributes == null;
    }

    public String toString() {
        Iterator it;
        int size = this.attributes != null && this.attributes.size() > 0 ? this.attributes.size() * 128 : 32;
        StringBuffer sb = new StringBuffer(size += this.subNodes != null && this.subNodes.size() > 0 ? this.subNodes.size() * 256 : 32);
        sb.append("<");
        sb.append(this.getNodeName());
        if (this.attributes != null) {
            it = this.attributes.iterator();
            while (it.hasNext()) {
                sb.append(" ");
                sb.append(((XMLAttribute)it.next()).toString());
            }
        }
        if (this.value == null && this.subNodes == null) {
            sb.append("/>");
        } else {
            sb.append(">");
            if (this.isCDATA) {
                sb.append("<![CDATA[");
            }
            if (this.value != null) {
                sb.append(this.value);
            }
            if (this.subNodes != null) {
                it = this.subNodes.iterator();
                while (it.hasNext()) {
                    sb.append(((XMLNode)it.next()).toString());
                }
            }
            if (this.isCDATA) {
                sb.append("]]>");
            }
            sb.append("</");
            sb.append(this.getNodeName());
            sb.append(">");
        }
        return sb.toString();
    }
}

