/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParserHelper {
    public static Document parseXML(InputStream xmlIs, final String[] ignoredEntities) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String key;
                    String string = key = publicId != null ? String.valueOf(publicId) + "." + systemId : systemId;
                    if (this._isIgnoredExternalEntity(key)) {
                        return new InputSource(new ByteArrayInputStream("".getBytes()));
                    }
                    return null;
                }

                private boolean _isIgnoredExternalEntity(String key) {
                    if (ignoredEntities != null) {
                        int i = 0;
                        while (i < ignoredEntities.length) {
                            if (ignoredEntities[i].equals(key)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    return false;
                }
            });
            return builder.parse(xmlIs);
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException(pcEx);
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }

    public static Document parseXML(InputStream xmlIs, final boolean ignoreDTD) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    if (ignoreDTD) {
                        return new InputSource(new ByteArrayInputStream("".getBytes()));
                    }
                    return null;
                }
            });
            return builder.parse(xmlIs);
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException(pcEx);
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }
}

