/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.xml.marshalling.ClassInstance;
import com.ejie.r01f.xml.marshalling.ClassMap;
import com.ejie.r01f.xml.marshalling.MappingReflectionUtils;
import com.ejie.r01f.xml.marshalling.MemberMap;
import com.ejie.r01f.xml.marshalling.XOMap;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class ObjsFromXMLBuilder {
    XOMap _map;

    public ObjsFromXMLBuilder() {
    }

    public ObjsFromXMLBuilder(XOMap map) {
        this();
        this._map = map;
    }

    public ObjsFromXMLBuilder(InputStream mapIS) throws SAXException {
        this();
        if (mapIS != null) {
            XOMap orW = new XOMap();
            orW.loadFromXML(mapIS);
            this._map = orW;
        }
    }

    public final void setORMap(XOMap map) {
        this._map = map;
    }

    public final XOMap getORMap() {
        return this._map;
    }

    public final Object getObject(String xmlStr) throws XOMarshallerException {
        if (xmlStr == null) {
            throw new XOMarshallerException("xmlStr null");
        }
        return this.parseXML(new ByteArrayInputStream(xmlStr.getBytes()));
    }

    public final Object getObject(InputStream is) throws XOMarshallerException {
        if (is == null) {
            throw new XOMarshallerException("InputStream null");
        }
        return this.parseXML(is);
    }

    public final Object getObject(File file) throws XOMarshallerException {
        if (file == null) {
            throw new XOMarshallerException("File null");
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            return this.parseXML(fis);
        }
        catch (FileNotFoundException fnfEx) {
            throw new XOMarshallerException(fnfEx.toString());
        }
    }

    public final Object parseXML(InputStream xmlIS) throws XOMarshallerException {
        if (this._map == null) {
            throw new XOMarshallerException("No se ha establecido el documento de mapeo de clases a XML: Llamar a setORMap, o establecerlo en el constructor");
        }
        if (xmlIS == null) {
            return null;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ObjsFromXMLLoader loader = new ObjsFromXMLLoader();
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", loader);
            if (this._map.getEncoding() != null) {
                InputStreamReader isr = new InputStreamReader(xmlIS, this._map.getEncoding());
                InputSource is = new InputSource(isr);
                saxParser.parse(is, (DefaultHandler)loader);
            } else {
                saxParser.parse(xmlIS, (DefaultHandler)loader);
            }
            ClassInstance instance = loader.mainInstance;
            Object outObj = this._buildObject(instance);
            xmlIS.close();
            return outObj;
        }
        catch (ParserConfigurationException pcEx) {
            throw new XOMarshallerException("Error en la configuraci\u00f3n del parser:\r\n" + pcEx.getMessage());
        }
        catch (SAXException saxEx) {
            throw new XOMarshallerException("Error SAX:\r\n" + saxEx.getMessage(), (Exception)saxEx);
        }
        catch (IOException ioEx) {
            throw new XOMarshallerException("Error de IO:\r\n" + ioEx.getMessage(), (Exception)ioEx);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            throw new XOMarshallerException("Error desconocido en el proceso de marshalling:\r\n" + ex.getMessage(), ex);
        }
    }

    final Object _buildObject(ClassInstance clsInstance) throws XOMarshallerException {
        Object outObj;
        block27: {
            outObj = null;
            if (clsInstance != null && clsInstance.isBuilt && clsInstance.instance != null) {
                return clsInstance.instance;
            }
            if (clsInstance != null) {
                try {
                    outObj = clsInstance.instance;
                    if (clsInstance.members == null) break block27;
                    ClassInstance.MemberInstance currMember2 = null;
                    for (ClassInstance.MemberInstance currMember2 : clsInstance.members.values()) {
                        Object obj;
                        Object value;
                        if (currMember2.instance == null) continue;
                        if (currMember2.instance instanceof String) {
                            value = (String)currMember2.instance;
                            MappingReflectionUtils.setMemberValue(outObj, currMember2.memberMap, value);
                            continue;
                        }
                        if (currMember2.instance instanceof StringBuffer) {
                            value = ((StringBuffer)currMember2.instance).toString();
                            MappingReflectionUtils.setMemberValue(outObj, currMember2.memberMap, value);
                            continue;
                        }
                        if (currMember2.instance instanceof ClassInstance) {
                            Object obj2 = this._buildObject((ClassInstance)currMember2.instance);
                            MappingReflectionUtils.setMemberValue(outObj, currMember2.memberMap, obj2);
                            continue;
                        }
                        if (currMember2.instance instanceof ArrayList) {
                            value = (List)currMember2.instance;
                            if (value.isEmpty()) continue;
                            obj = null;
                            if (currMember2.memberMap.collection == 0) {
                                Class classDef = null;
                                if (this._map.getClassFromClassName(currMember2.memberMap.dataTypeName) == null) {
                                    if (currMember2.memberMap.dataTypeName.equals("String")) {
                                        classDef = String.class;
                                        ReflectionUtils.setMemberValue(outObj, currMember2.memberMap.name, String[].class, new String[value.size()], false);
                                    }
                                } else {
                                    ClassMap classMap = this._map.getClassFromClassName(currMember2.memberMap.dataTypeName);
                                    String fullClassName = String.valueOf(classMap.packageName) + "." + currMember2.memberMap.dataTypeName;
                                    classDef = ReflectionUtils.getObjectClassDef(fullClassName);
                                    MappingReflectionUtils.setMemberValue(outObj, currMember2.memberMap, MappingReflectionUtils.getArrayInstance(classDef, value.size()));
                                }
                            } else {
                                MappingReflectionUtils.setMemberValue(outObj, currMember2.memberMap, MappingReflectionUtils.getListInstance(currMember2.memberMap.collection, value.size()));
                            }
                            int i = 0;
                            Iterator lit = value.iterator();
                            while (lit.hasNext()) {
                                obj = lit.next();
                                if (obj instanceof ClassInstance) {
                                    obj = this._buildObject((ClassInstance)obj);
                                } else if (obj instanceof StringBuffer) {
                                    obj = ((StringBuffer)obj).toString();
                                }
                                if (currMember2.memberMap.collection == 0) {
                                    MappingReflectionUtils.setValueIntoArray(outObj, currMember2.memberMap, obj, i);
                                } else {
                                    MappingReflectionUtils.addValueToList(outObj, currMember2.memberMap, obj);
                                }
                                ++i;
                            }
                            continue;
                        }
                        if (!(currMember2.instance instanceof HashMap) && !(currMember2.instance instanceof LinkedHashMap) || (value = (Map)currMember2.instance).size() <= 0 || value.isEmpty()) continue;
                        obj = null;
                        MappingReflectionUtils.setMemberValue(outObj, currMember2.memberMap, MappingReflectionUtils.getMapInstance(currMember2.memberMap.collection, value.size()));
                        for (Map.Entry me : value.entrySet()) {
                            if (me.getValue() instanceof ClassInstance) {
                                obj = this._buildObject((ClassInstance)me.getValue());
                            } else if (me.getValue() instanceof StringBuffer) {
                                obj = ((StringBuffer)me.getValue()).toString();
                            }
                            if (me.getKey() instanceof StringBuffer) {
                                MappingReflectionUtils.putValueIntoMap(outObj, currMember2.memberMap, me.getKey().toString(), obj);
                                continue;
                            }
                            MappingReflectionUtils.putValueIntoMap(outObj, currMember2.memberMap, me.getKey(), obj);
                        }
                    }
                }
                catch (ReflectionException refEx) {
                    throw new XOMarshallerException("Error de introspeccion: " + refEx.getMessage(), (Exception)refEx);
                }
                catch (ClassNotFoundException cnfEx) {
                    throw new XOMarshallerException("NO se encuentra la clase " + cnfEx.getMessage(), (Exception)cnfEx);
                }
            }
        }
        if (clsInstance != null) {
            clsInstance.isBuilt = true;
        }
        return outObj;
    }

    private class ObjsFromXMLLoader
    extends DefaultHandler
    implements LexicalHandler {
        Stack _tagStack = new Stack();
        Stack _objStack = new Stack();
        ClassInstance mainInstance = null;
        String _rawXMLStartTagName = null;
        int _rawXMLStartTagCount = 0;
        private int _tabs = 0;

        @Override
        public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        }

        @Override
        public void startEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
            if (this._tagStack == null) {
                throw new SAXException("ATENCION!!! Esta clase no puede ser compartida ya que NO ES THREAD SAFE, crea una nueva instancia cada vez que quieras convertir a objetos. \r\nNOTA:El objeto de mapeo SI PUEDE SER COMPARTIDO");
            }
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            String eName = lName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this._rawXMLStartTagCount > 0) {
                if (eName.equals(this._rawXMLStartTagName)) {
                    ++this._rawXMLStartTagCount;
                }
                StringBuffer rawXML = (StringBuffer)this._objStack.peek();
                rawXML.append("<");
                rawXML.append(eName);
                int i = 0;
                while (i < attrs.getLength()) {
                    rawXML.append(" ");
                    rawXML.append(attrs.getQName(i));
                    rawXML.append("='");
                    rawXML.append(attrs.getValue(i));
                    rawXML.append("'");
                    ++i;
                }
                rawXML.append(">");
                return;
            }
            this._tagStack.push(eName);
            if (this.mainInstance == null) {
                ClassMap newObjClassMap = ObjsFromXMLBuilder.this._map.getClassFromXMLTag(eName);
                if (newObjClassMap == null) {
                    throw new SAXException("No se encuentra la definicion de la clase raiz que corresponde con el tag '" + eName + "' revisa el documento de mapeo");
                }
                this.mainInstance = new ClassInstance(eName, newObjClassMap);
                this._setAttributes(this.mainInstance, attrs);
                this._objStack.push(this.mainInstance);
                this._printDebugInfo(eName, this.mainInstance, true);
                return;
            }
            Object parentObj = this._objStack.peek();
            if (parentObj instanceof ClassInstance) {
                ClassInstance parentInstance = (ClassInstance)parentObj;
                ClassInstance.MemberInstance parentMember = parentInstance.addMember(eName, parentInstance.classMap.getMemberFromXMLElement(eName));
                this._objStack.push(parentMember);
                parentObj = parentMember;
            }
            if (parentObj instanceof ClassInstance.MemberInstance) {
                ClassInstance.MemberInstance parentMember = (ClassInstance.MemberInstance)parentObj;
                if (parentMember.instance instanceof StringBuffer) {
                    this._objStack.push(parentMember.instance);
                    if (parentMember.memberMap.dataType == 16) {
                        this._rawXMLStartTagCount = 1;
                        this._rawXMLStartTagName = eName;
                    }
                } else if (parentMember.instance instanceof ClassInstance) {
                    ClassInstance parentClass = (ClassInstance)parentMember.instance;
                    this._setAttributes(parentClass, attrs);
                    this._objStack.push(parentMember.instance);
                } else if (parentMember.memberMap.isCollection()) {
                    this._objStack.push(parentMember.instance);
                }
            } else if (parentObj instanceof HashMap || parentObj instanceof ArrayList || parentObj instanceof LinkedHashMap) {
                ClassMap newObjClassMap = ObjsFromXMLBuilder.this._map.getClassFromXMLTag(eName);
                ClassInstance newInstance = null;
                if (newObjClassMap == null) {
                    newInstance = new ClassInstance(eName, null);
                    this._objStack.push(newInstance);
                    this._objStack.push(newInstance.instance);
                } else {
                    newInstance = new ClassInstance(eName, newObjClassMap);
                    this._setAttributes(newInstance, attrs);
                    this._objStack.push(newInstance);
                }
            }
            this._printDebugInfo(eName, this._objStack.peek(), true);
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            Object currObj = this._objStack.peek();
            String tag = (String)this._tagStack.peek();
            if (!(currObj instanceof StringBuffer)) {
                if (currObj instanceof ClassInstance) {
                    ClassInstance instance = (ClassInstance)currObj;
                    MemberMap memberMap = instance.classMap.getMemberFromXMLElement(tag);
                    if (memberMap != null) {
                        ClassInstance.MemberInstance member = (ClassInstance.MemberInstance)instance.members.get(tag);
                        if (member == null) {
                            R01FLog.to("r01f.xoMap").warning("No se ha definido el miembro en el que se mapean los caracteres del tag '" + tag + "' en la clase '" + instance.classMap.name + "'");
                        } else if (member.instance instanceof StringBuffer) {
                            ((StringBuffer)member.instance).append(buf, offset, len);
                        } else {
                            R01FLog.to("r01f.xoMap").warning("Los datos del texto del tag '" + tag + "' no se pueden mapear directamente a un miembro de la clase '" + instance.classMap.name + "' que no sea de un tipo basico: (String, Date, Integer, etc)!!.\r\nRevisa el documento de mapeo");
                        }
                    }
                }
                return;
            }
            ((StringBuffer)currObj).append(buf, offset, len);
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this._rawXMLStartTagCount > 0) {
                StringBuffer rawXML = (StringBuffer)this._objStack.peek();
                rawXML.append("<![CDATA[");
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this._rawXMLStartTagCount > 0) {
                StringBuffer rawXML = (StringBuffer)this._objStack.peek();
                rawXML.append("]]>");
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            String eName = sName;
            if ("".equals(eName)) {
                eName = qName;
            }
            if (this._rawXMLStartTagCount > 0) {
                if (this._rawXMLStartTagName.equals(eName)) {
                    --this._rawXMLStartTagCount;
                }
                if (this._rawXMLStartTagCount > 0) {
                    StringBuffer rawXML = (StringBuffer)this._objStack.peek();
                    rawXML.append("</");
                    rawXML.append(eName);
                    rawXML.append(">");
                    return;
                }
                this._rawXMLStartTagCount = 0;
                this._rawXMLStartTagName = null;
            }
            this._tagStack.pop();
            Object currObj = this._objStack.pop();
            if (currObj instanceof StringBuffer || currObj instanceof HashMap || currObj instanceof LinkedHashMap || currObj instanceof ArrayList) {
                currObj = this._objStack.pop();
                this._printDebugInfo(eName, currObj, false);
            }
            Object parent = null;
            parent = this._objStack.isEmpty() ? currObj : this._objStack.peek();
            if (parent instanceof ArrayList) {
                List theList = parent;
                ClassInstance instance = (ClassInstance)currObj;
                if (instance.instance instanceof StringBuffer) {
                    theList.add(instance.instance);
                } else {
                    theList.add(currObj);
                }
            } else if (parent instanceof HashMap || parent instanceof LinkedHashMap) {
                Map theMap = parent;
                ClassInstance instance = (ClassInstance)currObj;
                if (instance.instance instanceof StringBuffer) {
                    theMap.put(eName, instance.instance);
                } else {
                    theMap.put(this._getOID(instance), currObj);
                }
            } else if (currObj instanceof ClassInstance && parent != currObj) {
                ClassInstance.MemberInstance member = parent;
                member.instance = currObj;
                Object discartedObj = this._objStack.pop();
                discartedObj = null;
            }
            this._printDebugInfo(eName, currObj, false);
            currObj = null;
        }

        @Override
        public void endDocument() {
            this._tagStack = null;
            this._objStack = null;
        }

        private final void _setAttributes(ClassInstance clsInst, Attributes attrs) throws SAXException {
            int i = 0;
            while (i < attrs.getLength()) {
                ClassInstance.MemberInstance attrMemberInstance = clsInst.addMember(attrs.getQName(i), clsInst.classMap.getMemberFromXMLAttribute(attrs.getQName(i)));
                attrMemberInstance.instance = attrs.getValue(i);
                ++i;
            }
        }

        private final Object _getOID(ClassInstance clsInst) throws SAXException {
            if (clsInst != null && clsInst.classMap.getOidAccessorMethodName() != null) {
                try {
                    if (!clsInst.isBuilt) {
                        clsInst.instance = ObjsFromXMLBuilder.this._buildObject(clsInst);
                    }
                    return ReflectionUtils.invokeMethod(clsInst.instance, clsInst.classMap.getOidAccessorMethodName(), new Class[0], new Object[0]);
                }
                catch (ReflectionException ex) {
                    throw new SAXException(ex);
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.out);
                }
            }
            if (clsInst != null && clsInst.members != null) {
                for (ClassInstance.MemberInstance currMember : clsInst.members.values()) {
                    if (!currMember.memberMap.isOID) continue;
                    return currMember.instance;
                }
            }
            return null;
        }

        private final void _printDebugInfo(String tagName, Object theObj, boolean open) {
            if (R01FLog.to("r01f.xoMap").getLevel() != null) {
                if (R01FLog.to("r01f.xoMap").getLevel().intValue() > Level.FINEST.intValue()) {
                    return;
                }
                if (!open) {
                    --this._tabs;
                }
                StringBuffer sb = new StringBuffer(200);
                int i = 0;
                while (i < this._tabs) {
                    sb.append("\t");
                    ++i;
                }
                sb.append("<");
                if (!open) {
                    sb.append("/");
                }
                sb.append(tagName);
                sb.append("> ");
                if (open) {
                    sb.append(" ");
                }
                sb.append(theObj.getClass().getName());
                sb.append("\r\n");
                if (open) {
                    ++this._tabs;
                }
                R01FLog.to("r01f.xoMap").fine(sb.toString());
            }
        }
    }
}

