/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.xml.marshalling;

import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.xml.marshalling.ClassMap;
import com.ejie.r01f.xml.marshalling.MemberMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

class MappingReflectionUtils {
    MappingReflectionUtils() {
    }

    static Object getObjectInstance(ClassMap newObjClassMap) throws ReflectionException {
        return ReflectionUtils.getObjectInstance(String.valueOf(newObjClassMap.packageName) + "." + newObjClassMap.name);
    }

    static Object getArrayInstance(Class arrayObjClassDef, int arrayLength) throws ReflectionException {
        return Array.newInstance(arrayObjClassDef, arrayLength);
    }

    static List getListInstance(int collectionType, int listLength) throws ReflectionException {
        String collectionObjName = null;
        switch (collectionType) {
            case 7: 
            case 8: {
                collectionObjName = "java.util.ArrayList";
                break;
            }
            case 6: {
                collectionObjName = "java.util.Vector";
                break;
            }
            default: {
                throw new ReflectionException("Error: El tipo de lista NO est\u00e1 definido");
            }
        }
        return (List)ReflectionUtils.getObjectInstance(collectionObjName, new Class[]{Integer.TYPE}, new Object[]{new Integer(listLength)}, true);
    }

    static Map getMapInstance(int collectionType, int mapLength) throws ReflectionException {
        String collectionObjName = null;
        switch (collectionType) {
            case 2: 
            case 5: {
                collectionObjName = "java.util.HashMap";
                break;
            }
            case 9: {
                collectionObjName = "java.util.LinkedHashMap";
                break;
            }
            case 1: {
                collectionObjName = "java.util.Hashtable";
                break;
            }
            case 4: {
                collectionObjName = "com.ejie.r01f.util.StateMap";
                break;
            }
            case 3: {
                collectionObjName = "com.ejie.r01f.util.XMLMap";
                break;
            }
            default: {
                throw new ReflectionException("Error: El tipo de mapa NO est\u00e1 definido");
            }
        }
        return (Map)ReflectionUtils.getObjectInstance(collectionObjName, new Class[]{Integer.TYPE}, new Object[]{new Integer(mapLength)}, true);
    }

    static void setValueIntoArray(Object targetObj, MemberMap member, Object value, int index) throws ReflectionException {
        if (targetObj == null) {
            throw new ReflectionException("El objeto que contiene la lista es nulo!!!");
        }
        if (member == null) {
            throw new ReflectionException("No se ha pasado el miembro tipo list: Null");
        }
        Object array = ReflectionUtils.getMemberValue(targetObj, member.name, member.declaringClassMap.useAccessors);
        if (array == null) {
            throw new ReflectionException("El array es nulo!!");
        }
        Array.set(array, index, value);
    }

    static boolean addValueToList(Object targetObj, MemberMap member, Object value) throws ReflectionException {
        if (targetObj == null) {
            throw new ReflectionException("El objeto que contiene la lista es nulo!!!");
        }
        if (member == null) {
            throw new ReflectionException("No se ha pasado el miembro tipo list: Null");
        }
        List lista = (List)ReflectionUtils.getMemberValue(targetObj, member.name, member.declaringClassMap.useAccessors);
        if (lista == null) {
            throw new ReflectionException("La lista es nula!!");
        }
        return lista.add(value);
    }

    static Object putValueIntoMap(Object targetObj, MemberMap member, Object key, Object value) throws ReflectionException {
        if (targetObj == null) {
            throw new ReflectionException("El objeto que contiene el mapa es nulo!!!");
        }
        if (member == null) {
            throw new ReflectionException("No se ha pasado el miembro tipo mapa: Null");
        }
        Map mapa = (Map)ReflectionUtils.getMemberValue(targetObj, member.name, member.declaringClassMap.useAccessors);
        if (mapa == null) {
            throw new ReflectionException("El mapa es nulo!!");
        }
        return mapa.put(key, value);
    }

    static void setMemberValue(Object targetObj, MemberMap member, Object value) throws ReflectionException {
        if (member.dataType == 14 || member.dataType == 15 || value instanceof ArrayList) {
            ReflectionUtils.setMemberValue(targetObj, member.name, value.getClass(), value, member.declaringClassMap.useAccessors);
        } else if (value instanceof String) {
            String valueStr = (String)value;
            Class memberClass = null;
            if (member.dataType == 1 || member.dataType == 16) {
                ReflectionUtils.setMemberValue(targetObj, member.name, String.class, valueStr, member.declaringClassMap.useAccessors);
            } else if (member.dataType == 2 || member.dataType == 3) {
                memberClass = member.dataType == 2 ? Integer.class : Integer.TYPE;
                ReflectionUtils.setMemberValue(targetObj, member.name, memberClass, new Integer(valueStr), member.declaringClassMap.useAccessors);
            } else if (member.dataType == 4 || member.dataType == 5) {
                memberClass = member.dataType == 4 ? Long.class : Long.TYPE;
                ReflectionUtils.setMemberValue(targetObj, member.name, memberClass, new Long(valueStr), member.declaringClassMap.useAccessors);
            } else if (member.dataType == 6 || member.dataType == 7) {
                memberClass = member.dataType == 6 ? Double.class : Double.TYPE;
                ReflectionUtils.setMemberValue(targetObj, member.name, memberClass, new Double(valueStr), member.declaringClassMap.useAccessors);
            } else if (member.dataType == 8 || member.dataType == 9) {
                memberClass = member.dataType == 8 ? Float.class : Float.TYPE;
                ReflectionUtils.setMemberValue(targetObj, member.name, memberClass, new Float(valueStr), member.declaringClassMap.useAccessors);
            } else if (member.dataType == 10 || member.dataType == 11) {
                Class clazz = memberClass = member.dataType == 10 ? Boolean.class : Boolean.TYPE;
                if (valueStr.equalsIgnoreCase("1") || valueStr.equalsIgnoreCase("true")) {
                    valueStr = "true";
                } else if (valueStr.equalsIgnoreCase("0") || valueStr.equalsIgnoreCase("false")) {
                    valueStr = "false";
                }
                ReflectionUtils.setMemberValue(targetObj, member.name, memberClass, new Boolean(valueStr), member.declaringClassMap.useAccessors);
            } else if (member.dataType == 12) {
                int p1 = member.dataTypeName.indexOf("(");
                int p2 = member.dataTypeName.indexOf(")");
                String format = "dd/MM/yyyy";
                if (p2 > p1 + 1) {
                    format = member.dataTypeName.substring(p1 + 1, p2 - 1);
                }
                Date date = DateUtils.getDateFromFormatedString(valueStr, format);
                ReflectionUtils.setMemberValue(targetObj, member.name, Date.class, date, member.declaringClassMap.useAccessors);
            } else if (member.dataType == 13) {
                int p1 = member.dataTypeName.trim().indexOf("(");
                int p2 = member.dataTypeName.trim().indexOf(")");
                String format = "dd/MM/yyyy";
                if (p2 > p1 + 1) {
                    format = member.dataTypeName.substring(p1 + 1, p2 - 1);
                }
                Date date = DateUtils.getDateFromFormatedString(valueStr, format);
                ReflectionUtils.setMemberValue(targetObj, member.name, java.sql.Date.class, new java.sql.Date(date.getTime()), member.declaringClassMap.useAccessors);
            }
        } else {
            throw new ReflectionException("Tipo de dato desconocido: " + member.dataType + ":" + member.dataTypeName + ">>>" + value.getClass().getName());
        }
    }
}

