/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XSSSCanner {
    private String _defaultXSSPattern = "<script|%3Cscript|&lt;script|javascript";
    private String _XSSPattern = null;
    private boolean ACTIVATE = false;
    private boolean DEBUG = true;

    public XSSSCanner() {
        try {
            this._XSSPattern = XMLProperties.get("r01f", "xssScanner/regexp");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this._XSSPattern == null) {
            this._XSSPattern = this._defaultXSSPattern;
        }
        try {
            this.ACTIVATE = new Boolean(XMLProperties.get("r01f", "xssScanner/activate"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.DEBUG = new Boolean(XMLProperties.get("r01f", "xssScanner/debug"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scanRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.ACTIVATE) {
            for (String paramName : request.getParameterMap().keySet()) {
                String paramValue = request.getParameter(paramName);
                if (this.DEBUG) {
                    R01FLog.to("r01f.xssScanner").info("Escaneando par\u00e1metro :" + paramName);
                }
                if (this.hasAnyXSS(paramValue)) {
                    if (this.DEBUG) {
                        R01FLog.to("r01f.xssScanner").warning(">>>>>>>>>>>> ENCONTRADO PATR\u00d3N xss en el Par\u00e1metro :" + paramName + "==>" + paramValue);
                    }
                    response.sendError(403, "XSS Pattern Found");
                    continue;
                }
                if (!this.DEBUG) continue;
                R01FLog.to("r01f.xssScanner").info("..OK");
            }
        }
    }

    public boolean hasAnyXSS(String value) {
        String valueLowerCase = value.toLowerCase();
        Pattern theXSSPattern = Pattern.compile(this._XSSPattern);
        Matcher matcher = theXSSPattern.matcher(valueLowerCase);
        return matcher.find();
    }

    public static void main(String[] argv) {
        XSSSCanner scanner = new XSSSCanner();
        String prueba = "<xml><script/>";
        System.out.println(scanner.hasAnyXSS(prueba));
    }
}

