/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public class URLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    static {
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }

    private URLEncoder() {
    }

    public static String encode(String s) {
        String str = null;
        try {
            str = URLEncoder.encode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, enc);
        int i = 0;
        while (i < s.length()) {
            block11: {
                int c = s.charAt(i);
                if (dontNeedEncoding.get(c)) {
                    if (c == 32) {
                        c = 43;
                        needToChange = true;
                    }
                    out.append((char)c);
                    wroteUnencodedChar = true;
                } else {
                    try {
                        char d;
                        if (wroteUnencodedChar) {
                            writer = new OutputStreamWriter((OutputStream)buf, enc);
                            wroteUnencodedChar = false;
                        }
                        writer.write(c);
                        if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                            writer.write(d);
                            ++i;
                        }
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block11;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                    needToChange = true;
                }
            }
            ++i;
        }
        return needToChange ? out.toString() : s;
    }

    public static String encodeNoSpaces(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, enc);
        int i = 0;
        while (i < s.length()) {
            block10: {
                char c = s.charAt(i);
                if (dontNeedEncoding.get(c)) {
                    out.append(c);
                    wroteUnencodedChar = true;
                } else {
                    try {
                        char d;
                        if (wroteUnencodedChar) {
                            writer = new OutputStreamWriter((OutputStream)buf, enc);
                            wroteUnencodedChar = false;
                        }
                        writer.write(c);
                        if (c >= '\ud800' && c <= '\udbff' && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                            writer.write(d);
                            ++i;
                        }
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block10;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        out.append('%');
                        char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ch = Character.forDigit(ba[j] & 0xF, 16);
                        if (Character.isLetter(ch)) {
                            ch = (char)(ch - 32);
                        }
                        out.append(ch);
                        ++j;
                    }
                    buf.reset();
                    needToChange = true;
                }
            }
            ++i;
        }
        return needToChange ? out.toString() : s;
    }
}

