/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.io.filters.DirectiveFilterReader;
import com.ejie.r01f.io.filters.DirectiveListener;
import com.ejie.r01f.log.R01FLog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextCustomizer {
    private static final int BUFFER_SIZE = 0x100000;
    private static final transient String VARIABLE_BEGIN = "$[";
    private static final transient String VARIABLE_END = "]$";
    private static final transient String IF_BEGIN = "<!--#if";
    private static final transient String IF_END = "#endif-->";
    private transient String _varBegin = "$[";
    private transient String _varEnd = "]$";
    private transient String _ifBegin = "<!--#if";
    private transient String _ifEnd = "#endif-->";
    private transient boolean _keepNotMatchingIfs = false;

    public TextCustomizer() {
    }

    public TextCustomizer(boolean keepNotMatchingIfs) {
        this();
        this._keepNotMatchingIfs = keepNotMatchingIfs;
    }

    public TextCustomizer(String varBegin, String varEnd, String ifBegin, String ifEnd, boolean keepNotMatchingIfs) {
        this._varBegin = varBegin;
        this._varEnd = varEnd;
        this._ifBegin = ifBegin;
        this._ifEnd = ifEnd;
        this._keepNotMatchingIfs = keepNotMatchingIfs;
    }

    public boolean isKeepNotMatchingIfs() {
        return this._keepNotMatchingIfs;
    }

    public void setKeepNotMatchingIfs(boolean keepNotMatchingIfs) {
        this._keepNotMatchingIfs = keepNotMatchingIfs;
    }

    public String customize(Reader textReader, Properties vars) throws IOException {
        String propertiesCustomized = this._doCustomizeText(textReader, vars);
        return this._doProcessConditionalProperties(new StringReader(propertiesCustomized), vars);
    }

    public String composeVarsDebugInfo(Properties vars) {
        StringBuffer varsDebug = new StringBuffer();
        if (vars != null) {
            Iterator<Map.Entry<Object, Object>> it = vars.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> me = it.next();
                String varName = (String)me.getKey();
                String varValue = ((String)me.getValue()).trim();
                varValue = varValue.replace('\r', ' ');
                varValue = varValue.replace('\n', ' ');
                varsDebug.append("\t-" + varName + "=" + varValue);
                if (!it.hasNext()) continue;
                varsDebug.append("\r\n");
            }
        }
        return varsDebug.toString();
    }

    private String _doCustomizeText(Reader r, Properties vars) throws IOException {
        if (r == null) {
            throw new IOException("El reader es null: No se puede customizar el fichero de propiedades!");
        }
        StringWriter w = new StringWriter();
        VariablesDirectiveListener directiveListener = new VariablesDirectiveListener(vars);
        DirectiveFilterReader directiveFilterReader = new DirectiveFilterReader(r, 0x100000);
        directiveFilterReader.addListener(directiveListener, this._varBegin, this._varEnd);
        int c = 0;
        do {
            if ((c = directiveFilterReader.read()) <= 0) continue;
            ((Writer)w).write(c);
        } while (c > 0);
        directiveFilterReader.close();
        return ((Object)w).toString();
    }

    private String _doProcessConditionalProperties(Reader r, Properties vars) throws IOException {
        if (r == null) {
            throw new IOException("El reader es null: No se puede customizar el fichero de propiedades!");
        }
        StringWriter w = new StringWriter();
        IFDirectiveListener directiveListener = new IFDirectiveListener(vars, this._keepNotMatchingIfs);
        DirectiveFilterReader directiveFilterReader = new DirectiveFilterReader(r, 0x100000);
        directiveFilterReader.addListener(directiveListener, this._ifBegin, this._ifEnd);
        int c = 0;
        do {
            if ((c = directiveFilterReader.read()) <= 0) continue;
            ((Writer)w).write(c);
        } while (c > 0);
        directiveFilterReader.close();
        return ((Object)w).toString();
    }

    public static void main(String[] args) {
        try {
            TextCustomizer customizer = new TextCustomizer();
            String text = "<properties>\r\n    <!--#if{$var1$=='var1Value'}\r\n    <miPropiedad>$[var1]$</miPropiedad>\r\n    #endif-->\r\n    <miPropiedad2 attr='$[var3]$'>\r\n        <value>Esto es va1=$[var1]$' (sustituido)</value>\r\n    </miPropiedad2>\r\n    <miXML>\r\n        $[varXML]$\r\n    </miXML>\r\n</properties>";
            Properties vars = new Properties();
            vars.setProperty("var1", "var1Value");
            vars.setProperty("var2", "var2Value");
            vars.setProperty("varXML", "<hola>\r\n\t<adios>by</adios>\r\n</hola>\r\n");
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            int times = 0;
            while (times < testTimes) {
                Properties vs = new Properties();
                vs.setProperty("var1Value", "hola");
                vs.setProperty("var2Value", "adios");
                vs.setProperty("var3Value", "hola caracola");
                R01FLog.to("r01f.test").fine("Variables: \r\n" + customizer.composeVarsDebugInfo(vs));
                R01FLog.to("r01f.test").fine(customizer.customize(new StringReader(text), vars));
                R01FLog.to("r01f.test").fine("\r\n\r\n\r\n\r\n--------------------------------------------------------------");
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class IFDirectiveListener
    implements DirectiveListener {
        private transient Properties _vars;
        private transient boolean _returnNotMatchingIfs = true;
        private transient String regExp;

        public IFDirectiveListener() {
            this.regExp = String.valueOf(TextCustomizer.this._ifBegin) + "\\{\\$([^]]*)\\$(==|!=)'([^']*)'\\}(.*)" + TextCustomizer.this._ifEnd;
        }

        public IFDirectiveListener(Properties vars, boolean returnNotMatchingIfs) {
            this.regExp = String.valueOf(TextCustomizer.this._ifBegin) + "\\{\\$([^]]*)\\$(==|!=)'([^']*)'\\}(.*)" + TextCustomizer.this._ifEnd;
            this._vars = vars;
            this._returnNotMatchingIfs = returnNotMatchingIfs;
        }

        @Override
        public char[] processDirective(String directiveText, long index) throws IOException {
            Pattern p;
            Matcher m;
            if (this._vars != null && directiveText.length() > TextCustomizer.this._varBegin.length() + TextCustomizer.this._varEnd.length() && (m = (p = Pattern.compile(this.regExp, 32)).matcher(directiveText)).matches()) {
                String varName = m.group(1);
                String operator = m.group(2);
                String varValue1 = m.group(3);
                String varValue2 = this._vars.getProperty(varName);
                String property = m.group(4);
                if (varValue1 != null && varValue2 != null) {
                    boolean conditionOK = false;
                    StringTokenizer st = new StringTokenizer(varValue1, "|");
                    do {
                        String currVar = st.nextToken();
                        if ((!"==".equals(operator) || !currVar.equals(varValue2)) && (!"!=".equals(operator) || currVar.equals(varValue2))) continue;
                        conditionOK = true;
                        break;
                    } while (st.hasMoreTokens());
                    if (conditionOK) {
                        return property.toCharArray();
                    }
                }
                R01FLog.global.finest("La directiva IF " + directiveText + " NO cumple la condicion " + varName + "=" + varValue1 + ": (valor real " + varName + "=" + varValue2 + ")");
                if (this._returnNotMatchingIfs) {
                    return directiveText.toCharArray();
                }
                return "".toCharArray();
            }
            R01FLog.global.warning("NO se han computado las condiciones IF de la directiva " + directiveText + " ya que:\r\n\t1.- No se han pasado variables\r\n\t2.- La directiva if esta mal formada (debe ser <!--#if{$varName$=='varValue'}Propiedad#endif-->)");
            if (this._returnNotMatchingIfs) {
                return directiveText.toCharArray();
            }
            return "".toCharArray();
        }
    }

    class VariablesDirectiveListener
    implements DirectiveListener {
        private transient Properties _vars;

        public VariablesDirectiveListener() {
        }

        public VariablesDirectiveListener(Properties vars) {
            this._vars = vars;
        }

        @Override
        public char[] processDirective(String directiveText, long index) throws IOException {
            String varName;
            String varValue;
            if (this._vars != null && directiveText.length() > TextCustomizer.this._varBegin.length() + TextCustomizer.this._varEnd.length() && (varValue = this._vars.getProperty(varName = directiveText.substring(TextCustomizer.this._varBegin.length(), directiveText.length() - TextCustomizer.this._varEnd.length()))) != null) {
                return varValue.toCharArray();
            }
            R01FLog.global.warning("NO se ha computado la directiva " + directiveText + " ya que:\r\n\t1.- No se han pasado variables\r\n\t2.- No se ha pasado valor para la variable");
            return directiveText.toCharArray();
        }
    }
}

