/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.file.ResourcesLoader;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    public static void windows1252ToIso8859(StringBuffer sbOriginal) {
        if (sbOriginal == null) {
            return;
        }
        int isb = 0;
        while (isb < sbOriginal.length()) {
            char origCharAsInt = sbOriginal.charAt(isb);
            switch (origCharAsInt) {
                case '\u2018': {
                    sbOriginal.setCharAt(isb, '\'');
                    break;
                }
                case '\u2019': {
                    sbOriginal.setCharAt(isb, '\'');
                    break;
                }
                case '\u201a': {
                    sbOriginal.setCharAt(isb, '\'');
                    break;
                }
                case '\u201c': {
                    sbOriginal.setCharAt(isb, '\"');
                    break;
                }
                case '\u201d': {
                    sbOriginal.setCharAt(isb, '\"');
                    break;
                }
                case '\u201e': {
                    sbOriginal.setCharAt(isb, '\"');
                    break;
                }
                case '\u2039': {
                    sbOriginal.setCharAt(isb, '\'');
                    break;
                }
                case '\u203a': {
                    sbOriginal.setCharAt(isb, '\'');
                    break;
                }
                case '\u02dc': {
                    sbOriginal.setCharAt(isb, '~');
                    break;
                }
                case '\u2013': {
                    sbOriginal.setCharAt(isb, '-');
                    break;
                }
                case '\u2014': {
                    sbOriginal.setCharAt(isb, '-');
                    break;
                }
                case '\u0178': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u017e': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u0153': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u0161': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u2122': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u2022': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u017d': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u0152': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u0160': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u2030': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u02c6': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u2021': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u2020': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u2026': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u0192': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
                case '\u20ac': {
                    sbOriginal.deleteCharAt(isb);
                    break;
                }
            }
            ++isb;
        }
    }

    public static String windows1252ToIso8859(String strOriginal) {
        if (strOriginal == null) {
            return null;
        }
        StringBuffer sbOrig = new StringBuffer(strOriginal);
        StringUtils.windows1252ToIso8859(sbOrig);
        return sbOrig.toString();
    }

    public static String encodeUTF(String str) {
        StringBuffer outResp = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char code = str.charAt(i);
            if (code == '\t' || code == '\n' || code == '\r' || code >= ' ' && code <= '\ud7ff' || code >= '\ue000' && code <= '\ufffd' || code >= '\u10000' && code <= '\u10ffff') {
                if (code >= '\u007f') {
                    outResp.append("&#");
                    outResp.append((int)code);
                    outResp.append(";");
                } else {
                    outResp.append(str.charAt(i));
                }
            }
            ++i;
        }
        return outResp.toString();
    }

    public static String encodeQuoteUTF(String str) {
        StringBuffer outResp = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char code = str.charAt(i);
            if (code == '\t' || code == '\n' || code == '\r' || code >= ' ' && code <= '\ud7ff' || code >= '\ue000' && code <= '\ufffd' || code >= '\u10000' && code <= '\u10ffff') {
                if (code > '\u007f' || code == '\"' || code == '\'') {
                    outResp.append("&#");
                    outResp.append((int)code);
                    outResp.append(";");
                } else {
                    outResp.append(str.charAt(i));
                }
            }
            ++i;
        }
        return outResp.toString();
    }

    public static String encodeXMLEntities(String xml) {
        StringBuffer xmlResp = new StringBuffer();
        int i = 0;
        while (i < xml.length()) {
            char code = xml.charAt(i);
            switch (code) {
                case '\"': {
                    xmlResp.append("&quot;");
                    break;
                }
                case '&': {
                    xmlResp.append("&amp;");
                    break;
                }
                case '\'': {
                    xmlResp.append("&apos;");
                    break;
                }
                case '<': {
                    xmlResp.append("&lt;");
                    break;
                }
                case '>': {
                    xmlResp.append("&gt;");
                    break;
                }
                default: {
                    xmlResp.append(xml.charAt(i));
                }
            }
            ++i;
        }
        return xmlResp.toString();
    }

    public static String decodeUTF(String encodedStr) {
        if (encodedStr == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String regExp = "&#(([0-9]{1,7})|(x[0-9a-f]{1,6}));?";
        Pattern p = Pattern.compile(regExp, 2);
        Matcher m = p.matcher(encodedStr);
        boolean found = m.find();
        if (found) {
            do {
                String numericValue = m.group(1);
                char c = '\u0000';
                c = numericValue.startsWith("x") || numericValue.startsWith("X") ? (char)Integer.parseInt(numericValue, 16) : (char)Integer.parseInt(numericValue);
                m.appendReplacement(result, Character.toString(c));
            } while (found = m.find());
            m.appendTail(result);
            return result.toString();
        }
        return encodedStr;
    }

    public static String decodeXMLEntities(String encodedStr) {
        if (encodedStr == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String regExp = "(&(quot|amp|apos|lt|gt);)";
        Pattern p = Pattern.compile(regExp, 2);
        Matcher m = p.matcher(encodedStr);
        boolean found = m.find();
        if (found) {
            do {
                String encodedValue = m.group(1);
                String decodedValue = "";
                if ("&quot;".equals(encodedValue)) {
                    decodedValue = "\"";
                } else if ("&amp;".equals(encodedValue)) {
                    decodedValue = "&";
                } else if ("&apos;".equals(encodedValue)) {
                    decodedValue = "'";
                } else if ("&lt;".equals(encodedValue)) {
                    decodedValue = "<";
                } else if ("&gt;".equals(encodedValue)) {
                    decodedValue = ">";
                }
                m.appendReplacement(result, decodedValue);
            } while (found = m.find());
            m.appendTail(result);
            return result.toString();
        }
        return encodedStr;
    }

    public static int getNumberOfTokens(String inStr, String sep) {
        if (inStr == null || sep == null) {
            return -1;
        }
        return inStr.split(sep).length;
    }

    public static String getToken(String inStr, String sep, int pos) {
        if (inStr == null || sep == null) {
            return null;
        }
        String[] inStrSplitted = inStr.split(sep);
        if (inStrSplitted != null && inStrSplitted.length > 0 && inStrSplitted.length < pos) {
            return inStrSplitted[pos];
        }
        return null;
    }

    public static String replaceString(String inStr, String replacedStr, String replacingStr) {
        StringBuffer outBuff = new StringBuffer("");
        int p1 = 0;
        int p2 = 0;
        boolean substitution = false;
        do {
            substitution = false;
            p2 = inStr.indexOf(replacedStr, p1);
            if (p2 < p1) continue;
            if (p2 > p1) {
                outBuff.append(inStr.substring(p1, p2));
            }
            outBuff.append(replacingStr);
            p1 = p2 + replacedStr.length();
            substitution = true;
        } while (substitution);
        if (p1 < inStr.length()) {
            outBuff.append(inStr.substring(p1));
        }
        return outBuff.toString();
    }

    public static void replaceAll(StringBuffer buffer, String replacedStr, String replacingStr) {
        int start = 0;
        while ((start = buffer.indexOf(replacedStr, start)) != -1) {
            int end = start + replacedStr.length();
            buffer.replace(start, end, replacingStr);
        }
    }

    public static String replaceVariableValues(String inStr, String varDelim, Map varValues) {
        return StringUtils.replaceVariableValues(inStr, varDelim.charAt(0), varValues, false);
    }

    public static String replaceVariableValues(String inStr, char varDelim, Map varValues) {
        return StringUtils.replaceVariableValues(inStr, varDelim, varValues, false);
    }

    public static String replaceVariableValues(String inStr, String varDelim, Map varValues, boolean deep) {
        return StringUtils.replaceVariableValues(inStr, varDelim.charAt(0), varValues, deep);
    }

    public static String replaceVariableValues(String inStr, char varDelim, Map varValues, boolean deep) {
        String delim = "" + varDelim;
        char[] charsToEscape = new char[]{'.', '?', '*', '+', '^', '$'};
        int i = 0;
        while (i < charsToEscape.length) {
            if (charsToEscape[i] == varDelim) {
                delim = "\\" + charsToEscape[i];
                break;
            }
            ++i;
        }
        String outString = inStr;
        if (varValues != null) {
            for (Map.Entry me : varValues.entrySet()) {
                String currStrToReplace = String.valueOf(delim) + (String)me.getKey() + delim;
                String currVarValue = (String)me.getValue();
                if (currVarValue == null) continue;
                if (deep && currVarValue.indexOf(varDelim) >= 0) {
                    currVarValue = StringUtils.replaceVariableValues(currVarValue, varDelim, varValues, false);
                }
                if (currVarValue.indexOf("$") >= 0) {
                    currVarValue = currVarValue.replaceAll("\\$", "\\\\\\$");
                }
                outString = outString.replaceAll(currStrToReplace, currVarValue);
            }
        }
        return outString;
    }

    public static String replaceVariableValuesUsingReflection(String inStr, String varDelim, Object obj, Map varPaths) throws ReflectionException {
        StringBuffer outBuff = new StringBuffer("");
        int p1 = 0;
        int v1 = -1;
        int v2 = -1;
        String varName = null;
        String varPath = null;
        String varValue = null;
        boolean substitution = false;
        do {
            substitution = false;
            v1 = inStr.indexOf(varDelim, p1);
            if (v1 >= 0) {
                v2 = inStr.indexOf(varDelim, v1 + 1);
            }
            if (v2 <= v1) continue;
            outBuff.append(inStr.substring(p1, v1));
            varName = inStr.substring(v1 + 1, v2);
            if (varName.length() > 0) {
                varPath = (String)varPaths.get(varName);
                if (varPath == null) {
                    outBuff.append("null");
                } else {
                    varValue = (String)ReflectionUtils.getMemberValueUsingPath(obj, varPath, false);
                    outBuff.append(varValue);
                }
            } else if (varName.length() == 0) {
                outBuff.append(varDelim);
                outBuff.append(varDelim);
            }
            p1 = v2 + 1;
            v1 = -1;
            v2 = -1;
            substitution = true;
        } while (substitution);
        if (p1 < inStr.length()) {
            outBuff.append(inStr.substring(p1));
        }
        return outBuff.toString();
    }

    public static String filterChars(String strToBeFiltered, char[] charsToFilter, String[] charsFiltered) {
        if (strToBeFiltered == null) {
            return null;
        }
        char[] content = new char[strToBeFiltered.length()];
        strToBeFiltered.getChars(0, strToBeFiltered.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        int i = 0;
        while (i < content.length) {
            boolean replaced = false;
            int j = 0;
            while (j < charsToFilter.length) {
                if (content[i] == charsToFilter[j]) {
                    result.append(charsFiltered[j]);
                    replaced = true;
                }
                ++j;
            }
            if (!replaced) {
                result.append(content[i]);
            }
            ++i;
        }
        return result.toString();
    }

    public static String filterInvalidXMLCharacters(String str) {
        StringBuffer outResp = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char code = str.charAt(i);
            if (code == '\t' || code == '\n' || code == '\r' || code == '\u20ac' || code >= ' ' && code <= '\u00fc') {
                outResp.append(str.charAt(i));
            }
            ++i;
        }
        return outResp.toString();
    }

    public static String capitalizeAllFirstLetters(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        str = str.toLowerCase();
        String[] strTitleCase = str.split(" ");
        int index = 0;
        while (index < strTitleCase.length) {
            if (index != 0) {
                sb.append(" ");
            }
            sb.append(StringUtils.capitalizeFirstLetter(strTitleCase[index].trim()));
            ++index;
        }
        return sb.toString();
    }

    public static String capitalizeFirstLetter(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        char[] content = new char[str.length()];
        str.getChars(0, str.length(), content, 0);
        content[0] = Character.toUpperCase(content[0]);
        return new String(content);
    }

    public static final void trimBuffer(StringBuffer buffer) {
        if (buffer != null) {
            String bufferContent = buffer.toString().trim();
            buffer.setLength(0);
            buffer.append(bufferContent);
        }
    }

    public static String rPadWithChar(String str, char character, int length) {
        if (str == null) {
            return new String(StringUtils.getCharArray(character, length));
        }
        if (str.length() >= length) {
            return str;
        }
        char[] outArray = new char[length];
        int i = 0;
        while (i < str.length()) {
            outArray[i] = str.charAt(i);
            ++i;
        }
        while (i < length) {
            outArray[i] = character;
            ++i;
        }
        return new String(outArray);
    }

    public static String lPadWithChar(String str, char character, int length) {
        if (str == null) {
            return new String(StringUtils.getCharArray(character, length));
        }
        if (str.length() >= length) {
            return str;
        }
        char[] outArray = new char[length];
        int i = 0;
        while (i < length - str.length()) {
            outArray[i] = character;
            ++i;
        }
        int j = 0;
        while (j < str.length()) {
            outArray[i++] = str.charAt(j);
            ++j;
        }
        return new String(outArray);
    }

    public static char[] getCharArray(char character, int length) {
        if (length == 0) {
            return null;
        }
        char[] outArray = new char[length];
        int i = 0;
        while (i < length) {
            outArray[i] = character;
            ++i;
        }
        return outArray;
    }

    public static String loadFromFile(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringBuffer sb = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            line = reader.readLine();
        }
        reader.close();
        return sb.toString();
    }

    public static StringBuffer loadBufferFromFile(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringBuffer sb = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            line = reader.readLine();
        }
        reader.close();
        return sb;
    }

    public static String loadFromFileRaw(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            sb.append(buf, 0, numRead);
        }
        reader.close();
        return sb.toString();
    }

    public static String loadFromFile(String filePath) throws IOException {
        return StringUtils.loadFromFile(new File(filePath));
    }

    public static String loadFromFile(String filePath, String encoding) throws IOException {
        String srcString = StringUtils.loadFromFile(filePath);
        return new String(srcString.getBytes(), encoding);
    }

    public static String loadFromFile(File f, String encoding) throws IOException {
        String srcString = StringUtils.loadFromFile(f);
        return new String(srcString.getBytes(), encoding);
    }

    public static String loadFromStream(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        InputStreamReader r = new InputStreamReader(is);
        return StringUtils.loadFromReader(r);
    }

    public static StringBuffer loadBufferFromStream(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        InputStreamReader r = new InputStreamReader(is);
        return StringUtils.loadBufferFromReader(r);
    }

    public static String loadFromStream(InputStream is, String encoding) throws IOException {
        String srcString = StringUtils.loadFromStream(is);
        return new String(srcString.getBytes(), encoding);
    }

    public static String loadFromReader(Reader r) throws IOException {
        StringBuffer outString = new StringBuffer();
        if (r != null) {
            char[] buf = new char[2048];
            int charsReaded = -1;
            do {
                if ((charsReaded = r.read(buf)) == -1) continue;
                outString.append(new String(buf, 0, charsReaded));
            } while (charsReaded != -1);
            return outString.toString();
        }
        return null;
    }

    public static StringBuffer loadBufferFromReader(Reader r) throws IOException {
        StringBuffer outString = new StringBuffer();
        if (r != null) {
            char[] buf = new char[2048];
            int charsReaded = -1;
            do {
                if ((charsReaded = r.read(buf)) == -1) continue;
                outString.append(new String(buf, 0, charsReaded));
            } while (charsReaded != -1);
            return outString;
        }
        return null;
    }

    public static String loadFromReader(Reader r, String encoding) throws IOException {
        String srcString = StringUtils.loadFromReader(r);
        return new String(srcString.getBytes(), encoding);
    }

    public static String[][] loadColumnsFromFile(String filePath, char delim) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(ResourcesLoader.getResourceFileAsFile(filePath)));
        ArrayList<String[]> lines = new ArrayList<String[]>();
        String line = reader.readLine();
        while (line != null) {
            StringTokenizer st = new StringTokenizer(line, "" + delim);
            String[] chunkedLine = new String[st.countTokens()];
            int i = st.countTokens() - 1;
            while (i >= 0) {
                chunkedLine[chunkedLine.length - i - 1] = st.nextToken();
                --i;
            }
            lines.add(chunkedLine);
            line = reader.readLine();
        }
        reader.close();
        if (!lines.isEmpty()) {
            String[][] outArray = new String[lines.size()][];
            int i = 0;
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                outArray[i] = (String[])it.next();
                ++i;
            }
            return outArray;
        }
        return null;
    }

    public static void saveToFile(String filePath, String theString) throws IOException {
        StringUtils.saveToFile(new File(filePath), theString);
    }

    public static void saveToFile(File f, String theString) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(theString));
        BufferedWriter writer = new BufferedWriter(new FileWriter(f, false));
        String line = reader.readLine();
        while (line != null) {
            writer.write(String.valueOf(line) + "\r\n");
            line = reader.readLine();
        }
        reader.close();
        writer.flush();
        writer.close();
    }

    public static void saveBufferToFile(String filePath, StringBuffer theString) throws IOException {
        StringUtils.saveToFile(new File(filePath), theString.toString());
    }

    public static String printArrayStrings(String[] input) {
        StringBuffer result = new StringBuffer();
        result.append('[');
        int i = 0;
        while (i < input.length) {
            result.append('[');
            result.append(input[i]);
            result.append(']');
            if (i < input.length - 1) {
                result.append(',');
            }
            ++i;
        }
        result.append(']');
        return result.toString();
    }

    public static StringBuffer printArrayStrings(String[][] input) {
        StringBuffer resultSB = new StringBuffer();
        resultSB.append('[');
        int i = 0;
        while (i < input.length) {
            resultSB.append("[[");
            resultSB.append(input[i][0]);
            resultSB.append("][");
            resultSB.append(input[i][1]);
            resultSB.append("]]");
            if (i < input.length - 1) {
                resultSB.append(',');
            }
            ++i;
        }
        resultSB.append(']');
        return resultSB;
    }

    public static boolean isEmptyString(String literal) {
        if (literal == null) {
            return true;
        }
        boolean isEmpty = true;
        int i = 0;
        while (i < literal.length()) {
            if (!Character.isWhitespace(literal.charAt(i))) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        return isEmpty;
    }

    public static boolean isEmptyStringBuffer(StringBuffer sb) {
        if (sb == null) {
            return true;
        }
        boolean isEmpty = true;
        int i = 0;
        while (i < sb.length()) {
            if (!Character.isWhitespace(sb.charAt(i))) {
                isEmpty = false;
                break;
            }
            ++i;
        }
        return isEmpty;
    }

    public static List sortList(List unorderedList) {
        return StringUtils.sortListLocale(unorderedList, "es");
    }

    public static List sortListLocale(List unorderedList, String langLocale) {
        List orderedList = unorderedList;
        if (orderedList != null && !orderedList.isEmpty()) {
            Collator esCollator = Collator.getInstance(new Locale(langLocale));
            Collections.sort(orderedList, esCollator);
        }
        return orderedList;
    }

    public static String mapObjectsToString(Map theMap) {
        StringBuffer outMap = null;
        if (theMap != null) {
            outMap = new StringBuffer(theMap.size() * 20);
            Iterator itObjects = theMap.entrySet().iterator();
            while (itObjects.hasNext()) {
                Map.Entry me = itObjects.next();
                outMap.append('(');
                outMap.append(me.getValue().toString());
                outMap.append(')');
                if (!itObjects.hasNext()) continue;
                outMap.append(',');
            }
        }
        return outMap != null ? outMap.toString() : null;
    }

    public static String serializeObjToString(Object memberValue) {
        String outMemberValueStr = null;
        if (memberValue != null && ReflectionUtils.isMap(memberValue.getClass())) {
            outMemberValueStr = "";
            Map theMap = (Map)memberValue;
            Map.Entry me = null;
            Iterator mIt = theMap.entrySet().iterator();
            while (mIt.hasNext()) {
                me = mIt.next();
                outMemberValueStr = String.valueOf(outMemberValueStr) + "(" + (String)me.getKey() + ";" + (String)me.getValue() + ")" + (mIt.hasNext() ? "," : "");
            }
        }
        return outMemberValueStr;
    }

    public static String mapToString(Map theMap) {
        StringBuffer outMap = null;
        if (theMap != null) {
            outMap = new StringBuffer(theMap.size() * 20);
            outMap.append(StringUtils.serializeToString(theMap));
        }
        return outMap != null ? outMap.toString() : null;
    }

    public static String serializeToString(Object memberValue) {
        String outMemberValueStr = null;
        if (memberValue != null && ReflectionUtils.isMap(memberValue.getClass())) {
            outMemberValueStr = "";
            Map theMap = (Map)memberValue;
            if (theMap.entrySet() != null && !theMap.entrySet().isEmpty()) {
                Map.Entry me = null;
                Iterator mIt = theMap.entrySet().iterator();
                while (mIt.hasNext()) {
                    me = mIt.next();
                    outMemberValueStr = String.valueOf(outMemberValueStr) + "(" + (me.getKey() == null ? "[null]" : (String)me.getKey()) + ";" + (me.getValue() == null ? "[null]" : (String)me.getValue()) + ")" + (mIt.hasNext() ? "," : "");
                }
            }
        }
        return outMemberValueStr;
    }

    public static final InputStream getInputStream(StringBuffer cadena) throws UnsupportedEncodingException {
        return StringUtils.getInputStream(cadena.toString());
    }

    public static final InputStream getInputStream(String cadena) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(cadena.getBytes("UTF-8"));
    }

    public static String fillRight(String cadena, int length, String value) {
        while (cadena.length() < length) {
            cadena = String.valueOf(cadena) + value;
        }
        return cadena;
    }

    public static String fillLeft(String cadena, int length, String value) {
        while (cadena.length() < length) {
            cadena = String.valueOf(value) + cadena;
        }
        return cadena;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int times = 0;
            while (times < 1) {
                HashMap<String, String> varValues = new HashMap<String, String>(4);
                varValues.put("METADATA_TABLE", "TABLE");
                varValues.put("METADATAFIELD", "TRANSLATE(UPPER($METADATA_TABLE$.$METADATACOLNAME$),'\u00c1\u00c9\u00cd\u00d3\u00da','AEIOU')");
                varValues.put("OPERATOR", "LIKE");
                varValues.put("METADATAVALUE", "TRANSLATE($METADATAVALUE$,'\u00c1\u00c9\u00cd\u00d3\u00da','AEIOU')");
                R01FLog.to("r01f.test").fine(">>>>>" + StringUtils.replaceVariableValues("$METADATAFIELD$ $OPERATOR$ $METADATAVALUE$", '$', varValues, true));
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

