/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class StringMap
implements Map,
Serializable {
    private static final long serialVersionUID = -8678044381869943145L;
    String[][] _arrayInstance;
    int _insertPosition = 0;
    private static final int ITERATOR_KEYS = 0;
    private static final int ITERATOR_VALUES = 1;
    private static final int ITERATOR_ENTRIES = 2;

    public StringMap() {
    }

    public StringMap(int dim1) {
        this();
        this._arrayInstance = new String[dim1][2];
    }

    public StringMap(String[][] otherArray) {
        this();
        if (otherArray == null) {
            this._arrayInstance = null;
        } else {
            int i = 0;
            while (i < otherArray.length) {
                if (otherArray[i].length != 2) {
                    throw new IllegalArgumentException("Todos los elementos del StringMap han de tener un tama\u00f1o de 2 (codigo y valor): No se puede construir un StringMap a partir de un array bidimensional alguno de cuyos elementos tenga un tama\u00f1o distinto de 2");
                }
                ++i;
            }
            this._arrayInstance = otherArray;
            this._insertPosition = this._arrayInstance.length;
        }
    }

    @Override
    public void clear() {
        this._insertPosition = 0;
        this._arrayInstance = null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this._arrayInstance == null) {
            return false;
        }
        int i = 0;
        while (i < this._arrayInstance.length) {
            if (this._arrayInstance[i][0].equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this._arrayInstance == null) {
            return false;
        }
        int i = 0;
        while (i < this._arrayInstance.length) {
            if (this._arrayInstance[i][1].equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Collection values() {
        if (this._arrayInstance == null) {
            return null;
        }
        ArrayList<String> outValues = new ArrayList<String>(this.size());
        int i = 0;
        while (i < this._arrayInstance.length) {
            outValues.add(this._arrayInstance[i][1]);
            ++i;
        }
        return outValues;
    }

    public Set entrySet() {
        AbstractSet entrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StringMapIterator(2);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StringMap.this.get(me.getKey()) != null;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StringMap.this.remove(me.getKey()) != null;
            }

            @Override
            public int size() {
                return StringMap.this.size();
            }

            @Override
            public void clear() {
                StringMap.this.clear();
            }
        };
        return entrySet;
    }

    public Set keySet() {
        AbstractSet keySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StringMapIterator(0);
            }

            @Override
            public int size() {
                return StringMap.this.size();
            }

            @Override
            public boolean contains(Object inKey) {
                return StringMap.this.containsKey(inKey);
            }

            @Override
            public boolean remove(Object inKey) {
                return StringMap.this.remove(inKey) != null;
            }

            @Override
            public void clear() {
                StringMap.this.clear();
            }
        };
        return keySet;
    }

    public Object get(Object key) {
        if (this._arrayInstance == null) {
            return null;
        }
        int i = 0;
        while (i < this._arrayInstance.length) {
            if (this._arrayInstance[i][0].equals(key)) {
                return this._arrayInstance[i][1];
            }
            ++i;
        }
        return key;
    }

    public Object put(Object key, Object value) {
        if (this._arrayInstance == null) {
            throw new IllegalStateException("No se puede insertar un elemento en el mapa ya que este no ha sido inicializado!");
        }
        if (this._insertPosition == this._arrayInstance.length) {
            throw new IllegalStateException("No se puede insertar el elemento ya que se ha llenado el mapa a su maxima capacidad: " + this._arrayInstance.length);
        }
        this._arrayInstance[this._insertPosition][0] = (String)key;
        this._arrayInstance[this._insertPosition][1] = (String)value;
        ++this._insertPosition;
        return value;
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        Map.Entry me2 = null;
        for (Map.Entry me2 : t.entrySet()) {
            this.put(me2.getKey(), me2.getValue());
        }
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("No se pueden eliminar elementos del mapa!!");
    }

    @Override
    public int size() {
        return this._arrayInstance.length;
    }

    @Override
    public boolean isEmpty() {
        return this._arrayInstance == null || this._arrayInstance.length == 0;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int i = 0;
            while (i < 1) {
                int numElements = 5;
                String[][] theArray = new String[numElements][2];
                int j = 0;
                while (j < numElements) {
                    theArray[j] = new String[]{Integer.toString(j), "texto-" + Integer.toString(j)};
                    ++j;
                }
                StringMap map = new StringMap(theArray);
                Iterator arrayIterator = map.entrySet().iterator();
                Map.Entry me = null;
                while (arrayIterator != null && arrayIterator.hasNext()) {
                    me = (Map.Entry)arrayIterator.next();
                    R01FLog.to("r01f.test").fine(me.getKey() + "::" + me.getValue());
                }
                ++i;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        Entry(String newKey, String newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            boolean valEq;
            boolean keyEq;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = this.key == null ? e.getKey() == null : (keyEq = this.key.equals(e.getKey()));
            boolean bl2 = this.value == null ? e.getValue() == null : (valEq = this.value.equals(e.getValue()));
            return keyEq && valEq;
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public class StringMapIterator
    implements Iterator {
        private int _lastPosition = -1;
        private int _type = 2;

        StringMapIterator(int type) {
            this._type = type;
            this._lastPosition = 0;
        }

        @Override
        public boolean hasNext() {
            return this._lastPosition <= StringMap.this._arrayInstance.length - 1;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object outNext = null;
            switch (this._type) {
                case 2: {
                    outNext = new Entry(StringMap.this._arrayInstance[this._lastPosition][0], StringMap.this._arrayInstance[this._lastPosition][1]);
                    break;
                }
                case 0: {
                    outNext = StringMap.this._arrayInstance[this._lastPosition][0];
                    break;
                }
                case 1: {
                    outNext = StringMap.this._arrayInstance[this._lastPosition][1];
                }
            }
            ++this._lastPosition;
            return outNext;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("No se pueden eliminar elementos utilizando el iterador sobre arrays bidimensionales");
        }
    }
}

