/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class StateMap
implements Map,
Serializable {
    private static final long serialVersionUID = 640781218151426368L;
    List keysOrdered;
    Map objs;
    static final int ITERATOR_KEYS = 0;
    static final int ITERATOR_VALUES = 1;
    static final int ITERATOR_ENTRIES = 2;
    static final int ITERATOR_DELETED = 3;
    static final int ITERATOR_NEW = 4;
    static final int ITERATOR_NOT_NEW = 5;

    public StateMap() {
        this.keysOrdered = new ArrayList();
        this.objs = new HashMap();
    }

    public StateMap(int size) {
        this.keysOrdered = new ArrayList(size);
        this.objs = new HashMap(size);
    }

    public StateMap(Map inMap) {
        this.putAll(inMap);
    }

    @Override
    public void clear() {
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            sme.isDeleted = true;
        }
    }

    @Override
    public boolean containsKey(Object inKey) {
        if (inKey == null) {
            throw new IllegalArgumentException("StateMap:containsKey(): Este Mapa no permite nulos en la clave");
        }
        if (!this.keysOrdered.contains(inKey)) {
            return false;
        }
        StateMapElement sme = (StateMapElement)this.objs.get(inKey);
        return !sme.isDeleted;
    }

    @Override
    public boolean containsValue(Object inValue) {
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            if (sme.isDeleted || sme.obj == null || inValue == null || !sme.obj.equals(inValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StateMap)) {
            return false;
        }
        StateMap that = (StateMap)obj;
        for (Map.Entry me : this.entrySet()) {
            Object thisObjValue = me.getValue();
            Object otherObjValue = that.get(me.getKey());
            if (otherObjValue == null && thisObjValue != null) {
                return false;
            }
            if (otherObjValue != null && thisObjValue == null) {
                return false;
            }
            if (thisObjValue.equals(otherObjValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.objs.hashCode() ^ this.keysOrdered.hashCode();
    }

    public Object get(Object inKey) {
        if (inKey == null) {
            throw new IllegalArgumentException("StateMap:get(): Este Mapa no permite nulos como clave");
        }
        StateMapElement sme = (StateMapElement)this.objs.get(inKey);
        if (sme == null) {
            return null;
        }
        if (sme.isDeleted) {
            return null;
        }
        return sme.obj;
    }

    public Object put(Object newKey, Object newValue) {
        if (newKey == null) {
            throw new IllegalArgumentException("StateMap:put(): Este Mapa no permite nulos en la clave");
        }
        int index = this.keysOrdered.indexOf(newKey);
        Object retObj = null;
        if (index >= 0) {
            StateMapElement sme = (StateMapElement)this.objs.get(newKey);
            sme.isDeleted = false;
            sme.isNew = false;
            retObj = sme.obj;
            sme.obj = newValue;
            this.objs.put(newKey, sme);
            return retObj;
        }
        this.keysOrdered.add(newKey);
        StateMapElement sme = new StateMapElement();
        sme.obj = newValue;
        this.objs.put(newKey, sme);
        return null;
    }

    public void putAll(Map m) {
        for (Map.Entry me : m.entrySet()) {
            if (me.getKey() == null) {
                throw new IllegalArgumentException("StateMap:putAll(): Este Mapa no permite nulos en la clave");
            }
            this.put(me.getKey(), me.getValue());
        }
    }

    public void putAllKeys(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object currKey = it.next();
            if (currKey == null) {
                throw new IllegalArgumentException("StateMap:putAllKeys(): Este mapa no permite nulos en la clave");
            }
            this.put(it.next(), (Object)null);
        }
    }

    public Object putNew(Object newKey, Object newValue) {
        Object retObj = this.put(newKey, newValue);
        StateMapElement sme = (StateMapElement)this.objs.get(newKey);
        if (sme != null) {
            sme.isNew = true;
        }
        return retObj;
    }

    public Object putNotNew(Object newKey, Object newValue) {
        Object retObj = this.put(newKey, newValue);
        StateMapElement sme = (StateMapElement)this.objs.get(newKey);
        if (sme != null) {
            sme.isNew = false;
        }
        return retObj;
    }

    public Object remove(Object inKey) {
        return this.removeObject(inKey);
    }

    public void removeAll() {
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            sme.isDeleted = true;
        }
    }

    public void removeAllDeletedForEver() {
        Iterator it = this.objs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            StateMapElement sme = (StateMapElement)me.getValue();
            if (!sme.isDeleted) continue;
            this.keysOrdered.remove(me.getKey());
            it.remove();
        }
    }

    public boolean removeDeletedObjForEver(Object inKey) {
        if (inKey == null) {
            throw new IllegalArgumentException("StateMap:removeDeletedObjForEver: Este Mapa no permite nulos en la clave");
        }
        if (!this.keysOrdered.contains(inKey)) {
            return false;
        }
        this.objs.remove(inKey);
        this.keysOrdered.remove(inKey);
        return true;
    }

    private Object removeObject(Object inKey) {
        if (this.keysOrdered.contains(inKey)) {
            StateMapElement sme = (StateMapElement)this.objs.get(inKey);
            sme.isDeleted = true;
            return sme.obj;
        }
        return null;
    }

    public void setAllNotNew() {
        for (StateMapElement sme : this.objs.values()) {
            sme.isNew = false;
        }
    }

    public void undeleteAllObjects() {
        for (Map.Entry me : this.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            sme.isDeleted = false;
        }
    }

    @Override
    public int size() {
        int elemCount = 0;
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            if (sme.isDeleted) continue;
            ++elemCount;
        }
        return elemCount;
    }

    public boolean hasNewObjects() {
        return this.newObjects().size() != 0;
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects().size() != 0;
    }

    public boolean hasNotNewObjects() {
        return this.notNewObjects().size() != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    int newObjectsCount() {
        int elemCount = 0;
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            if (!sme.isNew) continue;
            ++elemCount;
        }
        return elemCount;
    }

    int notNewObjectsCount() {
        int elemCount = 0;
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            if (sme.isNew | sme.isDeleted) continue;
            ++elemCount;
        }
        return elemCount;
    }

    public int deletedObjectsCount() {
        int elemCount = 0;
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            if (!sme.isDeleted) continue;
            ++elemCount;
        }
        return elemCount;
    }

    public Collection values() {
        ArrayList<Object> outValues = new ArrayList<Object>(this.size());
        Iterator it = this.keysOrdered.iterator();
        while (it.hasNext()) {
            StateMapElement sme = (StateMapElement)this.objs.get(it.next());
            if (sme.isDeleted) continue;
            outValues.add(sme.obj);
        }
        return outValues;
    }

    public Set keySet() {
        AbstractSet keySet = null;
        keySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StateMapIterator(0);
            }

            @Override
            public int size() {
                return StateMap.this.size();
            }

            @Override
            public boolean contains(Object inKey) {
                return StateMap.this.containsKey(inKey);
            }

            @Override
            public boolean remove(Object inKey) {
                return StateMap.this.remove(inKey) != null;
            }

            @Override
            public void clear() {
                StateMap.this.clear();
            }
        };
        return keySet;
    }

    public Set entrySet() {
        AbstractSet entrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StateMapIterator(2);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StateMap.this.get(me.getKey()) != null;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StateMap.this.remove(me.getKey()) != null;
            }

            @Override
            public int size() {
                return StateMap.this.size();
            }

            @Override
            public void clear() {
                StateMap.this.clear();
            }
        };
        return entrySet;
    }

    public Set newObjects() {
        AbstractSet entrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StateMapIterator(4);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                StateMapElement sme = (StateMapElement)StateMap.this.objs.get(me.getKey());
                if (sme != null) {
                    return sme.isNew;
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StateMap.this.remove(me.getKey()) != null;
            }

            @Override
            public int size() {
                return StateMap.this.newObjectsCount();
            }

            @Override
            public void clear() {
                for (Map.Entry me : StateMap.this.objs.entrySet()) {
                    StateMapElement sme = (StateMapElement)me.getValue();
                    if (!sme.isNew) continue;
                    sme.isDeleted = true;
                }
            }
        };
        return entrySet;
    }

    public Set notNewObjects() {
        AbstractSet entrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StateMapIterator(5);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                StateMapElement sme = (StateMapElement)StateMap.this.objs.get(me.getKey());
                if (sme != null) {
                    return !(sme.isNew | sme.isDeleted);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StateMap.this.remove(me.getKey()) != null;
            }

            @Override
            public int size() {
                return StateMap.this.notNewObjectsCount();
            }

            @Override
            public void clear() {
                for (Map.Entry me : StateMap.this.objs.entrySet()) {
                    StateMapElement sme = (StateMapElement)me.getValue();
                    if (sme.isNew | sme.isDeleted) continue;
                    sme.isDeleted = true;
                }
            }
        };
        return entrySet;
    }

    public Set deletedObjects() {
        AbstractSet entrySet = new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new StateMapIterator(3);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                StateMapElement sme = (StateMapElement)StateMap.this.objs.get(me.getKey());
                if (sme != null) {
                    return sme.isDeleted;
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                return StateMap.this.removeDeletedObjForEver(me.getKey());
            }

            @Override
            public int size() {
                return StateMap.this.deletedObjectsCount();
            }

            @Override
            public void clear() {
                StateMap.this.removeAllDeletedForEver();
            }
        };
        return entrySet;
    }

    public String printDebugInfo() {
        StringBuffer strO = new StringBuffer("");
        for (Map.Entry me : this.objs.entrySet()) {
            StateMapElement sme = (StateMapElement)me.getValue();
            if (sme.isNew) {
                strO.append("N-");
            } else if (sme.isDeleted) {
                strO.append("D-");
            } else {
                strO.append("U-");
            }
            strO.append(me.getKey());
            if (sme.obj == null) {
                strO.append("-[Null]");
            } else {
                strO.append("-[Object]");
            }
            strO.append("\r\n");
        }
        return strO.toString();
    }

    static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        Entry(Object newKey, Object newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            boolean valEq;
            boolean keyEq;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            boolean bl = this.key == null ? e.getKey() == null : (keyEq = this.key.equals(e.getKey()));
            boolean bl2 = this.value == null ? e.getValue() == null : (valEq = this.value.equals(e.getValue()));
            return keyEq && valEq;
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    static class StateMapElement
    implements Serializable {
        private static final long serialVersionUID = 2821038369128100194L;
        boolean isNew = true;
        boolean isDeleted = false;
        Object obj = null;

        StateMapElement() {
        }
    }

    private class StateMapIterator
    implements Iterator {
        int type;
        int globalPosition = 0;
        int iteratorPosition = 0;
        int globalLastReturned = -1;
        int iteratorLastReturned = -1;

        StateMapIterator(int newType) {
            this.type = newType;
        }

        @Override
        public boolean hasNext() {
            boolean retValue = false;
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: {
                    retValue = this.iteratorPosition <= StateMap.this.size() - 1;
                    break;
                }
                case 3: {
                    retValue = this.iteratorPosition <= StateMap.this.deletedObjectsCount() - 1;
                    break;
                }
                case 4: {
                    retValue = this.iteratorPosition <= StateMap.this.newObjectsCount() - 1;
                    break;
                }
                case 5: {
                    retValue = this.iteratorPosition <= StateMap.this.notNewObjectsCount() - 1;
                }
            }
            return retValue;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            boolean encontrado = false;
            Object retObj = null;
            while (!encontrado && this.globalPosition <= StateMap.this.objs.size() - 1) {
                Object key = StateMap.this.keysOrdered.get(this.globalPosition);
                StateMapElement sme = (StateMapElement)StateMap.this.objs.get(key);
                switch (this.type) {
                    case 0: {
                        if (sme.isDeleted) break;
                        retObj = key;
                        encontrado = true;
                        break;
                    }
                    case 1: {
                        if (sme.isDeleted) break;
                        retObj = sme.obj;
                        encontrado = true;
                        break;
                    }
                    case 2: {
                        if (sme.isDeleted) break;
                        retObj = new Entry(key, sme.obj);
                        encontrado = true;
                        break;
                    }
                    case 3: {
                        if (!sme.isDeleted) break;
                        retObj = new Entry(key, sme.obj);
                        encontrado = true;
                        break;
                    }
                    case 4: {
                        if (!sme.isNew) break;
                        retObj = new Entry(key, sme.obj);
                        encontrado = true;
                        break;
                    }
                    case 5: {
                        if (sme.isNew | sme.isDeleted) break;
                        retObj = new Entry(key, sme.obj);
                        encontrado = true;
                    }
                }
                if (encontrado) continue;
                ++this.globalPosition;
            }
            this.iteratorLastReturned = this.iteratorPosition++;
            this.globalLastReturned = this.globalPosition++;
            return retObj;
        }

        @Override
        public void remove() {
            if (this.globalLastReturned == -1) {
                throw new IllegalStateException("StateMap:Iterator:Remove(): No hay elementos para eliminar");
            }
            Object key = StateMap.this.keysOrdered.get(this.globalLastReturned);
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    StateMap.this.remove(key);
                    break;
                }
                case 3: {
                    StateMap.this.removeDeletedObjForEver(key);
                }
            }
            this.globalPosition = this.globalLastReturned;
            this.globalLastReturned = -1;
            this.iteratorPosition = this.iteratorLastReturned;
            this.iteratorLastReturned = -1;
        }
    }
}

