/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class MoneyUtils {
    public static long getCenteuros(double cantidad) {
        String doubleStr;
        String longStr = doubleStr = MoneyUtils.format(cantidad);
        int comaIndx = doubleStr.indexOf(44);
        if (comaIndx == -1) {
            comaIndx = doubleStr.indexOf(46);
        }
        if (comaIndx != -1) {
            longStr = String.valueOf(doubleStr.substring(0, comaIndx)) + doubleStr.substring(comaIndx + 1);
        }
        return Long.parseLong(longStr);
    }

    public static long getCenteuros(String dblCantidad) {
        if (dblCantidad.indexOf(44) >= 0) {
            dblCantidad = dblCantidad.replace(',', '.');
        }
        return MoneyUtils.getCenteuros(Double.parseDouble(dblCantidad));
    }

    public static String format(double cantidad) {
        NumberFormat decimalFormat = DecimalFormat.getInstance();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        ((DecimalFormat)decimalFormat).setDecimalSeparatorAlwaysShown(true);
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(new Locale("es", "ES"));
        formatSymbols.setDecimalSeparator(',');
        ((DecimalFormat)decimalFormat).setDecimalFormatSymbols(formatSymbols);
        return decimalFormat.format(cantidad);
    }

    public static String format(long centeuros) {
        double dbl = MoneyUtils.getDoubleFromCenteuros(centeuros);
        return MoneyUtils.format(dbl);
    }

    public static double getDoubleFromCenteuros(long centeuros) {
        String intStr = "" + centeuros / 100L;
        String decStr = "00" + centeuros % 100L;
        String dblStr = String.valueOf(intStr) + "." + decStr.substring(decStr.length() - 2);
        return Double.parseDouble(dblStr);
    }

    public static double getDoubleFromCenteuros(String centeuros) {
        return MoneyUtils.getDoubleFromCenteuros(Long.parseLong(centeuros));
    }

    public static void main(String[] argv) {
        double dblCantidad = 12.9234;
        String strCantidad = "12,9234";
        long centeuros = 0L;
        centeuros = MoneyUtils.getCenteuros(dblCantidad);
        R01FLog.to("r01f.test").fine("Centeuros: " + centeuros);
        dblCantidad = MoneyUtils.getDoubleFromCenteuros(centeuros);
        R01FLog.to("r01f.test").fine("Double from Centeuros: " + dblCantidad);
        R01FLog.to("r01f.test").fine("Centeuros from double: " + MoneyUtils.getCenteuros(Double.toString(dblCantidad)));
        R01FLog.to("r01f.test").fine("---------------------------");
        centeuros = MoneyUtils.getCenteuros(strCantidad);
        R01FLog.to("r01f.test").fine("Centeuros from String: " + centeuros);
        R01FLog.to("r01f.test").fine("Centeuros formated: " + MoneyUtils.format(centeuros));
    }
}

