/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import com.ejie.r01f.util.StringUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public abstract class DateUtils {
    public static final int LANGUAGE_CASTELLANO = 0;
    public static final int LANGUAGE_EUSKERA = 1;

    public static String getLanguageDateFormat(String lang, Properties langFormats) {
        String fmt = null;
        if (langFormats != null) {
            if (lang != null) {
                fmt = langFormats.getProperty(lang);
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("default");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("def");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("other");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("all");
            }
            if (fmt == null) {
                fmt = langFormats.getProperty("es");
            }
        }
        if (fmt == null) {
            fmt = "dd/MM/yyyy";
        }
        return fmt;
    }

    public static long getDateAsMillis(Date date) {
        if (date == null) {
            return Long.MIN_VALUE;
        }
        return date.getTime();
    }

    public static Date getDateFromMillis(long milis) {
        return new Date(milis);
    }

    public static String getDateFormated(Date date, String fmt) {
        return DateUtils.getDateFormated(date, fmt, Locale.getDefault());
    }

    public static String getDateFormated(Date date, String fmt, Locale locale) {
        Date dat = date == null ? new Date() : new Date(date.getTime());
        String theFmt = fmt;
        if (theFmt == null || StringUtils.isEmptyString(theFmt)) {
            theFmt = "dd/MM/yyyy";
        }
        if (theFmt.equalsIgnoreCase("millis")) {
            return Long.toString(dat.getTime());
        }
        if (theFmt.equalsIgnoreCase("seconds")) {
            return Long.toString(dat.getTime() / 1000L);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(theFmt, locale);
        if (locale.equals(Locale.ENGLISH)) {
            TimeZone zone = formatter.getTimeZone();
            int msInMin = 60000;
            int minInHr = 60;
            int Minutes = zone.getOffset(date.getTime()) / 60000;
            int Hours = Minutes / 60;
            zone = TimeZone.getTimeZone("GMT Time" + (Hours >= 0 ? "+" : "") + Hours + ":" + Minutes);
            formatter.setTimeZone(zone);
        }
        return formatter.format(dat);
    }

    public static String getDateLanguageFormated(Date date, String lang, Properties langFormats) {
        String fmt = DateUtils.getLanguageDateFormat(lang, langFormats);
        return DateUtils.getDateFormated(date, fmt);
    }

    public static Date getDateFromFormatedString(String dateStr, String format) {
        if (dateStr == null) {
            return null;
        }
        String date = new String(dateStr);
        String fmt = new String(format);
        if (fmt == null || StringUtils.isEmptyString(fmt)) {
            fmt = "dd/MM/yyyy";
        }
        if (date == null || StringUtils.isEmptyString(date)) {
            date = DateUtils.getDateFormated(new Date(), fmt);
        }
        if (format.equalsIgnoreCase("millis") && NumberUtils.isLong(dateStr)) {
            return new Date(Long.parseLong(dateStr));
        }
        if (format.equalsIgnoreCase("seconds") && NumberUtils.isLong(dateStr)) {
            return new Date(Long.parseLong(dateStr) * 1000L);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(fmt);
        formatter.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(date, pos);
    }

    public static Date getDateFromLanguageFormatedString(String dateStr, String lang, Properties langFormats) {
        if (dateStr == null) {
            return null;
        }
        String fmt = DateUtils.getLanguageDateFormat(lang, langFormats);
        return DateUtils.getDateFromFormatedString(dateStr, fmt);
    }

    public static String reformatDateString(String dateStr, String oldFormat, String newFormat) {
        String theOldFmt = oldFormat;
        String theNewFmt = newFormat;
        String theDateStr = dateStr;
        if (StringUtils.isEmptyString(theOldFmt)) {
            theOldFmt = "dd/MM/yyyy";
        }
        if (StringUtils.isEmptyString(theNewFmt)) {
            theNewFmt = "dd/MM/yyyy";
        }
        if (StringUtils.isEmptyString(theDateStr)) {
            theDateStr = DateUtils.getDateFormated(new Date(), theOldFmt);
        }
        Date newDate = DateUtils.getDateFromFormatedString(theDateStr, theOldFmt);
        return DateUtils.getDateFormated(newDate, theNewFmt);
    }

    public static String getTimeStamp() {
        String format = "dd/MM/yyyy [HH:mm:ss:SSS]";
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }

    public static String getCurrentDateAsString(String lang) {
        if (lang != null) {
            if (lang.equals("es")) {
                return DateUtils.getCurrentDateAsString(0);
            }
            if (lang.equals("eu")) {
                return DateUtils.getCurrentDateAsString(1);
            }
        }
        return null;
    }

    public static String getCurrentDateAsString(int language) {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        int monthOfYear = calendar.get(2);
        int year = calendar.get(1);
        switch (language) {
            case 0: {
                return String.valueOf(DateUtils._getDayOfWeekName(dayOfWeek, 0)) + ", " + calendar.get(5) + " de " + DateUtils._getMonthName(monthOfYear, 0) + " de " + year;
            }
            case 1: {
                return String.valueOf(DateUtils._getDayOfWeekName(dayOfWeek, 1)) + ", " + year + "-ko " + DateUtils._getMonthName(monthOfYear, 1) + "ren " + calendar.get(5);
            }
        }
        return String.valueOf(day) + "/" + monthOfYear + "/" + year;
    }

    private static String _getDayOfWeekName(int dayOfWeek, int language) {
        switch (language) {
            case 0: {
                return DateUtils._getDayOfWeekInCastellano(dayOfWeek);
            }
            case 1: {
                return DateUtils._getDayOfWeekInEuskera(dayOfWeek);
            }
        }
        return "";
    }

    private static String _getMonthName(int month, int language) {
        switch (language) {
            case 0: {
                return DateUtils._getMonthNameInCastellano(month);
            }
            case 1: {
                return DateUtils._getMonthNameInEuskera(month);
            }
        }
        return "";
    }

    private static String _getDayOfWeekInEuskera(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return "Igandea";
            }
            case 2: {
                return "Astelehena";
            }
            case 3: {
                return "Asteartea";
            }
            case 4: {
                return "Asteazkena";
            }
            case 5: {
                return "Osteguna";
            }
            case 6: {
                return "Ostirala";
            }
            case 7: {
                return "Larunbata";
            }
        }
        return "";
    }

    private static String _getDayOfWeekInCastellano(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return "Domingo";
            }
            case 2: {
                return "Lunes";
            }
            case 3: {
                return "Martes";
            }
            case 4: {
                return "Mi\u00e9rcoles";
            }
            case 5: {
                return "Jueves";
            }
            case 6: {
                return "Viernes";
            }
            case 7: {
                return "S\u00e1bado";
            }
        }
        return "";
    }

    private static String _getMonthNameInEuskera(int month) {
        switch (month) {
            case 0: {
                return "Urtarila";
            }
            case 1: {
                return "Otsaila";
            }
            case 2: {
                return "Martxoa";
            }
            case 3: {
                return "Aprila";
            }
            case 4: {
                return "Maiatza";
            }
            case 5: {
                return "Ekaina";
            }
            case 6: {
                return "Uztaila";
            }
            case 7: {
                return "Abuztua";
            }
            case 8: {
                return "Iraila";
            }
            case 9: {
                return "Urria";
            }
            case 10: {
                return "Azaroa";
            }
            case 11: {
                return "Abendua";
            }
        }
        return "";
    }

    private static String _getMonthNameInCastellano(int month) {
        switch (month) {
            case 0: {
                return "Enero";
            }
            case 1: {
                return "Febrero";
            }
            case 2: {
                return "Marzo";
            }
            case 3: {
                return "Abril";
            }
            case 4: {
                return "Mayo";
            }
            case 5: {
                return "Junio";
            }
            case 6: {
                return "Julio";
            }
            case 7: {
                return "Agosto";
            }
            case 8: {
                return "Septiembre";
            }
            case 9: {
                return "Octubre";
            }
            case 10: {
                return "Noviembre";
            }
            case 11: {
                return "Diciembre";
            }
        }
        return "";
    }

    public static Date rollDateToMaximum(Date date) {
        Calendar theCal = Calendar.getInstance();
        theCal.setTime(date);
        return DateUtils.rollCalendarToMaximum(theCal).getTime();
    }

    public static Date rollDateToMinimum(Date date) {
        Calendar theCal = Calendar.getInstance();
        theCal.setTime(date);
        return DateUtils.rollCalendarToMinimum(theCal).getTime();
    }

    public static Calendar rollCalendarToMaximum(Calendar theCal) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(theCal.getTime());
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(14, cal.getActualMaximum(14));
        return cal;
    }

    public static Calendar rollCalendarToMinimum(Calendar theCal) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(theCal.getTime());
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(14, cal.getActualMinimum(14));
        return cal;
    }

    public static void main(String[] argv) {
        R01FLog.to("r01f.test").fine("Primer milli: " + DateUtils.rollDateToMaximum(new Date()));
        R01FLog.to("r01f.test").fine("Ultimo Milli: " + DateUtils.rollDateToMinimum(new Date()));
        long dateNum = Long.parseLong("1138618020");
        Date dat = new Date(dateNum *= 1000L);
        R01FLog.to("r01f.test").fine(dat.toString());
        Date millisDate = DateUtils.getDateFromMillis(1164273955L);
        R01FLog.to("r01f.test").fine(">>>>" + DateUtils.getDateFormated(millisDate, "dd/MM/yyyy"));
        Date searchedDate = DateUtils.getDateFromFormatedString("31/01/1970", "dd/MM/yyyy");
        R01FLog.to("r01f.test").fine(">>>>>>>>>>>>>>" + searchedDate.getTime());
        R01FLog.to("r01f.test").fine(">>>>" + DateUtils.getDateFormated(searchedDate, "dd/MM/yyyy"));
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(searchedDate);
        calendar.add(6, 1);
        Date nextDate = calendar.getTime();
        R01FLog.to("r01f.test").fine("<<<<" + DateUtils.getDateFormated(nextDate, "dd/MM/yyyy"));
        String dateFormat1 = "dd/MM/yyyy";
        String dateFormat2 = "yyyy/MM/dd";
        Date date = DateUtils.getDateFromFormatedString("25/12/1971", dateFormat1);
        String formatedDate = DateUtils.getDateFormated(date, dateFormat2);
        R01FLog.to("r01f.test").fine("\r\n\r\n\r\n:::::: 25/12/1971---" + formatedDate);
    }
}

