/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.util;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.NumberUtils;
import java.io.Serializable;

public class BaseBitMap
implements Serializable {
    private static final long serialVersionUID = -6185098989819967636L;
    int bitMap = 0;

    public BaseBitMap() {
    }

    public BaseBitMap(int newBitMap) {
        this();
        this.bitMap = newBitMap;
    }

    public int getBitMap() {
        return this.bitMap;
    }

    public int setBitMap(int theBitMap) {
        int prevbitMap = this.bitMap;
        this.bitMap = theBitMap;
        return prevbitMap;
    }

    public void incorporateBitMapInfo(BaseBitMap otherFlags) {
        this.bitMap |= otherFlags.getBitMap();
    }

    protected boolean getBit(int bitIndex) {
        return NumberUtils.getBit(this.bitMap, 31 - bitIndex - 1);
    }

    protected void setBit(int bitIndex) {
        this.bitMap = NumberUtils.setBit(this.bitMap, 31 - bitIndex - 1);
    }

    protected void clearBit(int bitIndex) {
        this.bitMap = NumberUtils.clearBit(this.bitMap, 31 - bitIndex - 1);
    }

    public String composeDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Mapa de bits: " + this.bitMap + " : " + Integer.toBinaryString(this.bitMap) + "\r\n");
        String currBitStr = "";
        int i = 0;
        while (i <= 30) {
            currBitStr = "  " + i;
            sb.append(String.valueOf(currBitStr.substring(currBitStr.length() - 2)) + "|");
            ++i;
        }
        sb.append("\r\n");
        i = 0;
        while (i <= 30) {
            currBitStr = this.getBit(i) ? " 1" : " 0";
            sb.append(String.valueOf(currBitStr.substring(currBitStr.length() - 2)) + "|");
            ++i;
        }
        sb.append("\r\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i <= 30) {
            sb.append(this.getBit(i) ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int testTimes = 1;
            int times = 0;
            while (times < testTimes) {
                String strMap = "01100000100000000000000000000011";
                int map = Integer.parseInt(strMap, 2);
                R01FLog.to("r01f.test").fine(Integer.toString(map));
                BaseBitMap bbm = new BaseBitMap(map);
                R01FLog.to("r01f.test").fine(bbm.composeDebugInfo());
                R01FLog.to("r01f.test").fine("0 > " + bbm.getBit(0));
                R01FLog.to("r01f.test").fine("1 > " + bbm.getBit(1));
                R01FLog.to("r01f.test").fine("3 > " + bbm.getBit(2));
                R01FLog.to("r01f.test").fine("8 > " + bbm.getBit(8));
                R01FLog.to("r01f.test").fine("29> " + bbm.getBit(29));
                R01FLog.to("r01f.test").fine("30> " + bbm.getBit(30));
                ++times;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t1) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

