/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.textsearch;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.log.SimpleFileLogger;
import com.ejie.r01f.textsearch.DirectoryTextSearch;
import com.ejie.r01f.textsearch.FilteredFileTextSearch;
import com.ejie.r01f.textsearch.PatternMatchSearch;
import com.ejie.r01f.textsearch.TextSearchLogger;
import com.ejie.r01f.util.MainParamsParser;
import com.ejie.r01f.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LinkFinder {
    public static void main(String[] args) {
        try {
            MainParamsParser fileParam = new MainParamsParser();
            fileParam.addParamDef("-paramFile", "Fichero que contiene los parametros de entrada", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
            fileParam.parseParams(args);
            String[] inputParams = null;
            if (!fileParam.areValid()) {
                R01FLog.to("r01f.test").fine("Error en los parametros de entrada!!!!");
                return;
            }
            R01FLog.to("r01f.test").fine("Cargando los parametros de entrada...");
            inputParams = LinkFinder.loadArgs(fileParam.getParam("-paramFile"));
            R01FLog.to("r01f.test").fine(">>>> Lanzando la aplicaci\u00f3n con los parametros:");
            int i = 0;
            while (i < inputParams.length) {
                R01FLog.to("r01f.test").fine("\t" + inputParams[i]);
                ++i;
            }
            MainParamsParser params = new MainParamsParser();
            params.addParamDef("-patternRegExp", "Expresion regular para buscar links", MainParamsParser.PARAM_TYPE_GENERAL, true);
            params.addParamDef("-logFile", "Fichero de log", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
            params.parseParams(inputParams);
            if (params.areValid()) {
                SimpleFileLogger logger = new SimpleFileLogger(params.getParam("-logFile"));
                logger.start();
                TextSearchLogger eventListener = new TextSearchLogger(logger);
                HashMap context = new HashMap();
                PatternMatchSearch textSearch = null;
                textSearch = new PatternMatchSearch(params.getParam("-patternRegExp"), eventListener);
                params.addParamDef("-srcFile", "Fichero de origen", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                params.parseParams(inputParams);
                if (params.areValid()) {
                    R01FLog.to("r01f.test").fine("CASO 1: Un \u00fanico fichero....");
                    R01FLog.to("r01f.test").fine(params.toString());
                    FilteredFileTextSearch fileTextSearch = new FilteredFileTextSearch("<", ">", eventListener);
                    fileTextSearch.doSearch(context, params.getParam("-srcFile"), textSearch);
                } else {
                    params.removeParamDef("-srcFile");
                    params.addParamDef("-dir", "Directorio", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
                    params.addParamDef("-fileFilterExpr", "Expresion que han de verificar los nombres de los ficheros", MainParamsParser.PARAM_TYPE_GENERAL, false);
                    params.parseParams(inputParams);
                    if (params.areValid()) {
                        R01FLog.to("r01f.test").fine("CASO 2: Un directorio....");
                        R01FLog.to("r01f.test").fine(params.toString());
                        DirectoryTextSearch dirReplacer = new DirectoryTextSearch(eventListener);
                        dirReplacer.doReplace(context, params.getParam("-dir"), params.getParam("-fileFilterExpr"), textSearch, new FilteredFileTextSearch("<", ">", eventListener));
                    } else {
                        R01FLog.to("r01f.test").fine("ERROR EN LOS PARAMETROS DE ENTRADA!!!!");
                        R01FLog.to("r01f.test").fine(LinkFinder._composeHelpMsg());
                    }
                }
                logger.stop();
                R01FLog.to("r01f.test").fine("FIN!!!!!");
            } else {
                R01FLog.to("r01f.test").fine("ERROR EN LOS PARAMETROS DE ENTRADA!!!!");
                R01FLog.to("r01f.test").fine(LinkFinder._composeHelpMsg());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            R01FLog.to("r01f.test").fine("Exception!!!" + ex.toString());
        }
    }

    private static String _composeHelpMsg() {
        StringBuffer sb = new StringBuffer("");
        MainParamsParser params = new MainParamsParser();
        params.addParamDef("-patternRegExp", "Expresion regular para buscar el texto del enlace", MainParamsParser.PARAM_TYPE_GENERAL, true);
        params.addParamDef("-logFile", "Fichero de log", MainParamsParser.PARAM_TYPE_ALFANUMERIC, false);
        sb.append("Utilizacion:\r\n");
        sb.append("-----------------------------------------------------\r\n");
        sb.append("Para remplazar texto en un unico fichero: \r\n");
        params.addParamDef("-srcFile", "Fichero de origen", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        sb.append(params.getParamsUsageMessage());
        sb.append("\r\n\r\n");
        sb.append("Para remplazar texto en varios ficheros en una estructura de directorios:\r\n");
        params.removeParamDef("-srcFile");
        params.addParamDef("-dir", "Directorio", MainParamsParser.PARAM_TYPE_ALFANUMERIC, true);
        params.addParamDef("-fileFilterExpr", "Expresion que han de verificar los nombres de los ficheros", MainParamsParser.PARAM_TYPE_GENERAL, false);
        sb.append(params.getParamsUsageMessage());
        return sb.toString();
    }

    public static String[] loadArgs(String argsFileName) throws Exception {
        if (argsFileName == null || StringUtils.isEmptyString(argsFileName)) {
            throw new Exception("No se ha pasado la ruta al fichero de parametros de lanzamientos");
        }
        try {
            R01FLog.to("r01f.test").fine("Cargando parametros desde " + argsFileName);
            BufferedReader br = new BufferedReader(new FileReader(argsFileName));
            ArrayList<String> argsList = new ArrayList<String>();
            String currLine = null;
            do {
                if ((currLine = br.readLine()) == null || currLine.trim().startsWith("#")) continue;
                argsList.add(currLine);
            } while (currLine != null);
            if (argsList.size() > 0) {
                String[] outArgs = new String[argsList.size()];
                int i = 0;
                Iterator it = argsList.iterator();
                while (it.hasNext()) {
                    outArgs[i] = (String)it.next();
                    ++i;
                }
                return outArgs;
            }
        }
        catch (FileNotFoundException fnfEx) {
            throw new Exception("No se encuentra el fichero de parametros de lanzamiento en '" + argsFileName + "': " + fnfEx.toString());
        }
        return null;
    }
}

