/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.textsearch;

import com.ejie.r01f.file.DirectoryWalker;
import com.ejie.r01f.file.DirectoryWalkerEventListener;
import com.ejie.r01f.file.DirectoryWalkerLogger;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.textsearch.FileTextSearch;
import com.ejie.r01f.textsearch.TextSearch;
import com.ejie.r01f.textsearch.TextSearchEventListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectoryTextSearch
implements DirectoryWalkerEventListener {
    private TextSearch _textSearch = null;
    private FileTextSearch _fileTextSearch = null;
    private int _ident = 0;
    private TextSearchEventListener _eventListener = null;
    private Map _context = null;

    public DirectoryTextSearch(TextSearchEventListener eventListener) {
        this._eventListener = eventListener;
    }

    @Override
    public void enteringDirectory(File theDirectory) {
        ++this._ident;
        R01FLog.to("r01f.test").fine(String.valueOf(this._ident()) + "[d] " + theDirectory.getName());
        if (this._eventListener != null) {
            this._eventListener.enteringDirectory(this._context, theDirectory.getName());
        }
    }

    @Override
    public void exitingDirectory(File theDirectory) {
        R01FLog.to("r01f.test").fine(String.valueOf(this._ident()) + "[d] " + theDirectory.getName());
        --this._ident;
        if (this._eventListener != null) {
            this._eventListener.exitingDirectory(this._context, theDirectory.getName());
        }
    }

    @Override
    public void file(File theFile) {
        try {
            R01FLog.to("r01f.test").fine("=====>" + theFile.getAbsolutePath());
            this._fileTextSearch.doSearch(this._context, theFile.getCanonicalPath(), this._textSearch);
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace(System.out);
        }
    }

    public void doReplace(Map context, String dir, final String fileFilterExpr, TextSearch textSearch, FileTextSearch fileTextSearch) {
        this._context = context;
        this._textSearch = textSearch;
        this._fileTextSearch = fileTextSearch;
        DirectoryWalker dirWalk = null;
        if (fileFilterExpr != null) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    Pattern p = Pattern.compile(fileFilterExpr, 128);
                    Matcher m = p.matcher(file.getAbsolutePath());
                    return m.matches();
                }
            };
            DirectoryWalkerLogger dwLog = new DirectoryWalkerLogger();
            dirWalk = new DirectoryWalker(dir, this, fileFilter);
        } else {
            dirWalk = new DirectoryWalker(dir, this);
        }
        while (dirWalk.hasNext()) {
            dirWalk.next();
        }
    }

    private String _ident() {
        String outIdent = "";
        int i = 0;
        while (i < this._ident) {
            outIdent = String.valueOf(outIdent) + "\t";
            ++i;
        }
        return outIdent;
    }
}

