/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.taglibs.xtags.objects;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class XTag {
    public String xmlTagName = null;
    public String sourceTagID = null;
    public int sourceTagType = 0;
    public boolean isAttribute = false;
    public boolean isCDATA = false;
    public String check = null;
    public XTag parentXTag = null;
    public List childXTags = null;

    public XTag() {
        this("-sinNombre-", "-sinNombre-");
    }

    public XTag(String newXMLTagName, String newSourceTagID) {
        this.xmlTagName = newXMLTagName;
        this.sourceTagID = newSourceTagID;
    }

    public XTag(String newXMLTagName, int newSourceTagType, String newCheck) {
        this.xmlTagName = newXMLTagName;
        this.sourceTagID = newXMLTagName;
        this.sourceTagType = newSourceTagType;
        this.check = newCheck;
    }

    public XTag(String newXMLTagName, String newSourceTagID, int newSourceTagType, String newCheck) {
        this(newXMLTagName, newSourceTagID);
        this.sourceTagType = newSourceTagType;
        this.check = newCheck;
    }

    public XTag(String newXMLTagName, String newSourceTagID, int newSourceTagType, String newCheck, boolean newIsAttribute, boolean newIsCDATA) {
        this(newXMLTagName, newSourceTagID, newSourceTagType, newCheck);
        this.isAttribute = newIsAttribute;
        if (!this.isAttribute) {
            this.isCDATA = newIsCDATA;
        }
    }

    public void addChildXTag(String theXMLTagName, String theSourceTagId, int theSourceTagType, String theCheck, boolean theIsAttribute, boolean theIsCDATA) {
        if (theXMLTagName == null || theSourceTagId == null) {
            return;
        }
        XTag childXTag = new XTag(theXMLTagName, theSourceTagId, theSourceTagType, theCheck, theIsAttribute, theIsCDATA);
        this.addChildXTag(childXTag);
    }

    public void addChildXTag(XTag childXTag) {
        if (childXTag == null || childXTag.xmlTagName == null) {
            return;
        }
        childXTag.parentXTag = this;
        if (this.childXTags == null) {
            this.childXTags = new ArrayList();
        } else if (this.sourceTagType == 11) {
            if (!this.childXTags.isEmpty()) {
                return;
            }
            if (childXTag.sourceTagType != 10) {
                return;
            }
        }
        this.childXTags.add(childXTag);
    }

    public String getJavaScript() {
        StringBuffer sb = new StringBuffer();
        R01FLog.to("r01f.xTags").finest("Generando JavaScript xTags de obtencion de XML a partir de HTML");
        sb.append("\r\n//__________________________________________________________\\\r\n");
        sb.append(this._getXMLConversionJavaScript());
        R01FLog.to("r01f.xTags").finest("Generando JavaScript xTags de limpiado de controles HTML");
        sb.append("//__________________________________________________________\\\r\n");
        sb.append(this._getClearControlsJavaScript());
        R01FLog.to("r01f.xTags").finest("Generando JavaScript xTags de validacion de formularios");
        sb.append("//__________________________________________________________\\\r\n");
        sb.append(this._getFormValidationJavaScript());
        return sb.toString();
    }

    private String _getXMLConversionJavaScript() {
        StringBuffer func = new StringBuffer();
        StringBuffer otherFuncs = new StringBuffer();
        String xTagVar = "oXTag" + StringUtils.capitalizeFirstLetter(this.xmlTagName);
        String capName = StringUtils.capitalizeFirstLetter(this.xmlTagName);
        if (this.xmlTagName == null) {
            return "\r\n<script language='JavaScript'>alert('Error al obtener el JS: hay algun error en los xtags. Revisa el codigo')</script>";
        }
        func.append("function get" + capName + "(div" + capName + ") {\r\n");
        func.append("\tvar " + xTagVar + " = new XTag(div" + capName + ");\r\n");
        func.append("\tvar " + this.xmlTagName + " = new XMLNode(\"" + this.xmlTagName + "\");\r\n\r\n");
        for (XTag currChildXTag : this.childXTags) {
            R01FLog.to("r01f.xTags").finest("\tJavaScript para el miembro: " + currChildXTag.sourceTagID + ":" + currChildXTag.xmlTagName + ": " + currChildXTag.childXTags);
            String capMember = StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName);
            switch (currChildXTag.sourceTagType) {
                case 10: {
                    func.append("\t" + this.xmlTagName + ".addNode( get" + capMember + "(" + xTagVar + ".getElement(\"" + currChildXTag.sourceTagID + "\")) );\r\n");
                    otherFuncs.append(currChildXTag._getXMLConversionJavaScript());
                    break;
                }
                case 11: {
                    if (currChildXTag.childXTags == null) break;
                    XTag listXTag = (XTag)currChildXTag.childXTags.get(0);
                    func.append("\t" + this.xmlTagName + ".addNode( getNodeListFromDivs(" + xTagVar + ".getElementList(\"" + currChildXTag.sourceTagID + "\",\"" + listXTag.sourceTagID + "\")" + ",\"" + currChildXTag.xmlTagName + "\",\"get" + StringUtils.capitalizeFirstLetter(listXTag.xmlTagName) + "\") );\r\n");
                    otherFuncs.append(currChildXTag._getXMLConversionJavaScript());
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 25: {
                    if (currChildXTag.isAttribute) {
                        func.append("\t" + this.xmlTagName + ".addAttribute( new XMLAttribute(\"" + currChildXTag.xmlTagName + "\"," + xTagVar + ".getElement(\"" + currChildXTag.sourceTagID + "\")) );\r\n");
                        break;
                    }
                    String elemValue = String.valueOf(xTagVar) + ".getElement(\"" + currChildXTag.sourceTagID + "\")";
                    if (currChildXTag.xmlTagName.equalsIgnoreCase(this.xmlTagName)) {
                        if (currChildXTag.isCDATA) {
                            elemValue = "\"<![CDATA[\" + " + elemValue + " + \"]]>\"";
                        }
                        func.append("\t" + this.xmlTagName + ".nodeText = " + elemValue + ";\r\n");
                        break;
                    }
                    func.append("\t" + this.xmlTagName + ".addNode( new XMLNode(\"" + currChildXTag.xmlTagName + "\"," + elemValue + ") );\r\n");
                    break;
                }
                case 24: {
                    func.append("\t" + this.xmlTagName + ".addNode( new XMLNode(\"" + currChildXTag.xmlTagName + "\",\"<![CDATA[\" + " + currChildXTag.sourceTagID + ".getHTML() + \"]]>\") );\r\n");
                    break;
                }
                case 30: {
                    String valueVar;
                    String codVar;
                    String arrayVar;
                    XTag keyXTag = null;
                    XTag selectTextXTag = null;
                    if (currChildXTag.isAttribute) {
                        arrayVar = "o" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName);
                        func.append("\tvar " + arrayVar + " = oXTag" + StringUtils.capitalizeFirstLetter(currChildXTag.parentXTag.xmlTagName) + ".getElement(\"" + currChildXTag.sourceTagID + "\");\r\n");
                        func.append("\tif (" + arrayVar + " != null) {\r\n");
                        func.append("\t\tvar value = " + arrayVar + "[\"codigo\"];\r\n");
                        func.append("\t\t" + this.xmlTagName + ".addAttribute( new XMLAttribute(\"" + (currChildXTag.xmlTagName == null ? "cod" : currChildXTag.xmlTagName) + "\",value) );\r\n");
                        func.append("\t}\r\n");
                        break;
                    }
                    for (XTag currVirtualXTag : currChildXTag.childXTags) {
                        if (currVirtualXTag.sourceTagID == null) continue;
                        if (currVirtualXTag.sourceTagID.equalsIgnoreCase("-key-")) {
                            keyXTag = currVirtualXTag;
                        }
                        if (!currVirtualXTag.sourceTagID.equalsIgnoreCase("-selectText-")) continue;
                        selectTextXTag = currVirtualXTag;
                    }
                    if (selectTextXTag == null) {
                        func.append("\t" + this.xmlTagName + ".addNode( get" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName) + "Combo(" + xTagVar + ") );\r\n");
                        arrayVar = "o" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName);
                        codVar = String.valueOf(currChildXTag.xmlTagName) + "Cod";
                        valueVar = String.valueOf(currChildXTag.xmlTagName) + "Value";
                        otherFuncs.append("function get" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName) + "Combo(oXTag) {\r\n");
                        otherFuncs.append("\tvar " + arrayVar + " = oXTag.getElement(\"" + currChildXTag.sourceTagID + "\");\r\n");
                        otherFuncs.append("\tif (" + arrayVar + " != null) {\r\n");
                        otherFuncs.append("\t\tvar value = " + arrayVar + "[\"codigo\"];\r\n");
                        otherFuncs.append("\t\tvar " + currChildXTag.xmlTagName + " = new XMLNode(\"" + currChildXTag.xmlTagName + "\");\r\n");
                        otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".nodeText = value;\r\n");
                        otherFuncs.append("\t}\r\n");
                        otherFuncs.append("\treturn " + currChildXTag.xmlTagName + ";\r\n");
                        otherFuncs.append("}\r\n");
                        break;
                    }
                    func.append("\t" + this.xmlTagName + ".addNode( get" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName) + "Combo(" + xTagVar + ") );\r\n");
                    arrayVar = "o" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName);
                    codVar = String.valueOf(currChildXTag.xmlTagName) + "Cod";
                    valueVar = String.valueOf(currChildXTag.xmlTagName) + "Value";
                    otherFuncs.append("function get" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName) + "Combo(oXTag) {\r\n");
                    otherFuncs.append("\tvar " + arrayVar + " = oXTag.getElement(\"" + currChildXTag.sourceTagID + "\");\r\n");
                    otherFuncs.append("\tif (" + arrayVar + " != null) {\r\n");
                    otherFuncs.append("\t\tvar " + codVar + " = " + arrayVar + "[\"codigo\"];\r\n");
                    otherFuncs.append("\t\tvar " + valueVar + " = " + arrayVar + "[\"descripcion\"];\r\n");
                    otherFuncs.append("\t\tvar " + currChildXTag.xmlTagName + " = new XMLNode(\"" + currChildXTag.xmlTagName + "\");\r\n");
                    if (keyXTag != null) {
                        if (keyXTag.isAttribute) {
                            otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".addAttribute( new XMLAttribute(\"" + keyXTag.xmlTagName + "\"," + codVar + ") );\r\n");
                        } else {
                            otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".addNode( new XMLNode(\"" + keyXTag.xmlTagName + "\"," + codVar + ") );\r\n");
                        }
                    } else {
                        otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".nodeText = " + codVar + ";\r\n");
                    }
                    if (selectTextXTag != null) {
                        if (selectTextXTag.isAttribute) {
                            otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".addAttribute( new XMLAttribute(\"" + selectTextXTag.xmlTagName + "\"," + valueVar + ") );\r\n");
                        } else if (keyXTag != null && selectTextXTag.xmlTagName.equalsIgnoreCase(selectTextXTag.parentXTag.xmlTagName)) {
                            otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".nodeText = " + valueVar + ";\r\n");
                        } else {
                            otherFuncs.append("\t\t" + currChildXTag.xmlTagName + ".addNode( new XMLNode(\"" + selectTextXTag.xmlTagName + "\"," + valueVar + ") );\r\n");
                        }
                    }
                    otherFuncs.append("\t}\r\n");
                    otherFuncs.append("\treturn " + currChildXTag.xmlTagName + ";\r\n");
                    otherFuncs.append("}\r\n");
                    break;
                }
                case 50: {
                    func.append("\t" + this.xmlTagName + ".addNode( get" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName) + "CheckList(" + xTagVar + ") );\r\n");
                    XTag elem = null;
                    XTag valueElem = null;
                    XTag textElem = null;
                    for (XTag currXMLElem : currChildXTag.childXTags) {
                        if (currXMLElem.sourceTagID == null) continue;
                        if (currXMLElem.sourceTagID.equalsIgnoreCase("-elem-")) {
                            elem = currXMLElem;
                        }
                        if (currXMLElem.sourceTagID.equalsIgnoreCase("-value-")) {
                            valueElem = currXMLElem;
                        }
                        if (!currXMLElem.sourceTagID.equalsIgnoreCase("-text-")) continue;
                        textElem = currXMLElem;
                    }
                    otherFuncs.append("function get" + StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName) + "CheckList(oXTag) {\r\n");
                    otherFuncs.append("\tvar elements = new XMLNode(\"" + currChildXTag.xmlTagName + "\");\r\n");
                    otherFuncs.append("\tvar oChecks = oXTag.getElementTag(\"" + currChildXTag.sourceTagID + "/element\");\r\n");
                    otherFuncs.append("\tvar oTexts = oXTag.getElementTag(\"" + currChildXTag.sourceTagID + "/elementTXT\");\r\n");
                    otherFuncs.append("\tif (oChecks != null && !oChecks.length) {\r\n");
                    otherFuncs.append("\t\toChecks = new Array(oChecks);\r\n");
                    otherFuncs.append("\t\toTexts = new Array(oTexts);\r\n");
                    otherFuncs.append("\t}\r\n");
                    otherFuncs.append("\tif (oChecks != null && oChecks.length) {\r\n");
                    otherFuncs.append("\t\tvar currCheckXML;\r\n");
                    otherFuncs.append("\t\tfor (var i=0; i<oChecks.length; i++) {\r\n");
                    otherFuncs.append("\t\t\tif (oChecks[i].checked) {\r\n");
                    otherFuncs.append("\t\t\t\tcurrCheckXML = new XMLNode(\"" + elem.xmlTagName + "\");\r\n");
                    if (valueElem.isAttribute) {
                        otherFuncs.append("\t\t\t\tcurrCheckXML.addAttribute( new XMLAttribute(\"" + valueElem.xmlTagName + "\",oChecks[i].value) );\r\n");
                    } else {
                        otherFuncs.append("\t\t\t\tcurrCheckXML.addNode( new XMLNode(\"" + valueElem.xmlTagName + "\",oChecks[i].value) );\r\n");
                    }
                    otherFuncs.append("\t\t\t\tif (oTexts[i].value != \"\")\r\n");
                    if (textElem.isAttribute) {
                        otherFuncs.append("\t\t\t\t\tcurrCheckXML.addAttribute( new XMLAttribute(\"" + textElem.xmlTagName + "\",oTexts[i].value) );\r\n");
                    } else if (textElem.xmlTagName.equalsIgnoreCase(elem.xmlTagName)) {
                        otherFuncs.append("\t\t\t\t\tcurrCheckXML.nodeText = oTexts[i].value;\r\n");
                    } else {
                        otherFuncs.append("\t\t\t\t\tcurrCheckXML.addNode( new XMLNode(\"" + textElem.xmlTagName + "\",oTexts[i].value) );\r\n");
                    }
                    otherFuncs.append("\t\t\t\telements.addNode( currCheckXML )\r\n");
                    otherFuncs.append("\t\t\t}\r\n");
                    otherFuncs.append("\t\t}\r\n");
                    otherFuncs.append("\t}\r\n");
                    otherFuncs.append("\treturn elements;\r\n");
                    otherFuncs.append("}\r\n");
                }
            }
        }
        func.append("\treturn " + this.xmlTagName + ";\r\n");
        func.append("}\r\n");
        func.append("\r\n");
        func.append(otherFuncs.toString());
        R01FLog.to("r01f.xTags").finest(func.toString());
        return func.toString();
    }

    private String _getClearControlsJavaScript() {
        StringBuffer func = new StringBuffer();
        StringBuffer otherFuncs = new StringBuffer();
        String xTagVar = "oXTag" + StringUtils.capitalizeFirstLetter(this.xmlTagName);
        String capName = StringUtils.capitalizeFirstLetter(this.xmlTagName);
        if (this.xmlTagName == null) {
            return "\r\n<script language='JavaScript'>alert('Error al obtener el JS: hay algun error en los xtags. Revisa el codigo')</script>";
        }
        func.append("function clear" + capName + "(div" + capName + ") {\r\n");
        func.append("\tvar " + xTagVar + " = new XTag(div" + capName + ");\r\n");
        for (XTag currChildXTag : this.childXTags) {
            String capElem = StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName);
            switch (currChildXTag.sourceTagType) {
                case 10: {
                    func.append("\tclear" + capElem + "( " + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "\") );\r\n");
                    otherFuncs.append(currChildXTag._getClearControlsJavaScript());
                    break;
                }
                case 11: {
                    if (currChildXTag.childXTags == null) break;
                    XTag listXTag = (XTag)currChildXTag.childXTags.get(0);
                    String divListName = "div" + capElem + "List";
                    String itName = "it" + capElem;
                    String childCapName = StringUtils.capitalizeFirstLetter(listXTag.xmlTagName);
                    func.append("\t" + divListName + " = " + xTagVar + ".getElementList(\"" + currChildXTag.sourceTagID + "\",\"" + listXTag.sourceTagID + "\");\r\n");
                    func.append("\tfor(var " + itName + "=0; " + itName + " < " + divListName + ".length; " + itName + "++) \r\n");
                    func.append("\t\tclear" + childCapName + "(" + divListName + "[" + itName + "]);\r\n");
                    otherFuncs.append(listXTag._getClearControlsJavaScript());
                    break;
                }
                case 20: 
                case 21: 
                case 23: 
                case 25: {
                    func.append("\t" + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "\").value = '';\r\n");
                    break;
                }
                case 24: {
                    func.append("\t" + currChildXTag.sourceTagID + ".setHTML('');\r\n");
                    break;
                }
                case 30: {
                    String optionsVar = String.valueOf(currChildXTag.sourceTagID.replace('/', '_')) + "Options";
                    func.append("\t" + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "\").selectedIndex = -1;\r\n");
                    func.append("\tvar " + optionsVar + " = " + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "\").options;\r\n");
                    func.append("\tif(" + optionsVar + " != null) { \r\n");
                    func.append("\t\tfor(var opt=0; opt < " + optionsVar + ".length; opt++) { \r\n");
                    func.append("\t\t\t" + optionsVar + "[opt].selected = false;\r\n");
                    func.append("\t\t}\r\n");
                    func.append("\t}\r\n");
                    break;
                }
                case 50: {
                    func.append("\tvar oChecks = " + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "/element\");\r\n");
                    func.append("\tif (oChecks != null && !oChecks.length) oChecks = new Array(oChecks);\r\n");
                    func.append("\tif (oChecks != null && oChecks.length) {\r\n");
                    func.append("\t\tfor (var i=0; i<oChecks.length; i++) oChecks[i].checked = false;\r\n");
                    func.append("\t}\r\n");
                }
            }
        }
        func.append("}\r\n");
        func.append("\r\n");
        func.append(otherFuncs.toString());
        R01FLog.to("r01f.xTags").finest(func.toString());
        return func.toString();
    }

    private String _getFormValidationJavaScript() {
        StringBuffer func = new StringBuffer();
        StringBuffer otherFuncs = new StringBuffer();
        String xTagVar = "oXTag" + StringUtils.capitalizeFirstLetter(this.xmlTagName);
        String capName = StringUtils.capitalizeFirstLetter(this.xmlTagName);
        if (this.xmlTagName == null) {
            return "\r\n<script language='JavaScript'>alert('Error al obtener el JS: hay algun error en los xtags. Revisa el codigo')</script>";
        }
        func.append("function validate" + capName + "(div" + capName + ") {\r\n");
        func.append("\tvar valid = true;\r\n");
        func.append("\tvar " + xTagVar + " = new XTag(div" + capName + ");\r\n");
        func.append("\tvar oCtrl = null;\r\n");
        func.append("\tvar oCtrlValue = null;\r\n");
        for (XTag currChildXTag : this.childXTags) {
            if (currChildXTag.sourceTagType != 10 && currChildXTag.sourceTagType != 11 && currChildXTag.check == null) continue;
            String capElem = StringUtils.capitalizeFirstLetter(currChildXTag.xmlTagName);
            if (currChildXTag.sourceTagType == 10) {
                func.append("\tvalid = valid & validate" + capElem + "( " + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "\") );\r\n");
                otherFuncs.append(currChildXTag._getFormValidationJavaScript());
                continue;
            }
            if (currChildXTag.sourceTagType == 11) {
                if (currChildXTag.childXTags == null) continue;
                XTag listXTag = (XTag)currChildXTag.childXTags.get(0);
                String divListName = "div" + capElem + "List";
                String itName = "it" + capElem;
                String childCapName = StringUtils.capitalizeFirstLetter(listXTag.xmlTagName);
                func.append("\t" + divListName + " = " + xTagVar + ".getElementList(\"" + currChildXTag.sourceTagID + "\",\"" + listXTag.sourceTagID + "\");\r\n");
                func.append("\tfor(var " + itName + "=0; " + itName + " < " + divListName + ".length; " + itName + "++) \r\n");
                func.append("\t\tvalid = valid & validate" + childCapName + "(" + divListName + "[" + itName + "]);\r\n");
                otherFuncs.append(listXTag._getFormValidationJavaScript());
                continue;
            }
            if (currChildXTag.check == null) continue;
            StringTokenizer st = new StringTokenizer(currChildXTag.check, ";");
            String[] conditions = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                conditions[i++] = st.nextToken();
            }
            func.append("\toCtrl = " + xTagVar + ".getElementTag(\"" + currChildXTag.sourceTagID + "\");\r\n");
            func.append("\toCtrlValue = " + xTagVar + ".getElement(\"" + currChildXTag.sourceTagID + "\");\r\n");
            i = 0;
            while (i < conditions.length) {
                if (conditions[i].equalsIgnoreCase("notNull")) {
                    func.append("\tif ((oCtrlValue.constructor == String && oCtrlValue == '') || (oCtrlValue.constructor == Array && oCtrlValue[\"codigo\"] == '')) {valid = false; oCtrl.focus(); return valid;}\r\n");
                }
                ++i;
            }
            switch (currChildXTag.sourceTagType) {
                case 20: 
                case 21: 
                case 23: 
                case 25: {
                    break;
                }
                case 24: {
                    break;
                }
                case 30: {
                    break;
                }
            }
        }
        func.append("\treturn valid;\r\n");
        func.append("}\r\n");
        func.append("\r\n");
        func.append(otherFuncs.toString());
        R01FLog.to("r01f.xTags").finest(func.toString());
        return func.toString();
    }

    public String getPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sourceTagID);
        XTag crawler = this.parentXTag;
        if (crawler != null) {
            while (crawler != null) {
                sb.insert(0, String.valueOf(crawler.sourceTagID) + ".");
                crawler = crawler.parentXTag;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return XTag._printDebugInfo(this, 0);
    }

    private static String _printDebugInfo(XTag xTag, int identation) {
        if (xTag == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        String strIdent = "";
        int i = 0;
        while (i < identation) {
            strIdent = String.valueOf(strIdent) + "\t";
            ++i;
        }
        sb.append(String.valueOf(strIdent) + "XMLTagName = " + xTag.xmlTagName + "\r\n");
        sb.append(String.valueOf(strIdent) + "SourceTagID = " + xTag.sourceTagID + "\r\n");
        sb.append(String.valueOf(strIdent) + "SourceTagType = " + xTag.sourceTagType + "\r\n");
        sb.append(String.valueOf(strIdent) + "Check = " + xTag.check + "\r\n");
        sb.append(String.valueOf(strIdent) + "isAttribute = " + xTag.isAttribute + "\r\n");
        sb.append(String.valueOf(strIdent) + "isCDATA = " + xTag.isCDATA + "\r\n");
        sb.append(String.valueOf(strIdent) + "________________________________________\r\n");
        if (xTag.childXTags != null) {
            ++identation;
            Iterator it = xTag.childXTags.iterator();
            while (it.hasNext()) {
                XTag._printDebugInfo((XTag)it.next(), identation);
            }
        }
        return sb.toString();
    }
}

