/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql.objects;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlbuilder.XMLNode;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class R01FQueryMap
implements Map {
    private Map _map;

    public R01FQueryMap() {
        this._map = new HashMap();
    }

    public R01FQueryMap(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            this._map = this.loadFromXML(is);
        }
        catch (SAXException saxEx) {
            this._map = null;
            throw new IllegalArgumentException(saxEx.getMessage());
        }
    }

    public R01FQueryMap(String inXMLStr) {
        if (inXMLStr == null) {
            return;
        }
        try {
            this._map = this.loadFromXML(new ByteArrayInputStream(inXMLStr.getBytes()));
        }
        catch (SAXException saxEx) {
            this._map = null;
            throw new IllegalArgumentException(saxEx.getMessage());
        }
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        XMLNode mapNode = new XMLNode("queries");
        if (this._map == null) {
            return mapNode.toString();
        }
        for (Map.Entry me : this._map.entrySet()) {
            XMLNode currNode = new XMLNode((String)me.getKey(), (String)me.getValue());
            mapNode.addSubNode(currNode);
        }
        return mapNode.toString();
    }

    public Map loadFromXML(InputStream is) throws SAXException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLMapLoader loader = new XMLMapLoader();
            saxParser.parse(is, (DefaultHandler)loader);
            return loader.entityMap;
        }
        catch (ParserConfigurationException pcEx) {
            throw new SAXException("Error en la configuraci\u00f3n del parser: " + pcEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new SAXException("Error de IO " + ioEx.getMessage());
        }
    }

    @Override
    public void clear() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        this._map.clear();
    }

    @Override
    public boolean containsKey(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.containsKey(obj);
    }

    @Override
    public boolean containsValue(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.containsValue(obj);
    }

    public Set entrySet() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.equals(obj);
    }

    public Object get(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.get(obj);
    }

    @Override
    public int hashCode() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.isEmpty();
    }

    public Set keySet() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.keySet();
    }

    public Object put(Object key, Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.put(key, obj);
    }

    public void putAll(Map map) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        this._map.putAll(map);
    }

    public Object remove(Object obj) {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.remove(obj);
    }

    @Override
    public int size() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.size();
    }

    public Collection values() {
        if (this._map == null) {
            throw new IllegalStateException("No se ha inicializado el objeto a partir de XML");
        }
        return this._map.values();
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream(new File(XMLProperties.get("r01d", "mapFiles/queries")));
            R01FQueryMap map = new R01FQueryMap(is);
            for (Map.Entry clave : map.entrySet()) {
                Map mapQuery = (Map)clave.getValue();
                R01FLog.to("r01f.test").fine("Entity:" + clave.getKey());
                for (Map.Entry clave2 : mapQuery.entrySet()) {
                    String strQuery = (String)clave2.getValue();
                    R01FLog.to("r01f.test").fine("\tQuery:" + clave2.getKey() + " - " + strQuery);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private class XMLMapLoader
    extends DefaultHandler {
        public Map entityMap;
        public Map queryMap;
        private final String QUERIES_TAG_NAME = "queries";
        private final String ENTITY_TAG_NAME = "entity";
        private final String QUERY_TAG_NAME = "query";
        private String _currNodeName = null;
        private String _currNodeValue = null;
        private String _currNodeEntityName = null;
        private String _currNodeQueryName = null;

        @Override
        public void startDocument() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
            this._currNodeName = lName;
            if ("".equals(this._currNodeName)) {
                this._currNodeName = qName;
            }
            if (this._currNodeName.equalsIgnoreCase("queries")) {
                this._currNodeName = null;
                this.entityMap = new HashMap();
                return;
            }
            if (this._currNodeName.equalsIgnoreCase("entity")) {
                this._currNodeEntityName = attrs.getValue("name");
                this.queryMap = new HashMap();
                return;
            }
            if (this._currNodeName.equalsIgnoreCase("query")) {
                this._currNodeQueryName = attrs.getValue("id");
                return;
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            this._currNodeValue = this._currNodeValue == null ? new String(buf, offset, len) : String.valueOf(this._currNodeValue) + new String(buf, offset, len);
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) {
            if (this._currNodeEntityName != null) {
                if (this._currNodeQueryName != null) {
                    if (this._currNodeValue == null) {
                        this._currNodeValue = "";
                    }
                    this.queryMap.put(this._currNodeQueryName, this._currNodeValue.trim());
                    this._currNodeQueryName = null;
                } else {
                    this.entityMap.put(this._currNodeEntityName, this.queryMap);
                    this.queryMap = null;
                    this._currNodeEntityName = null;
                }
                this._currNodeName = null;
                this._currNodeValue = null;
            }
        }

        @Override
        public void endDocument() {
        }
    }
}

