/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.sql.DBManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class QueryExecutor {
    private DBManager _dbManager;

    public QueryExecutor() {
    }

    public QueryExecutor(String appCode, String conxName) {
        this();
        this.init(appCode, conxName);
    }

    protected void init(String newAppCode, String conxName) {
        this._dbManager = new DBManager(newAppCode, conxName);
    }

    public List executeQuery(String querySql) throws SQLException {
        return this.executeQuery(querySql, null);
    }

    public List executeQuery(String querySql, List params) throws SQLException {
        List rdo = null;
        if (querySql != null) {
            rdo = this._dbManager.executeQuery(querySql, params);
            if (rdo == null) {
                R01FLog.to("r01f.sql").fine("La consulta " + querySql + " NO ha devuelto elementos.");
            } else {
                R01FLog.to("r01f.sql").fine("La consulta " + querySql + " ha devuelto " + rdo.size() + " elementos");
            }
        } else {
            R01FLog.to("r01f.sql").warning("Se ha intentado ejecutar una consulta NULA contra la base de datos");
        }
        return rdo;
    }

    public void executeInsert(String insertSQL) throws SQLException {
        this.executeInsert(insertSQL, null);
    }

    public void executeInsert(String insertSQL, List params) throws SQLException {
        if (insertSQL != null) {
            this._dbManager.executeStatement(insertSQL, params);
        } else {
            R01FLog.to("r01f.sql").warning("Se ha intentado ejecutar una insert NULA contra la base de datos");
        }
    }

    public void executeUpdate(String updateSQL) throws SQLException {
        this.executeUpdate(updateSQL, null);
    }

    public void executeUpdate(String updateSQL, List params) throws SQLException {
        if (updateSQL != null) {
            this._dbManager.executeStatement(updateSQL, params);
        } else {
            R01FLog.to("r01f.sql").warning("Se ha intentado ejecutar una update NULA contra la base de datos");
        }
    }

    public void executeDelete(String deleteSQL) throws SQLException {
        this.executeDelete(deleteSQL, null);
    }

    public void executeDelete(String deleteSQL, List params) throws SQLException {
        if (deleteSQL != null) {
            this._dbManager.executeStatement(deleteSQL, params);
        } else {
            R01FLog.to("r01f.sql").warning("Se ha intentado ejecutar una delete NULA contra la base de datos");
        }
    }

    public String loadCLOB(String tableName, String clobColumnName, Map pk) throws SQLException {
        String rdo = null;
        rdo = this._dbManager.loadCLOB(tableName, clobColumnName, pk);
        if (rdo == null) {
            R01FLog.to("r01f.sql").fine("La consulta de CLOB NO ha devuelto elementos.");
        } else {
            R01FLog.to("r01f.sql").fine("La consulta de CLOB ha devuelto elementos");
        }
        return rdo;
    }

    public static void main(String[] args) {
        try {
            long t1 = System.currentTimeMillis();
            int i = 0;
            while (i < 1) {
                ++i;
            }
            long t2 = System.currentTimeMillis();
            R01FLog.to("r01f.test").fine("\r\n\r\nTime Elapsed: " + (t2 - t1) / 1000L + "sg - " + (t2 - t2) + "msg");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

