/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.BLOBInputStream;
import com.ejie.r01f.sql.BLOBOutputStream;
import com.ejie.r01f.sql.CLOBReader;
import com.ejie.r01f.sql.CLOBWriter;
import com.ejie.r01f.sql.SQLHelpper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBManager {
    protected Properties _conxProps;
    protected Connection _conx = null;

    public DBManager() {
    }

    public DBManager(Properties conxProps) {
        this._conxProps = conxProps;
    }

    public DBManager(Connection conx) {
        this._conx = conx;
    }

    public DBManager(String appCode, String conxName) {
        this._conxProps = BDConnectionHelpper.obtainConnectionProperties(appCode, conxName);
    }

    public void finalice() {
        try {
            if (this._conx != null) {
                BDConnectionHelpper.closeConnection(this._conx);
                this._conx = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setConnectionProperties(Properties props) {
        this._conxProps = props;
    }

    public Properties getConnectionProperties() {
        return this._conxProps;
    }

    public void beginTransaction() throws SQLException {
        if (this._conxProps == null) {
            throw new SQLException("No se han establecido las propiedades para obtener la conexi\u00f3n (null)");
        }
        if (this._conx == null) {
            this._conx = BDConnectionHelpper.getConnection(this._conxProps);
        }
    }

    public void endTransaction() throws SQLException {
        if (this._conx != null) {
            this._conx.commit();
            BDConnectionHelpper.closeConnection(this._conx);
            this._conx = null;
        }
    }

    public void rollBackTransaction() throws SQLException {
        this._conx.rollback();
    }

    public void commit() throws SQLException {
        if (this._conx != null) {
            this._conx.commit();
        }
    }

    public List executeSelect(List columns, List tables, List params, String where, int[] orderColumns, boolean desc, boolean distinctRows) throws SQLException {
        String sql = SQLHelpper.composeSelect(columns, tables, where, orderColumns, desc, distinctRows);
        return this.executeQuery(sql, params);
    }

    public List executeQuery(String sql, List params) throws SQLException {
        Connection conx = null;
        Statement ps = null;
        ResultSet rs = null;
        if (sql == null) {
            throw new SQLException("La sentencia SQL no puede ser nula");
        }
        try {
            conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
            ps = conx.prepareStatement(sql);
            if (params != null) {
                int i = 0;
                while (i < params.size()) {
                    ps.setObject(i + 1, params.get(i));
                    ++i;
                }
            }
            rs = ps.executeQuery();
            List list = this._loadRows(rs);
            return list;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            ps = null;
            if (rs != null) {
                rs.close();
            }
            rs = null;
            if (this._conx == null && conx != null) {
                BDConnectionHelpper.closeConnection(conx);
                conx = null;
            }
        }
    }

    private List _loadRows(ResultSet rs) throws SQLException {
        ArrayList outList = null;
        if (rs != null && rs.next()) {
            outList = new ArrayList();
            do {
                HashMap<String, String> rowMap = new HashMap<String, String>(rs.getMetaData().getColumnCount());
                int i = 1;
                while (i <= rs.getMetaData().getColumnCount()) {
                    rowMap.put(rs.getMetaData().getColumnName(i).toUpperCase(), rs.getString(i));
                    ++i;
                }
                outList.add(rowMap);
            } while (rs.next());
        }
        return outList;
    }

    public int executeUpdate(List updateData, String table, String where, List params) throws SQLException {
        String sql = SQLHelpper.composeUpdate(updateData, table, where);
        return this.executeStatement(sql, params);
    }

    public int executeUpdate(String updateSQL) throws SQLException {
        return this.executeStatement(updateSQL, null);
    }

    public int executeInsert(List insertData, String table, List params) throws SQLException {
        String sql = SQLHelpper.composeInsert(insertData, table);
        return this.executeStatement(sql, params);
    }

    public int executeInsert(String insertSQL) throws SQLException {
        return this.executeStatement(insertSQL, null);
    }

    public int executeDelete(String table, String where, List params) throws SQLException {
        String sql = SQLHelpper.composeDelete(table, where);
        return this.executeStatement(sql, params);
    }

    public int executeDelete(String deleteSQL) throws SQLException {
        return this.executeStatement(deleteSQL, null);
    }

    public int executeStatement(String sql, List params) throws SQLException {
        Connection conx = null;
        Statement ps = null;
        if (sql == null) {
            throw new SQLException("La sentencia SQL no puede ser nula");
        }
        try {
            conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
            ps = conx.prepareStatement(sql);
            if (params != null) {
                int i = 0;
                while (i < params.size()) {
                    ps.setObject(i + 1, params.get(i));
                    ++i;
                }
            }
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            ps = null;
            if (this._conx == null && conx != null) {
                BDConnectionHelpper.closeConnection(conx);
                conx = null;
            }
        }
    }

    public boolean createNewSequence(String seqName, long startValue, int increment) throws SQLException {
        boolean bl;
        Connection conx;
        block5: {
            conx = null;
            Statement stmt = null;
            String strSql = null;
            try {
                strSql = "CREATE SEQUENCE " + seqName + " " + "START WITH " + startValue;
                conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
                stmt = conx.prepareStatement(strSql);
                bl = stmt.execute();
                if (stmt == null) break block5;
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    stmt.close();
                }
                if (this._conx == null && conx != null) {
                    BDConnectionHelpper.closeConnection(conx);
                    conx = null;
                }
                throw throwable;
            }
            stmt.close();
        }
        if (this._conx == null && conx != null) {
            BDConnectionHelpper.closeConnection(conx);
            conx = null;
        }
        return bl;
    }

    public long getSequenceNextValue(String seqName) throws SQLException {
        block9: {
            long l;
            Statement ps;
            Connection conx;
            block10: {
                conx = null;
                ps = null;
                ResultSet rs = null;
                if (seqName == null) {
                    throw new SQLException("El nombre de la secuencia no puede ser nulo");
                }
                String sql = null;
                try {
                    sql = "SELECT " + seqName + ".nextVal FROM DUAL";
                    conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
                    ps = conx.prepareStatement(sql);
                    ps.executeQuery();
                    rs = ps.getResultSet();
                    if (!rs.next()) break block9;
                    l = rs.getLong(1);
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this._conx == null && conx != null) {
                        BDConnectionHelpper.closeConnection(conx);
                        conx = null;
                    }
                    throw throwable;
                }
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
            if (this._conx == null && conx != null) {
                BDConnectionHelpper.closeConnection(conx);
                conx = null;
            }
            return l;
        }
        throw new SQLException("No se ha podido obtener un valor de la secuencia " + seqName);
    }

    public Writer getCLOBWriter(String tableName, String clobColumnName, Map pk) throws SQLException {
        Connection conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
        return new CLOBWriter(conx, this._conx == null && conx != null, tableName, clobColumnName, pk);
    }

    public void updateCLOB(String tableName, String clobColumnName, Map pk, String newValue) throws SQLException {
        Writer writer = this.getCLOBWriter(tableName, clobColumnName, pk);
        try {
            writer.write(newValue);
            writer.close();
        }
        catch (IOException ioEx) {
            throw new SQLException("No se ha podido actualizar el CLOB: Error de IO>> " + ioEx.toString());
        }
    }

    public OutputStream getBLOBOutputStream(String tableName, String blobColumnName, Map pk) throws SQLException {
        Connection conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
        return new BLOBOutputStream(conx, this._conx == null && conx != null, tableName, blobColumnName, pk);
    }

    public void updateBLOB(String tableName, String blobColumnName, Map pk, byte[] newValue) throws SQLException {
        OutputStream os = this.getBLOBOutputStream(tableName, blobColumnName, pk);
        try {
            os.write(newValue);
            os.close();
        }
        catch (IOException ioEx) {
            throw new SQLException("No se ha podido actualizar el BLOB: Error de IO>> " + ioEx.toString());
        }
    }

    public Reader getCLOBReader(String tableName, String clobColumnName, Map pk) throws SQLException {
        Connection conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
        return new CLOBReader(conx, this._conx == null && conx != null, tableName, clobColumnName, pk);
    }

    public String loadCLOB(String tableName, String clobColumnName, Map pk) throws SQLException {
        Reader r = this.getCLOBReader(tableName, clobColumnName, pk);
        try {
            StringBuffer sb = new StringBuffer();
            int c = -1;
            do {
                if ((c = r.read()) < 0) continue;
                sb.append((char)c);
            } while (c >= 0);
            r.close();
            return sb.toString();
        }
        catch (IOException ioEx) {
            throw new SQLException("No se ha podido leer el CLOB: " + ioEx.toString());
        }
    }

    public InputStream getBLOBInputStream(String tableName, String blobColumnName, Map pk) throws SQLException {
        Connection conx = this._conx == null ? BDConnectionHelpper.getConnection(this._conxProps) : this._conx;
        return new BLOBInputStream(conx, this._conx == null && conx != null, tableName, blobColumnName, pk);
    }

    public byte[] loadBLOB(String tableName, String blobColumnName, Map pk) throws SQLException {
        try {
            InputStream is = this.getBLOBInputStream(tableName, blobColumnName, pk);
            byte[] out = new byte[is.available()];
            is.read(out);
            is.close();
            return out;
        }
        catch (IOException ioEx) {
            throw new SQLException("No se ha podido leer el BLOB: " + ioEx.toString());
        }
    }
}

