/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.LOBHelpper;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

public class CLOBReader
extends Reader {
    Connection _conx = null;
    boolean _endConnection = true;
    String _tableName = null;
    String _lobColumnName = null;
    Map _pk = null;
    PreparedStatement _stmtRead = null;
    ResultSet _rsRead = null;
    Clob _clob = null;
    private Reader _clobReader = null;

    CLOBReader(Connection conx, boolean endConnection, String tableName, String lobColumnName, Map pk) throws SQLException {
        this._conx = conx;
        this._endConnection = endConnection;
        this._tableName = tableName;
        this._lobColumnName = lobColumnName;
        this._pk = pk;
        this._clobReader = this.obtainCLOBReader();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        if (this._clobReader != null) {
            c = this._clobReader.read();
        }
        return c;
    }

    @Override
    public int read(char[] c, int off, int len) throws IOException {
        int readed = -1;
        if (this._clobReader != null) {
            readed = this._clobReader.read(c, off, len);
        }
        return readed;
    }

    @Override
    public int read(char[] c) throws IOException {
        int readed = -1;
        if (this._clobReader != null) {
            readed = this._clobReader.read(c);
        }
        return readed;
    }

    @Override
    public long skip(long len) throws IOException {
        long skiped = -1L;
        if (this._clobReader != null) {
            skiped = this._clobReader.skip(len);
        }
        return skiped;
    }

    @Override
    public boolean ready() throws IOException {
        boolean ready = false;
        if (this._clobReader != null) {
            ready = this._clobReader.ready();
        }
        return ready;
    }

    @Override
    public void close() throws IOException {
        if (this._clobReader != null) {
            this._clobReader.close();
            this._clobReader = null;
        }
        try {
            if (this._clob != null) {
                this._clob.free();
                this._clob = null;
            }
            if (this._rsRead != null) {
                this._rsRead.close();
                this._rsRead = null;
            }
            if (this._stmtRead != null) {
                this._stmtRead.close();
                this._stmtRead = null;
            }
            if (this._endConnection && this._conx != null) {
                BDConnectionHelpper.closeConnection(this._conx);
                this._conx = null;
            }
        }
        catch (SQLException sqlEx) {
            throw new IOException("Error al cerrar la conexion a BD: " + sqlEx.toString());
        }
    }

    Reader obtainCLOBReader() throws SQLException {
        String sql = LOBHelpper.composeSelectSQL(this._tableName, this._lobColumnName, this._pk);
        this._stmtRead = this._conx.prepareStatement(sql);
        int i = 1;
        Iterator it = this._pk.values().iterator();
        while (it.hasNext()) {
            this._stmtRead.setString(i, (String)it.next());
            ++i;
        }
        this._stmtRead.executeQuery();
        this._rsRead = this._stmtRead.getResultSet();
        if (this._rsRead.next()) {
            Clob clob = LOBHelpper.castClob(this._rsRead.getClob(1));
            if (clob == null) {
                throw new SQLException("No se ha podido obtener un CLOB de la columna '" + this._lobColumnName + "' de la tabla '" + this._tableName + "'. " + "Probablemente antes hay que inicializar el CLOB con un EMPTY_CLOB()");
            }
            return clob.getCharacterStream();
        }
        throw new SQLException("No se ha encontrado la fila que contiene el CLOB. Es correcta la clave primaria suministrada?");
    }
}

