/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01f.sql;

import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01f.sql.LOBHelpper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

public class BLOBInputStream
extends InputStream {
    Connection _conx = null;
    boolean _endConnection = true;
    String _tableName = null;
    String _lobColumnName = null;
    Map _pk = null;
    PreparedStatement _stmtRead = null;
    ResultSet _rsRead = null;
    Blob _blob = null;
    private InputStream _blobInputStream = null;

    BLOBInputStream(Connection conx, boolean endConnection, String tableName, String lobColumnName, Map pk) throws SQLException {
        this._conx = conx;
        this._endConnection = endConnection;
        this._tableName = tableName;
        this._lobColumnName = lobColumnName;
        this._pk = pk;
        this._blobInputStream = this._obtainBLOBInputStream();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        int b = -1;
        if (this._blobInputStream != null) {
            b = this._blobInputStream.read();
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readed = -1;
        if (this._blobInputStream != null) {
            readed = this._blobInputStream.read(b, off, len);
        }
        return readed;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readed = -1;
        if (this._blobInputStream != null) {
            readed = this._blobInputStream.read(b);
        }
        return readed;
    }

    @Override
    public long skip(long len) throws IOException {
        long skiped = -1L;
        if (this._blobInputStream != null) {
            skiped = this._blobInputStream.skip(len);
        }
        return skiped;
    }

    @Override
    public int available() throws IOException {
        int available = 0;
        if (this._blobInputStream != null) {
            available = this._blobInputStream.available();
        }
        return available;
    }

    @Override
    public void close() throws IOException {
        if (this._blobInputStream != null) {
            this._blobInputStream.close();
            this._blobInputStream = null;
        }
        try {
            if (this._blob != null) {
                this._blob.free();
                this._blob = null;
            }
            if (this._rsRead != null) {
                this._rsRead.close();
                this._rsRead = null;
            }
            if (this._stmtRead != null) {
                this._stmtRead.close();
                this._stmtRead = null;
            }
            if (this._endConnection && this._conx != null) {
                BDConnectionHelpper.closeConnection(this._conx);
                this._conx = null;
            }
        }
        catch (SQLException sqlEx) {
            throw new IOException("Error al cerrar la conexion a BD: " + sqlEx.toString());
        }
    }

    InputStream _obtainBLOBInputStream() throws SQLException {
        String sql = LOBHelpper.composeSelectSQL(this._tableName, this._lobColumnName, this._pk);
        this._stmtRead = this._conx.prepareStatement(sql);
        int i = 1;
        Iterator it = this._pk.values().iterator();
        while (it.hasNext()) {
            this._stmtRead.setString(i, (String)it.next());
            ++i;
        }
        this._stmtRead.executeQuery();
        this._rsRead = this._stmtRead.getResultSet();
        if (this._rsRead.next()) {
            this._blob = LOBHelpper.castBlob(this._rsRead.getBlob(this._lobColumnName));
            if (this._blob == null) {
                throw new SQLException("No se ha podido obtener un BLOB de la columna '" + this._lobColumnName + "' de la tabla '" + this._tableName + "'. " + "Probablemente antes hay que inicializar el BLOB con un EMPTY_BLOB()");
            }
            return this._blob.getBinaryStream();
        }
        throw new SQLException("No se ha encontrado la fila que contiene el CLOB. Es correcta la clave primaria suministrada?");
    }
}

